export function noOccupancySince(endpoint: any, options: any, publish: any, action: any): void;
export function getOptions(definition: any, entity: any, options?: {}): {};
export function isLegacyEnabled(options: any): any;
export function precisionRound(number: any, precision: any): any;
export function toLocalISOString(dDate: any): string;
export function numberWithinRange(number: any, min: any, max: any): any;
/**
 * Maps number from one range to another. In other words it performs a linear interpolation.
 * Note that this function can interpolate values outside source range (linear extrapolation).
 * @param {number} value value to map
 * @param {number} fromLow source range lower value
 * @param {number} fromHigh source range upper value
 * @param {number} toLow target range lower value
 * @param {number} toHigh target range upper value
 * @param {number} [precision=0] number of decimal places to which result should be rounded
 * @return {number} value mapped to new range
 */
export function mapNumberRange(value: number, fromLow: number, fromHigh: number, toLow: number, toHigh: number, precision?: number): number;
export function hasAlreadyProcessedMessage(msg: any, model: any, ID?: any, key?: any): boolean;
export function calibrateAndPrecisionRoundOptions(number: any, options: any, type: any): any;
export function calibrateAndPrecisionRoundOptionsIsPercentual(type: any): any;
export namespace calibrateAndPrecisionRoundOptionsDefaultPrecision {
    const temperature: number;
    const humidity: number;
    const pressure: number;
    const pm25: number;
    const power: number;
    const current: number;
    const current_phase_b: number;
    const current_phase_c: number;
    const voltage: number;
    const voltage_phase_b: number;
    const voltage_phase_c: number;
    const power_phase_b: number;
    const power_phase_c: number;
    const energy: number;
}
export function toPercentage(value: any, min: any, max: any, log?: boolean): number;
export function addActionGroup(payload: any, msg: any, definition: any): void;
export function postfixWithEndpointName(value: any, msg: any, definition: any, meta: any): any;
export function enforceEndpoint(entity: any, key: any, meta: any): any;
export function getKey(object: any, value: any, fallback: any, convertTo: any): any;
export function getObjectProperty(object: any, key: any, defaultValue: any): any;
export function batteryVoltageToPercentage(voltage: any, option: any): number;
export function getEntityOrFirstGroupMember(entity: any): any;
export function getTransition(entity: any, key: any, meta: any): {
    time: number;
    specified: boolean;
};
export function getMetaValue(entity: any, definition: any, key: any, groupStrategy?: string, defaultValue?: any): any;
export function validateValue(value: any, allowed: any): void;
export function hasEndpoints(device: any, endpoints: any): boolean;
export function isInRange(min: any, max: any, value: any): boolean;
export function replaceInArray(arr: any, oldElements: any, newElements: any): any[];
export function filterObject(obj: any, keys: any): {};
export function saveSceneState(entity: any, sceneID: any, groupID: any, state: any, name: any): void;
export function sleep(ms: any): Promise<any>;
export function toSnakeCase(value: any): any;
export function toCamelCase(value: any): any;
export function normalizeCelsiusVersionOfFahrenheit(value: any): string;
export function deleteSceneState(entity: any, sceneID?: any, groupID?: any): void;
export function getSceneState(entity: any, sceneID: any, groupID: any): any;
export function extendDevice(deviceConfigs: any, modelName: any, adjustments: any): any;
export function attachOutputCluster(device: any, clusterKey: any): void;
/**
 * @param {number} value
 * @param {number} hexLength
 * @return {string}
 */
export function printNumberAsHex(value: number, hexLength: number): string;
/**
 * @param {number[]} numbers
 * @param {number} hexLength
 * @return {string}
 */
export function printNumbersAsHexSequence(numbers: number[], hexLength: number): string;
/**
 * @param {logger} logger
 * @param {vendor} vendor
 * @param {key} key
 * @returns {(level: string, message: string) => void}
 */
export function createLogger(logger: any, vendor: any, key: any): (level: string, message: string) => void;
//# sourceMappingURL=utils.d.ts.map