/*
 * Decompiled with CFR 0.152.
 */
package scala.collection.mutable;

import java.util.Arrays;
import scala.collection.mutable.HashEntry;
import scala.runtime.BoxesRunTime;
import scala.runtime.Statics;

public interface HashTable<A, B, Entry extends HashEntry<A, Entry>>
extends HashUtils<A> {
    public int _loadFactor();

    public void _loadFactor_$eq(int var1);

    public HashEntry<A, Entry>[] table();

    public void table_$eq(HashEntry<A, Entry>[] var1);

    public int tableSize();

    public void tableSize_$eq(int var1);

    public int threshold();

    public void threshold_$eq(int var1);

    public int[] sizemap();

    public void sizemap_$eq(int[] var1);

    public int seedvalue();

    public void seedvalue_$eq(int var1);

    public static /* synthetic */ int tableSizeSeed$(HashTable $this) {
        return $this.tableSizeSeed();
    }

    default public int tableSizeSeed() {
        return Integer.bitCount(this.table().length - 1);
    }

    public static /* synthetic */ int initialSize$(HashTable $this) {
        return $this.initialSize();
    }

    default public int initialSize() {
        return 16;
    }

    /*
     * WARNING - void declaration
     */
    private int initialThreshold(int _loadFactor) {
        void var1_1;
        return (int)((long)this.initialCapacity() * (long)var1_1 / 1000L);
    }

    /*
     * WARNING - void declaration
     */
    private int initialCapacity() {
        void var1_1;
        int capacity_expectedSize = this.initialSize();
        return 1 << -Integer.numberOfLeadingZeros((int)(var1_1 - true));
    }

    /*
     * WARNING - void declaration
     */
    public static /* synthetic */ HashEntry findEntry$(HashTable $this, Object key) {
        void var1_1;
        return $this.findEntry(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    default public Entry findEntry(A key) {
        void var1_1;
        HashTable hashTable = this;
        return this.findEntry0(key, hashTable.index(hashTable.elemHashCode(var1_1)));
    }

    /*
     * WARNING - void declaration
     */
    public static /* synthetic */ HashEntry findEntry0$(HashTable $this, Object key, int h) {
        void var2_2;
        void var1_1;
        return $this.findEntry0(var1_1, (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    default public Entry findEntry0(A key, int h) {
        void var2_3;
        for (HashEntry<A, Object> e = this.table()[h]; e != null && !this.elemEquals(e.key(), key); e = e.next()) {
        }
        return var2_3;
    }

    /*
     * WARNING - void declaration
     */
    public static /* synthetic */ void addEntry0$(HashTable $this, HashEntry e, int h) {
        void var2_2;
        void var1_1;
        $this.addEntry0(var1_1, (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    default public void addEntry0(Entry e, int h) {
        void var2_2;
        void var1_1;
        e.next_$eq(this.table()[h]);
        this.table()[h] = var1_1;
        HashTable hashTable = this;
        hashTable.tableSize_$eq(hashTable.tableSize() + 1);
        this.nnSizeMapAdd((int)var2_2);
        if (this.tableSize() > this.threshold()) {
            this.resize(2 * this.table().length);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static /* synthetic */ HashEntry findOrAddEntry$(HashTable $this, Object key, Object value) {
        void var2_2;
        void var1_1;
        return $this.findOrAddEntry(var1_1, var2_2);
    }

    /*
     * WARNING - void declaration
     */
    default public Entry findOrAddEntry(A key, B value) {
        void var3_3;
        void var2_2;
        void var1_1;
        HashTable hashTable = this;
        int h = hashTable.index(hashTable.elemHashCode(key));
        Entry e = this.findEntry0(key, h);
        if (e != null) {
            return e;
        }
        HashTable hashTable2 = this;
        hashTable2.addEntry0(hashTable2.createNewEntry(var1_1, var2_2), (int)var3_3);
        return null;
    }

    public Entry createNewEntry(A var1, B var2);

    /*
     * WARNING - void declaration
     */
    public static /* synthetic */ HashEntry removeEntry$(HashTable $this, Object key) {
        void var1_1;
        return $this.removeEntry(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    default public Entry removeEntry(A key) {
        void var1_1;
        HashTable hashTable = this;
        return this.removeEntry0(key, hashTable.index(hashTable.elemHashCode(var1_1)));
    }

    /*
     * WARNING - void declaration
     */
    public static /* synthetic */ HashEntry removeEntry0$(HashTable $this, Object key, int h) {
        void var2_2;
        void var1_1;
        return $this.removeEntry0(var1_1, (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    default public Entry removeEntry0(A key, int h) {
        HashEntry<A, Object> e = this.table()[h];
        if (e != null) {
            Object e1;
            if (this.elemEquals(e.key(), key)) {
                this.table()[h] = e.next();
                HashTable hashTable = this;
                hashTable.tableSize_$eq(hashTable.tableSize() - 1);
                this.nnSizeMapRemove(h);
                e.next_$eq(null);
                return (Entry)e;
            }
            for (e1 = e.next(); e1 != null && !this.elemEquals(e1.key(), key); e1 = e1.next()) {
                e = e1;
            }
            if (e1 != null) {
                void var2_2;
                void var3_3;
                var3_3.next_$eq(e1.next());
                HashTable hashTable = this;
                hashTable.tableSize_$eq(hashTable.tableSize() - 1);
                this.nnSizeMapRemove((int)var2_2);
                e1.next_$eq(null);
                return (Entry)e1;
            }
        }
        return null;
    }

    public static /* synthetic */ void clearTable$(HashTable $this) {
        $this.clearTable();
    }

    default public void clearTable() {
        for (int i = this.table().length - 1; i >= 0; --i) {
            this.table()[i] = null;
        }
        this.tableSize_$eq(0);
        this.nnSizeMapReset(0);
    }

    /*
     * WARNING - void declaration
     */
    private void resize(int newSize) {
        void var2_3;
        void var1_1;
        HashEntry<A, Entry>[] oldTable = this.table();
        this.table_$eq(new HashEntry[newSize]);
        HashTable hashTable = this;
        hashTable.nnSizeMapReset(hashTable.table().length);
        for (int i = oldTable.length - 1; i >= 0; --i) {
            HashEntry<A, Object> e = oldTable[i];
            while (e != null) {
                HashTable hashTable2 = this;
                int h = hashTable2.index(hashTable2.elemHashCode(e.key()));
                Entry e1 = e.next();
                e.next_$eq(this.table()[h]);
                this.table()[h] = e;
                e = e1;
                this.nnSizeMapAdd(h);
            }
        }
        int newThreshold__loadFactor = this._loadFactor();
        this.threshold_$eq((int)((long)var1_1 * (long)var2_3 / 1000L));
    }

    /*
     * WARNING - void declaration
     */
    public static /* synthetic */ void nnSizeMapAdd$(HashTable $this, int h) {
        void var1_1;
        $this.nnSizeMapAdd((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    default public void nnSizeMapAdd(int h) {
        if (this.sizemap() != null) {
            void var1_1;
            int[] nArray = this.sizemap();
            nArray[var1_1 >>= 5] = nArray[var1_1] + 1;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static /* synthetic */ void nnSizeMapRemove$(HashTable $this, int h) {
        void var1_1;
        $this.nnSizeMapRemove((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    default public void nnSizeMapRemove(int h) {
        if (this.sizemap() != null) {
            void var1_1;
            int[] nArray = this.sizemap();
            nArray[var1_1 >>= 5] = nArray[var1_1] - 1;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static /* synthetic */ void nnSizeMapReset$(HashTable $this, int tableLength) {
        void var1_1;
        $this.nnSizeMapReset((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    default public void nnSizeMapReset(int tableLength) {
        if (this.sizemap() != null) {
            void var1_1;
            var1_1 = (var1_1 >> 5) + true;
            if (this.sizemap().length != var1_1) {
                this.sizemap_$eq(new int[var1_1]);
                return;
            }
            Arrays.fill(this.sizemap(), 0);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static /* synthetic */ boolean elemEquals$(HashTable $this, Object key1, Object key2) {
        void var2_2;
        void var1_1;
        return $this.elemEquals(var1_1, var2_2);
    }

    /*
     * WARNING - void declaration
     */
    default public boolean elemEquals(A key1, A key2) {
        void var2_2;
        return BoxesRunTime.equals(key1, var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public static /* synthetic */ int index$(HashTable $this, int hcode) {
        void var1_1;
        return $this.index((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    default public int index(int hcode) {
        void var2_2;
        void var3_3;
        void var1_1;
        int ones = this.table().length - 1;
        int exponent = Integer.numberOfLeadingZeros(ones);
        return this.improve((int)var1_1, this.seedvalue()) >>> var3_3 & var2_2;
    }

    public static void $init$(HashTable $this) {
        HashTable hashTable;
        $this._loadFactor_$eq(750);
        HashTable hashTable2 = $this;
        hashTable2.table_$eq(new HashEntry[hashTable2.initialCapacity()]);
        $this.tableSize_$eq(0);
        HashTable hashTable3 = $this;
        hashTable3.threshold_$eq(hashTable3.initialThreshold($this._loadFactor()));
        $this.sizemap_$eq(null);
        HashTable hashTable4 = hashTable;
        hashTable4.seedvalue_$eq(hashTable4.tableSizeSeed());
    }

    public static interface HashUtils<KeyType> {
        /*
         * WARNING - void declaration
         */
        public static /* synthetic */ int elemHashCode$(HashUtils $this, Object key) {
            void var1_1;
            return $this.elemHashCode(var1_1);
        }

        default public int elemHashCode(KeyType key) {
            return Statics.anyHash(key);
        }

        /*
         * WARNING - void declaration
         */
        public static /* synthetic */ int improve$(HashUtils $this, int hcode, int seed) {
            void var2_2;
            void var1_1;
            return $this.improve((int)var1_1, (int)var2_2);
        }

        /*
         * WARNING - void declaration
         */
        default public int improve(int hcode, int seed) {
            void var2_2;
            void var1_1;
            return Integer.rotateRight(Integer.reverseBytes((int)(var1_1 * -1640532531)) * -1640532531, (int)var2_2);
        }
    }
}

