
#ifndef KXMLGUI_EXPORT_H
#define KXMLGUI_EXPORT_H

#ifdef KXMLGUI_STATIC_DEFINE
#  define KXMLGUI_EXPORT
#  define KXMLGUI_NO_EXPORT
#else
#  ifndef KXMLGUI_EXPORT
#    ifdef KF6XmlGui_EXPORTS
        /* We are building this library */
#      define KXMLGUI_EXPORT __attribute__((visibility("default")))
#    else
        /* We are using this library */
#      define KXMLGUI_EXPORT __attribute__((visibility("default")))
#    endif
#  endif

#  ifndef KXMLGUI_NO_EXPORT
#    define KXMLGUI_NO_EXPORT __attribute__((visibility("hidden")))
#  endif
#endif

#ifndef KXMLGUI_DECL_DEPRECATED
#  define KXMLGUI_DECL_DEPRECATED __attribute__ ((__deprecated__))
#endif

#ifndef KXMLGUI_DECL_DEPRECATED_EXPORT
#  define KXMLGUI_DECL_DEPRECATED_EXPORT KXMLGUI_EXPORT KXMLGUI_DECL_DEPRECATED
#endif

#ifndef KXMLGUI_DECL_DEPRECATED_NO_EXPORT
#  define KXMLGUI_DECL_DEPRECATED_NO_EXPORT KXMLGUI_NO_EXPORT KXMLGUI_DECL_DEPRECATED
#endif

/* NOLINTNEXTLINE(readability-avoid-unconditional-preprocessor-if) */
#if 0 /* DEFINE_NO_DEPRECATED */
#  ifndef KXMLGUI_NO_DEPRECATED
#    define KXMLGUI_NO_DEPRECATED
#  endif
#endif
#include <kxmlgui_version.h>

#define KXMLGUI_DECL_DEPRECATED_TEXT(text) __attribute__ ((__deprecated__(text)))

/* Take any defaults from group settings */
#if !defined(KXMLGUI_NO_DEPRECATED) && !defined(KXMLGUI_DISABLE_DEPRECATED_BEFORE_AND_AT)
#  ifdef KF_NO_DEPRECATED
#    define KXMLGUI_NO_DEPRECATED
#  elif defined(KF_DISABLE_DEPRECATED_BEFORE_AND_AT)
#    define KXMLGUI_DISABLE_DEPRECATED_BEFORE_AND_AT KF_DISABLE_DEPRECATED_BEFORE_AND_AT
#  endif
#endif
#if !defined(KXMLGUI_DISABLE_DEPRECATED_BEFORE_AND_AT) && defined(KF_DISABLE_DEPRECATED_BEFORE_AND_AT)
#  define KXMLGUI_DISABLE_DEPRECATED_BEFORE_AND_AT KF_DISABLE_DEPRECATED_BEFORE_AND_AT
#endif

#if !defined(KXMLGUI_NO_DEPRECATED_WARNINGS) && !defined(KXMLGUI_DEPRECATED_WARNINGS_SINCE)
#  ifdef KF_NO_DEPRECATED_WARNINGS
#    define KXMLGUI_NO_DEPRECATED_WARNINGS
#  elif defined(KF_DEPRECATED_WARNINGS_SINCE)
#    define KXMLGUI_DEPRECATED_WARNINGS_SINCE KF_DEPRECATED_WARNINGS_SINCE
#  endif
#endif
#if !defined(KXMLGUI_DEPRECATED_WARNINGS_SINCE) && defined(KF_DEPRECATED_WARNINGS_SINCE)
#  define KXMLGUI_DEPRECATED_WARNINGS_SINCE KF_DEPRECATED_WARNINGS_SINCE
#endif

#if defined(KXMLGUI_NO_DEPRECATED)
#  undef KXMLGUI_DEPRECATED
#  define KXMLGUI_DEPRECATED_EXPORT KXMLGUI_EXPORT
#  define KXMLGUI_DEPRECATED_NO_EXPORT KXMLGUI_NO_EXPORT
#elif defined(KXMLGUI_NO_DEPRECATED_WARNINGS)
#  define KXMLGUI_DEPRECATED
#  define KXMLGUI_DEPRECATED_EXPORT KXMLGUI_EXPORT
#  define KXMLGUI_DEPRECATED_NO_EXPORT KXMLGUI_NO_EXPORT
#else
#  define KXMLGUI_DEPRECATED KXMLGUI_DECL_DEPRECATED
#  define KXMLGUI_DEPRECATED_EXPORT KXMLGUI_DECL_DEPRECATED_EXPORT
#  define KXMLGUI_DEPRECATED_NO_EXPORT KXMLGUI_DECL_DEPRECATED_NO_EXPORT
#endif

/* No deprecated API had been removed from build */
#define KXMLGUI_EXCLUDE_DEPRECATED_BEFORE_AND_AT 0

#define KXMLGUI_BUILD_DEPRECATED_SINCE(major, minor) 1

#ifdef KXMLGUI_NO_DEPRECATED
#  define KXMLGUI_DISABLE_DEPRECATED_BEFORE_AND_AT KXMLGUI_VERSION
#endif
#ifdef KXMLGUI_NO_DEPRECATED_WARNINGS
#  define KXMLGUI_DEPRECATED_WARNINGS_SINCE 0
#endif

#ifndef KXMLGUI_DEPRECATED_WARNINGS_SINCE
#  ifdef KXMLGUI_DISABLE_DEPRECATED_BEFORE_AND_AT
#    define KXMLGUI_DEPRECATED_WARNINGS_SINCE KXMLGUI_DISABLE_DEPRECATED_BEFORE_AND_AT
#  else
#    define KXMLGUI_DEPRECATED_WARNINGS_SINCE KXMLGUI_VERSION
#  endif
#endif

#ifndef KXMLGUI_DISABLE_DEPRECATED_BEFORE_AND_AT
#  define KXMLGUI_DISABLE_DEPRECATED_BEFORE_AND_AT 0
#endif

#ifdef KXMLGUI_DEPRECATED
#  define KXMLGUI_ENABLE_DEPRECATED_SINCE(major, minor) (((major<<16)|(minor<<8)) > KXMLGUI_DISABLE_DEPRECATED_BEFORE_AND_AT)
#else
#  define KXMLGUI_ENABLE_DEPRECATED_SINCE(major, minor) 0
#endif

#endif /* KXMLGUI_EXPORT_H */
