/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.remoting.transport;

import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.infinispan.remoting.transport.ResponseCollector;
import org.infinispan.remoting.transport.impl.Request;
import org.infinispan.remoting.transport.impl.RequestRepository;

public abstract class AbstractRequest<T>
extends CompletableFuture<T>
implements Callable<Void>,
Request<T> {
    protected final ResponseCollector<T> responseCollector;
    protected final long requestId;
    protected final RequestRepository repository;
    private volatile Future<?> timeoutFuture = null;

    protected AbstractRequest(long requestId, ResponseCollector<T> responseCollector, RequestRepository repository) {
        this.responseCollector = responseCollector;
        this.repository = repository;
        this.requestId = requestId;
    }

    protected abstract void onTimeout();

    @Override
    public final long getRequestId() {
        return this.requestId;
    }

    public void setTimeout(ScheduledExecutorService timeoutExecutor, long timeout, TimeUnit unit) {
        this.cancelTimeoutTask();
        ScheduledFuture<Void> timeoutFuture = timeoutExecutor.schedule(this, timeout, unit);
        this.setTimeoutFuture(timeoutFuture);
    }

    @Override
    public void cancel(Exception exception) {
        this.completeExceptionally(exception);
    }

    @Override
    public boolean complete(T value) {
        this.cancelTimeoutTask();
        this.repository.removeRequest(this.requestId);
        return super.complete(value);
    }

    @Override
    public boolean completeExceptionally(Throwable ex) {
        this.cancelTimeoutTask();
        this.repository.removeRequest(this.requestId);
        return super.completeExceptionally(ex);
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        this.cancelTimeoutTask();
        this.repository.removeRequest(this.requestId);
        return super.cancel(mayInterruptIfRunning);
    }

    @Override
    public final Void call() throws Exception {
        this.onTimeout();
        return null;
    }

    private void setTimeoutFuture(Future<?> timeoutFuture) {
        this.timeoutFuture = timeoutFuture;
        if (this.isDone()) {
            timeoutFuture.cancel(false);
        }
    }

    private void cancelTimeoutTask() {
        if (this.timeoutFuture != null) {
            this.timeoutFuture.cancel(false);
        }
    }
}

