/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration.parsing;

import java.beans.PropertyEditor;
import java.beans.PropertyEditorManager;
import java.io.ByteArrayInputStream;
import java.io.StringWriter;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.infinispan.commons.CacheConfigurationException;
import org.infinispan.commons.configuration.attributes.Attribute;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.commons.util.BeanUtils;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class XmlConfigHelper {
    private static final Log log = LogFactory.getLog(XmlConfigHelper.class);

    public static Element stringToElement(String xml) throws Exception {
        ByteArrayInputStream bais = new ByteArrayInputStream(xml.getBytes("utf8"));
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document d = builder.parse(bais);
        bais.close();
        return d.getDocumentElement();
    }

    public static Object valueConverter(Class klass, String value) {
        if (klass == Integer.class) {
            return Integer.valueOf(value);
        }
        if (klass == Long.class) {
            return Long.valueOf(value);
        }
        if (klass == Boolean.class) {
            return Boolean.valueOf(value);
        }
        if (klass == String.class) {
            return value;
        }
        if (klass == Float.class) {
            return Float.valueOf(value);
        }
        if (klass == Double.class) {
            return Double.valueOf(value);
        }
        if (klass.isEnum()) {
            return Enum.valueOf(klass, value);
        }
        throw new CacheConfigurationException("Cannot convert " + value + " to type " + klass.getName());
    }

    public static Map<Object, Object> setAttributes(AttributeSet attributes, Map<?, ?> attribs, boolean isXmlAttribs, boolean failOnMissingAttribute) {
        HashMap<Object, Object> ignoredAttribs = new HashMap<Object, Object>();
        for (Map.Entry<?, ?> entry : attribs.entrySet()) {
            String name = (String)entry.getKey();
            if (attributes.contains(name)) {
                Attribute attribute = attributes.attribute(name);
                attribute.set(XmlConfigHelper.valueConverter(attribute.getAttributeDefinition().getType(), (String)entry.getValue()));
                continue;
            }
            if (failOnMissingAttribute) {
                throw new CacheConfigurationException("Couldn't find an attribute named [" + name + "] on attribute set [" + attributes.getName() + "]");
            }
            ignoredAttribs.put(name, entry.getValue());
        }
        return ignoredAttribs;
    }

    public static Map<Object, Object> setValues(Object target, Map<?, ?> attribs, boolean isXmlAttribs, boolean failOnMissingSetter) {
        Class<?> objectClass = target.getClass();
        HashMap<Object, Object> ignoredAttribs = new HashMap<Object, Object>();
        for (Map.Entry<?, ?> entry : attribs.entrySet()) {
            String propName = (String)entry.getKey();
            String setter = BeanUtils.setterName((String)propName);
            String fluentSetter = BeanUtils.fluentSetterName((String)propName);
            try {
                Method method;
                if (isXmlAttribs) {
                    method = objectClass.getMethod(setter, Element.class);
                    method.invoke(target, entry.getValue());
                    continue;
                }
                method = objectClass.getMethod(setter, String.class);
                method.invoke(target, entry.getValue());
                continue;
            }
            catch (NoSuchMethodException method) {
            }
            catch (Exception e) {
                throw new CacheConfigurationException("Unable to invoke setter " + setter + " on " + objectClass, (Throwable)e);
            }
            boolean setterFound = false;
            for (Method m : objectClass.getMethods()) {
                if (!setter.equals(m.getName()) && !fluentSetter.equals(m.getName())) continue;
                Class<?>[] paramTypes = m.getParameterTypes();
                if (paramTypes.length != 1) {
                    log.tracef("Rejecting setter %s on class %s due to incorrect number of parameters", m, objectClass);
                    continue;
                }
                Class<?> parameterType = paramTypes[0];
                if (parameterType.equals(Class.class)) {
                    log.tracef("Rejecting setter %s on class %s due to class parameter is type class", m, objectClass);
                    continue;
                }
                PropertyEditor editor = PropertyEditorManager.findEditor(parameterType);
                if (editor == null) {
                    throw new CacheConfigurationException("Couldn't find a property editor for parameter type " + parameterType);
                }
                editor.setAsText((String)attribs.get(propName));
                Object parameter = editor.getValue();
                try {
                    m.invoke(target, parameter);
                    setterFound = true;
                    break;
                }
                catch (Exception e) {
                    throw new CacheConfigurationException("Unable to invoke setter " + setter + " on " + objectClass, (Throwable)e);
                }
            }
            if (setterFound || propName.startsWith("infinispan.client.hotrod")) continue;
            if (failOnMissingSetter) {
                throw new CacheConfigurationException("Couldn't find a setter named [" + setter + "] which takes a single parameter, for parameter " + propName + " on class [" + objectClass + "]");
            }
            ignoredAttribs.put(propName, attribs.get(propName));
        }
        return ignoredAttribs;
    }

    public static void showUnrecognizedAttributes(Map<Object, Object> attribs) {
        for (Object propName : attribs.keySet()) {
            log.unrecognizedAttribute((String)propName);
        }
    }

    public static String toString(Element e) {
        try {
            TransformerFactory tfactory = TransformerFactory.newInstance();
            Transformer xform = tfactory.newTransformer();
            DOMSource src = new DOMSource(e);
            StringWriter writer = new StringWriter();
            StreamResult result = new StreamResult(writer);
            xform.transform(src, result);
            return writer.toString();
        }
        catch (Exception ex) {
            return "Unable to convert to string: " + ex.toString();
        }
    }
}

