/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.managers;

import org.jboss.logging.Logger;
import org.keycloak.common.util.MultivaluedHashMap;
import org.keycloak.models.KeycloakSession;
import org.keycloak.services.ServicesLogger;
import org.keycloak.storage.ldap.LDAPConfig;
import org.keycloak.storage.ldap.idm.store.ldap.LDAPContextManager;

public class LDAPConnectionTestManager {
    private static final Logger logger = Logger.getLogger(LDAPConnectionTestManager.class);
    public static final String TEST_CONNECTION = "testConnection";
    public static final String TEST_AUTHENTICATION = "testAuthentication";

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean testLDAP(KeycloakSession session, String action, String connectionUrl, String bindDn, String bindCredential, String useTruststoreSpi, String connectionTimeout, String tls) {
        if (!TEST_CONNECTION.equals(action) && !TEST_AUTHENTICATION.equals(action)) {
            ServicesLogger.LOGGER.unknownAction(action);
            return false;
        }
        MultivaluedHashMap ldapConfig = new MultivaluedHashMap();
        if (connectionUrl == null) {
            logger.errorf("Unknown connection URL", new Object[0]);
            return false;
        }
        ldapConfig.putSingle((Object)"connectionUrl", (Object)connectionUrl);
        ldapConfig.putSingle((Object)"useTruststoreSpi", (Object)useTruststoreSpi);
        ldapConfig.putSingle((Object)"connectionTimeout", (Object)connectionTimeout);
        ldapConfig.putSingle((Object)"startTls", (Object)tls);
        if (TEST_AUTHENTICATION.equals(action)) {
            if (bindDn == null) {
                logger.error((Object)"Unknown bind DN");
                return false;
            }
            ldapConfig.putSingle((Object)"authType", (Object)"simple");
            ldapConfig.putSingle((Object)"bindDn", (Object)bindDn);
            ldapConfig.putSingle((Object)"bindCredential", (Object)bindCredential);
        } else {
            ldapConfig.putSingle((Object)"authType", (Object)"none");
        }
        try (LDAPContextManager ldapContextManager = LDAPContextManager.create((KeycloakSession)session, (LDAPConfig)new LDAPConfig(ldapConfig));){
            ldapContextManager.getLdapContext();
            boolean throwable3 = true;
            return throwable3;
        }
        catch (Exception ne) {
            String errorMessage = TEST_AUTHENTICATION.equals(action) ? "Error when authenticating to LDAP: " : "Error when connecting to LDAP: ";
            ServicesLogger.LOGGER.errorAuthenticating(ne, errorMessage + ne.getMessage());
            return false;
        }
    }
}

