/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.broker.saml.mappers;

import java.util.ArrayList;
import java.util.List;
import org.keycloak.broker.provider.AbstractIdentityProviderMapper;
import org.keycloak.broker.provider.BrokeredIdentityContext;
import org.keycloak.broker.provider.IdentityBrokerException;
import org.keycloak.dom.saml.v2.assertion.AssertionType;
import org.keycloak.dom.saml.v2.assertion.AttributeStatementType;
import org.keycloak.dom.saml.v2.assertion.AttributeType;
import org.keycloak.models.IdentityProviderMapperModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.provider.ProviderConfigProperty;

public class AttributeToRoleMapper
extends AbstractIdentityProviderMapper {
    public static final String[] COMPATIBLE_PROVIDERS = new String[]{"saml"};
    private static final List<ProviderConfigProperty> configProperties = new ArrayList<ProviderConfigProperty>();
    public static final String ATTRIBUTE_NAME = "attribute.name";
    public static final String ATTRIBUTE_FRIENDLY_NAME = "attribute.friendly.name";
    public static final String ATTRIBUTE_VALUE = "attribute.value";
    public static final String PROVIDER_ID = "saml-role-idp-mapper";

    public List<ProviderConfigProperty> getConfigProperties() {
        return configProperties;
    }

    public String getId() {
        return PROVIDER_ID;
    }

    public String[] getCompatibleProviders() {
        return COMPATIBLE_PROVIDERS;
    }

    public String getDisplayCategory() {
        return "Role Mapper";
    }

    public String getDisplayType() {
        return "SAML Attribute to Role";
    }

    public void importNewUser(KeycloakSession session, RealmModel realm, UserModel user, IdentityProviderMapperModel mapperModel, BrokeredIdentityContext context) {
        String roleName = (String)mapperModel.getConfig().get("role");
        if (this.isAttributePresent(mapperModel, context)) {
            RoleModel role = KeycloakModelUtils.getRoleFromString((RealmModel)realm, (String)roleName);
            if (role == null) {
                throw new IdentityBrokerException("Unable to find role: " + roleName);
            }
            user.grantRole(role);
        }
    }

    protected boolean isAttributePresent(IdentityProviderMapperModel mapperModel, BrokeredIdentityContext context) {
        String friendly;
        String name = (String)mapperModel.getConfig().get(ATTRIBUTE_NAME);
        if (name != null && name.trim().equals("")) {
            name = null;
        }
        if ((friendly = (String)mapperModel.getConfig().get(ATTRIBUTE_FRIENDLY_NAME)) != null && friendly.trim().equals("")) {
            friendly = null;
        }
        String desiredValue = (String)mapperModel.getConfig().get(ATTRIBUTE_VALUE);
        AssertionType assertion = (AssertionType)context.getContextData().get("SAML_ASSERTION");
        for (AttributeStatementType statement : assertion.getAttributeStatements()) {
            for (AttributeStatementType.ASTChoiceType choice : statement.getAttributes()) {
                AttributeType attr = choice.getAttribute();
                if (name != null && !name.equals(attr.getName()) || friendly != null && !friendly.equals(attr.getFriendlyName())) continue;
                for (Object val : attr.getAttributeValue()) {
                    if (!val.equals(desiredValue)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public void updateBrokeredUser(KeycloakSession session, RealmModel realm, UserModel user, IdentityProviderMapperModel mapperModel, BrokeredIdentityContext context) {
        String roleName = (String)mapperModel.getConfig().get("role");
        RoleModel role = KeycloakModelUtils.getRoleFromString((RealmModel)realm, (String)roleName);
        if (role == null) {
            throw new IdentityBrokerException("Unable to find role: " + roleName);
        }
        if (!this.isAttributePresent(mapperModel, context)) {
            user.deleteRoleMapping(role);
        } else {
            user.grantRole(role);
        }
    }

    public String getHelpText() {
        return "If a claim exists, grant the user the specified realm or application role.";
    }

    static {
        ProviderConfigProperty property = new ProviderConfigProperty();
        property.setName(ATTRIBUTE_NAME);
        property.setLabel("Attribute Name");
        property.setHelpText("Name of attribute to search for in assertion.  You can leave this blank and specify a friendly name instead.");
        property.setType("String");
        configProperties.add(property);
        property = new ProviderConfigProperty();
        property.setName(ATTRIBUTE_FRIENDLY_NAME);
        property.setLabel("Friendly Name");
        property.setHelpText("Friendly name of attribute to search for in assertion.  You can leave this blank and specify a name instead.");
        property.setType("String");
        configProperties.add(property);
        property = new ProviderConfigProperty();
        property.setName(ATTRIBUTE_VALUE);
        property.setLabel("Attribute Value");
        property.setHelpText("Value the attribute must have.  If the attribute is a list, then the value must be contained in the list.");
        property.setType("String");
        configProperties.add(property);
        property = new ProviderConfigProperty();
        property.setName("role");
        property.setLabel("Role");
        property.setHelpText("Role to grant to user.  Click 'Select Role' button to browse roles, or just type it in the textbox.  To reference an application role the syntax is appname.approle, i.e. myapp.myrole");
        property.setType("Role");
        configProperties.add(property);
    }
}

