/*
 * Decompiled with CFR 0.152.
 */
package liquibase.util;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import liquibase.exception.UnexpectedLiquibaseException;
import liquibase.util.StringClauses;
import liquibase.util.grammar.CharStream;
import liquibase.util.grammar.SimpleSqlGrammar;
import liquibase.util.grammar.Token;

public class SqlParser {
    public static StringClauses parse(String sqlBlock) {
        return SqlParser.parse(sqlBlock, false, false);
    }

    public static StringClauses parse(String sqlBlock, boolean preserveWhitespace, boolean preserveComments) {
        StringClauses clauses = new StringClauses(preserveWhitespace ? "" : " ");
        SimpleSqlGrammar t = new SimpleSqlGrammar(new SqlCharStream(new StringReader(sqlBlock)));
        try {
            Token token = t.getNextToken();
            while (!token.toString().equals("")) {
                if (token.kind == 1) {
                    if (preserveWhitespace) {
                        clauses.append(new StringClauses.Whitespace(token.image));
                    }
                } else if (token.kind == 2 || token.kind == 3) {
                    if (preserveComments) {
                        String comment = token.image;
                        if (!preserveWhitespace && token.kind == 2 && !comment.endsWith("\n")) {
                            comment = comment + "\n";
                        }
                        clauses.append(new StringClauses.Comment(comment));
                    }
                } else {
                    clauses.append(token.image);
                }
                token = t.getNextToken();
            }
        }
        catch (Exception e) {
            throw new UnexpectedLiquibaseException(e);
        }
        return clauses;
    }

    public static class SqlCharStream
    implements CharStream {
        char[] buffer = null;
        int bufferLength = 0;
        int bufferPosition = 0;
        int tokenStart = 0;
        int bufferStart = 0;
        Reader input;

        public SqlCharStream(Reader r) {
            this.input = r;
        }

        @Override
        public final char readChar() throws IOException {
            if (this.bufferPosition >= this.bufferLength) {
                this.refill();
            }
            return this.buffer[this.bufferPosition++];
        }

        private final void refill() throws IOException {
            int newPosition = this.bufferLength - this.tokenStart;
            if (this.tokenStart == 0) {
                if (this.buffer == null) {
                    this.buffer = new char[2048];
                } else if (this.bufferLength == this.buffer.length) {
                    char[] newBuffer = new char[this.buffer.length * 2];
                    System.arraycopy(this.buffer, 0, newBuffer, 0, this.bufferLength);
                    this.buffer = newBuffer;
                }
            } else {
                System.arraycopy(this.buffer, this.tokenStart, this.buffer, 0, newPosition);
            }
            this.bufferLength = newPosition;
            this.bufferPosition = newPosition;
            this.bufferStart += this.tokenStart;
            this.tokenStart = 0;
            int charsRead = this.input.read(this.buffer, newPosition, this.buffer.length - newPosition);
            if (charsRead == -1) {
                throw new IOException("read past eof");
            }
            this.bufferLength += charsRead;
        }

        @Override
        public final char BeginToken() throws IOException {
            this.tokenStart = this.bufferPosition;
            return this.readChar();
        }

        @Override
        public final void backup(int amount) {
            this.bufferPosition -= amount;
        }

        @Override
        public final String GetImage() {
            return new String(this.buffer, this.tokenStart, this.bufferPosition - this.tokenStart);
        }

        @Override
        public final char[] GetSuffix(int len) {
            char[] value = new char[len];
            System.arraycopy(this.buffer, this.bufferPosition - len, value, 0, len);
            return value;
        }

        @Override
        public final void Done() {
            try {
                this.input.close();
            }
            catch (IOException e) {
                System.err.println("Caught: " + e + "; ignoring.");
            }
        }

        @Override
        public final int getColumn() {
            return this.bufferStart + this.bufferPosition;
        }

        @Override
        public final int getLine() {
            return 1;
        }

        @Override
        public final int getEndColumn() {
            return this.bufferStart + this.bufferPosition;
        }

        @Override
        public final int getEndLine() {
            return 1;
        }

        @Override
        public final int getBeginColumn() {
            return this.bufferStart + this.tokenStart;
        }

        @Override
        public final int getBeginLine() {
            return 1;
        }
    }
}

