/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.metadata.ejb.parser.spec;

import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.jboss.metadata.ejb.parser.spec.AbstractMetaDataParser;
import org.jboss.metadata.ejb.parser.spec.AssemblyDescriptorMetaDataParser;
import org.jboss.metadata.ejb.parser.spec.AssemblyDescriptorMetaDataParserFactory;
import org.jboss.metadata.ejb.parser.spec.EjbJarAttribute;
import org.jboss.metadata.ejb.parser.spec.EjbJarElement;
import org.jboss.metadata.ejb.parser.spec.EnterpriseBeansMetaDataParser;
import org.jboss.metadata.ejb.parser.spec.InterceptorsMetaDataParser;
import org.jboss.metadata.ejb.parser.spec.RelationsMetaDataParser;
import org.jboss.metadata.ejb.spec.EjbJarMetaData;
import org.jboss.metadata.ejb.spec.EjbJarVersion;
import org.jboss.metadata.ejb.spec.EnterpriseBeansMetaData;
import org.jboss.metadata.ejb.spec.InterceptorsMetaData;
import org.jboss.metadata.ejb.spec.RelationsMetaData;
import org.jboss.metadata.javaee.spec.DescriptionGroupMetaData;
import org.jboss.metadata.parser.ee.Accessor;
import org.jboss.metadata.parser.ee.DescriptionGroupMetaDataParser;
import org.jboss.metadata.property.PropertyReplacer;

public abstract class AbstractEjbJarMetaDataParser
extends AbstractMetaDataParser<EjbJarMetaData> {
    protected void processAttribute(EjbJarMetaData ejbJarMetaData, XMLStreamReader reader, int i) throws XMLStreamException {
        String value = reader.getAttributeValue(i);
        if (AbstractEjbJarMetaDataParser.attributeHasNamespace((XMLStreamReader)reader, (int)i)) {
            return;
        }
        EjbJarAttribute ejbJarAttribute = EjbJarAttribute.forName(reader.getAttributeLocalName(i));
        switch (ejbJarAttribute) {
            case ID: {
                ejbJarMetaData.setId(value);
                break;
            }
            case VERSION: {
                ejbJarMetaData.setVersion(value);
                break;
            }
            case METADATA_COMPLETE: {
                if (ejbJarMetaData.isEJB3x()) {
                    if (!Boolean.TRUE.equals(Boolean.valueOf(value))) break;
                    ejbJarMetaData.setMetadataComplete(true);
                    break;
                }
                throw AbstractEjbJarMetaDataParser.unexpectedAttribute((XMLStreamReader)reader, (int)i);
            }
            default: {
                throw AbstractEjbJarMetaDataParser.unexpectedAttribute((XMLStreamReader)reader, (int)i);
            }
        }
    }

    protected void processAttributes(EjbJarMetaData ejbJarMetaData, XMLStreamReader reader) throws XMLStreamException {
        int count = reader.getAttributeCount();
        for (int i = 0; i < count; ++i) {
            this.processAttribute(ejbJarMetaData, reader, i);
        }
    }

    @Override
    protected void processElement(final EjbJarMetaData ejbJarMetaData, XMLStreamReader reader, PropertyReplacer propertyReplacer) throws XMLStreamException {
        EjbJarElement ejbJarElement = EjbJarElement.forName(reader.getLocalName());
        switch (ejbJarElement) {
            case MODULE_NAME: {
                if (ejbJarMetaData.isVersionGreaterThanOrEqual(EjbJarVersion.EJB_3_1)) {
                    String moduleName = AbstractEjbJarMetaDataParser.getElementText((XMLStreamReader)reader, (PropertyReplacer)propertyReplacer);
                    ejbJarMetaData.setModuleName(moduleName);
                    break;
                }
                throw AbstractEjbJarMetaDataParser.unexpectedElement((XMLStreamReader)reader);
            }
            case ENTERPRISE_BEANS: {
                EnterpriseBeansMetaData enterpriseBeans = EnterpriseBeansMetaDataParser.parse(reader, ejbJarMetaData.getEjbJarVersion(), propertyReplacer);
                if (enterpriseBeans != null) {
                    enterpriseBeans.setEjbJarMetaData(ejbJarMetaData);
                }
                ejbJarMetaData.setEnterpriseBeans(enterpriseBeans);
                break;
            }
            case INTERCEPTORS: {
                if (ejbJarMetaData.isEJB3x()) {
                    InterceptorsMetaData intercpetors = InterceptorsMetaDataParser.INSTANCE.parse(reader, propertyReplacer);
                    ejbJarMetaData.setInterceptors(intercpetors);
                    break;
                }
                throw AbstractEjbJarMetaDataParser.unexpectedElement((XMLStreamReader)reader);
            }
            case RELATIONSHIPS: {
                RelationsMetaData relations = RelationsMetaDataParser.parse(reader, propertyReplacer);
                ejbJarMetaData.setRelationships(relations);
                break;
            }
            case ASSEMBLY_DESCRIPTOR: {
                AssemblyDescriptorMetaDataParser assemblyDescriptorParser = AssemblyDescriptorMetaDataParserFactory.getParser(ejbJarMetaData.getEjbJarVersion());
                ejbJarMetaData.setAssemblyDescriptor(assemblyDescriptorParser.parse(reader, propertyReplacer));
                break;
            }
            case EJB_CLIENT_JAR: {
                String ejbClientJar = AbstractEjbJarMetaDataParser.getElementText((XMLStreamReader)reader, (PropertyReplacer)propertyReplacer);
                ejbJarMetaData.setEjbClientJar(ejbClientJar);
                break;
            }
            default: {
                Accessor<DescriptionGroupMetaData> accessor = new Accessor<DescriptionGroupMetaData>(){

                    public DescriptionGroupMetaData get() {
                        DescriptionGroupMetaData descriptionGroup = ejbJarMetaData.getDescriptionGroup();
                        if (descriptionGroup == null) {
                            descriptionGroup = new DescriptionGroupMetaData();
                            ejbJarMetaData.setDescriptionGroup(descriptionGroup);
                        }
                        return descriptionGroup;
                    }
                };
                if (DescriptionGroupMetaDataParser.parse((XMLStreamReader)reader, (Accessor)accessor, (PropertyReplacer)propertyReplacer)) break;
                throw AbstractEjbJarMetaDataParser.unexpectedElement((XMLStreamReader)reader);
            }
        }
    }

    protected static EjbJarVersion readVersionAttribute(XMLStreamReader reader) throws XMLStreamException {
        EjbJarVersion ejbJarVersion = null;
        String versionString = null;
        int count = reader.getAttributeCount();
        for (int i = 0; i < count; ++i) {
            EjbJarAttribute ejbJarVersionAttribute;
            if (AbstractEjbJarMetaDataParser.attributeHasNamespace((XMLStreamReader)reader, (int)i) || (ejbJarVersionAttribute = EjbJarAttribute.forName(reader.getAttributeLocalName(i))) != EjbJarAttribute.VERSION) continue;
            versionString = reader.getAttributeValue(i);
        }
        if ("1.1".equals(versionString)) {
            ejbJarVersion = EjbJarVersion.EJB_1_1;
        } else if ("2.0".equals(versionString)) {
            ejbJarVersion = EjbJarVersion.EJB_2_0;
        } else if ("2.1".equals(versionString)) {
            ejbJarVersion = EjbJarVersion.EJB_2_1;
        } else if ("3.0".equals(versionString)) {
            ejbJarVersion = EjbJarVersion.EJB_3_0;
        } else if ("3.1".equals(versionString)) {
            ejbJarVersion = EjbJarVersion.EJB_3_1;
        } else if ("3.2".equals(versionString)) {
            ejbJarVersion = EjbJarVersion.EJB_3_2;
        }
        return ejbJarVersion;
    }
}

