/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cli.impl.aesh.cmd.security;

import java.util.Iterator;
import java.util.function.Function;
import org.aesh.command.Command;
import org.jboss.as.cli.CommandContext;
import org.jboss.as.cli.CommandFormatException;
import org.jboss.as.cli.accesscontrol.AccessRequirement;
import org.jboss.as.cli.operation.OperationRequestAddress;
import org.jboss.as.cli.operation.impl.DefaultCallbackHandler;
import org.jboss.as.cli.operation.impl.DefaultOperationRequestAddress;
import org.jboss.as.cli.parsing.ParserUtil;
import org.wildfly.core.cli.command.aesh.CLICommandInvocation;

public abstract class AbstractControlledCommand
implements Command<CLICommandInvocation> {
    private AccessRequirement accessRequirement;
    private OperationRequestAddress requiredAddress;
    private boolean dependsOnProfile;
    private String requiredType;
    private final CommandContext ctx;
    private final Function<CommandContext, AccessRequirement> acBuilder;

    protected AbstractControlledCommand(CommandContext ctx, Function<CommandContext, AccessRequirement> acBuilder) {
        this.ctx = ctx;
        this.acBuilder = acBuilder;
    }

    public CommandContext getCommandContext() {
        return this.ctx;
    }

    protected final void addRequiredPath(String requiredPath) {
        if (requiredPath == null) {
            throw new IllegalArgumentException("Required path can't be null.");
        }
        DefaultOperationRequestAddress requiredAddress = new DefaultOperationRequestAddress();
        DefaultCallbackHandler handler = new DefaultCallbackHandler(requiredAddress);
        try {
            ParserUtil.parseOperationRequest(requiredPath, handler);
        }
        catch (CommandFormatException e) {
            throw new IllegalArgumentException("Failed to parse nodeType: " + e.getMessage());
        }
        this.addRequiredPath(requiredAddress);
    }

    protected void addRequiredPath(OperationRequestAddress requiredPath) {
        if (requiredPath == null) {
            throw new IllegalArgumentException("Required path can't be null.");
        }
        if (this.requiredAddress != null) {
            throw new IllegalStateException("Only one required address is allowed, atm.");
        }
        this.requiredAddress = requiredPath;
        Iterator iterator = this.requiredAddress.iterator();
        if (iterator.hasNext()) {
            String firstType = ((OperationRequestAddress.Node)iterator.next()).getType();
            boolean bl = this.dependsOnProfile = "subsystem".equals(firstType) || "profile".equals(firstType);
        }
        if (this.requiredAddress.endsOnType()) {
            this.requiredType = this.requiredAddress.toParentNode().getType();
        }
    }

    public OperationRequestAddress getRequiredAddress() {
        return this.requiredAddress;
    }

    public boolean isDependsOnProfile() {
        return this.dependsOnProfile;
    }

    public AccessRequirement getAccessRequirement() {
        if (this.accessRequirement == null) {
            this.accessRequirement = this.acBuilder.apply(this.ctx);
        }
        return this.accessRequirement;
    }

    public String getRequiredType() {
        return this.requiredType;
    }
}

