/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols.pbcast;

import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import org.jgroups.Address;
import org.jgroups.Message;
import org.jgroups.View;
import org.jgroups.protocols.pbcast.GMS;
import org.jgroups.protocols.pbcast.GmsImpl;
import org.jgroups.protocols.pbcast.MergeData;
import org.jgroups.stack.Protocol;
import org.jgroups.util.Digest;
import org.jgroups.util.MergeId;
import org.jgroups.util.Promise;

public abstract class ServerGmsImpl
extends GmsImpl {
    protected ServerGmsImpl(GMS gms) {
        super(gms);
    }

    @Override
    public void init() throws Exception {
        super.init();
    }

    @Override
    public void merge(Map<Address, View> views) {
        this.merger.merge(views);
    }

    @Override
    public void handleMergeRequest(Address sender, MergeId merge_id, Collection<? extends Address> mbrs) {
        this.merger.handleMergeRequest(sender, merge_id, mbrs);
    }

    @Override
    public void handleMergeResponse(MergeData data, MergeId merge_id) {
        this.merger.handleMergeResponse(data, merge_id);
    }

    @Override
    public void handleMergeCancelled(MergeId merge_id) {
        this.merger.handleMergeCancelled(merge_id);
    }

    @Override
    public void handleViewChange(View view, Digest digest) {
        if (this.gms.isLeaving() && !view.containsMember(this.gms.local_addr)) {
            return;
        }
        View prev_view = this.gms.view();
        this.gms.installView(view, digest);
        Address prev_coord = prev_view != null ? prev_view.getCoord() : null;
        Address curr_coord = view.getCoord();
        if (!Objects.equals(curr_coord, prev_coord)) {
            this.coordChanged(prev_coord, curr_coord);
        }
    }

    @Override
    public void handleMergeView(MergeData data, MergeId merge_id) {
        this.merger.handleMergeView(data, merge_id);
    }

    @Override
    public void handleDigestResponse(Address sender, Digest digest) {
        this.merger.handleDigestResponse(sender, digest);
    }

    protected void coordChanged(Address from, Address to) {
    }

    protected boolean sendLeaveReqToCoord(Address coord) {
        if (coord == null) {
            this.log.warn("%s: cannot send LEAVE request to null coord", this.gms.getLocalAddress());
            return false;
        }
        Promise<Address> leave_promise = this.gms.getLeavePromise();
        this.gms.setLeaving(true);
        this.log.trace("%s: sending LEAVE request to %s", this.gms.local_addr, coord);
        long start = System.currentTimeMillis();
        this.sendLeaveMessage(coord, this.gms.local_addr);
        Address sender = leave_promise.getResult(this.gms.leave_timeout);
        if (!Objects.equals(coord, sender)) {
            return false;
        }
        long time = System.currentTimeMillis() - start;
        if (sender != null) {
            this.log.trace("%s: got LEAVE response from %s in %d ms", this.gms.local_addr, coord, time);
        } else {
            this.log.trace("%s: timed out waiting for LEAVE response from %s (after %d ms)", this.gms.local_addr, coord, time);
        }
        return true;
    }

    protected void sendLeaveMessage(Address coord, Address mbr) {
        Message msg = new Message(coord).setFlag(Message.Flag.OOB).putHeader(this.gms.getId(), new GMS.GmsHeader(3, mbr));
        ((Protocol)this.gms.getDownProtocol()).down(msg);
    }
}

