/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authorization.permission.evaluator;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.keycloak.authorization.AuthorizationProvider;
import org.keycloak.authorization.Decision;
import org.keycloak.authorization.model.Policy;
import org.keycloak.authorization.model.ResourceServer;
import org.keycloak.authorization.permission.ResourcePermission;
import org.keycloak.authorization.permission.evaluator.PermissionEvaluator;
import org.keycloak.authorization.policy.evaluation.DecisionPermissionCollector;
import org.keycloak.authorization.policy.evaluation.EvaluationContext;
import org.keycloak.authorization.policy.evaluation.PolicyEvaluator;
import org.keycloak.authorization.store.StoreFactory;
import org.keycloak.representations.idm.authorization.AuthorizationRequest;
import org.keycloak.representations.idm.authorization.Permission;

class IterablePermissionEvaluator
implements PermissionEvaluator {
    private final Iterator<ResourcePermission> permissions;
    private final EvaluationContext executionContext;
    private final PolicyEvaluator policyEvaluator;
    private final AuthorizationProvider authorizationProvider;

    IterablePermissionEvaluator(Iterator<ResourcePermission> permissions, EvaluationContext executionContext, AuthorizationProvider authorizationProvider) {
        this.permissions = permissions;
        this.executionContext = executionContext;
        this.authorizationProvider = authorizationProvider;
        this.policyEvaluator = authorizationProvider.getPolicyEvaluator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Decision evaluate(Decision decision) {
        StoreFactory storeFactory = this.authorizationProvider.getStoreFactory();
        try {
            HashMap<Policy, Map<Object, Decision.Effect>> decisionCache = new HashMap<Policy, Map<Object, Decision.Effect>>();
            storeFactory.setReadOnly(true);
            while (this.permissions.hasNext()) {
                this.policyEvaluator.evaluate(this.permissions.next(), this.authorizationProvider, this.executionContext, decision, decisionCache);
            }
            decision.onComplete();
        }
        catch (Throwable cause) {
            decision.onError(cause);
        }
        finally {
            storeFactory.setReadOnly(false);
        }
        return decision;
    }

    @Override
    public Collection<Permission> evaluate(ResourceServer resourceServer, AuthorizationRequest request) {
        DecisionPermissionCollector decision = new DecisionPermissionCollector(this.authorizationProvider, resourceServer, request);
        this.evaluate(decision);
        return decision.results();
    }
}

