/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.host.controller.operations;

import java.util.Map;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationDefinition;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.RunningMode;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleOperationDefinitionBuilder;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.host.controller.HostControllerEnvironment;
import org.jboss.as.host.controller.HostRunningModeControl;
import org.jboss.as.host.controller.RestartMode;
import org.jboss.as.host.controller.ServerInventory;
import org.jboss.as.host.controller.logging.HostControllerLogger;
import org.jboss.as.host.controller.resources.ServerConfigResourceDefinition;
import org.jboss.as.process.ProcessInfo;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.dmr.Property;
import org.wildfly.security.manager.WildFlySecurityManager;

public class StartServersHandler
implements OperationStepHandler {
    public static final boolean START_BLOCKING = Boolean.parseBoolean(WildFlySecurityManager.getPropertyPrivileged((String)"org.jboss.as.host.start.servers.sequential", (String)"false"));
    public static final String OPERATION_NAME = "start-servers";
    public static final OperationDefinition DEFINITION = new SimpleOperationDefinitionBuilder("start-servers", null).setPrivateEntry().build();
    private final ServerInventory serverInventory;
    private final HostControllerEnvironment hostControllerEnvironment;
    private final HostRunningModeControl runningModeControl;
    public static final AttributeDefinition ENABLE_AUTO_START = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"enabled-auto-start", (ModelType)ModelType.BOOLEAN).setRequired(false)).setDefaultValue(ModelNode.FALSE)).build();

    public StartServersHandler(HostControllerEnvironment hostControllerEnvironment, ServerInventory serverInventory, HostRunningModeControl runningModeControl) {
        this.hostControllerEnvironment = hostControllerEnvironment;
        this.serverInventory = serverInventory;
        this.runningModeControl = runningModeControl;
    }

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        final boolean enabledAutoStart = ENABLE_AUTO_START.resolveModelAttribute(context, operation).asBoolean();
        if (!context.isBooting() && !enabledAutoStart) {
            throw new OperationFailedException(HostControllerLogger.ROOT_LOGGER.invocationNotAllowedAfterBoot(operation.require("operation")));
        }
        if (context.getRunningMode() == RunningMode.ADMIN_ONLY) {
            throw new OperationFailedException(HostControllerLogger.ROOT_LOGGER.cannotStartServersInvalidMode(context.getRunningMode()));
        }
        if (enabledAutoStart) {
            context.acquireControllerLock();
        }
        final ModelNode domainModel = Resource.Tools.readModel((Resource)context.readResourceFromRoot(PathAddress.EMPTY_ADDRESS, true));
        context.addStep(new OperationStepHandler(){

            public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                Resource resource = context.readResource(PathAddress.EMPTY_ADDRESS);
                ModelNode hostModel = Resource.Tools.readModel((Resource)resource);
                if (hostModel.hasDefined("server-config")) {
                    ModelNode servers = hostModel.get("server-config").clone();
                    if (StartServersHandler.this.hostControllerEnvironment.isRestart() || StartServersHandler.this.runningModeControl.getRestartMode() == RestartMode.HC_ONLY) {
                        StartServersHandler.this.restartedHcStartOrReconnectServers(servers, domainModel, context, enabledAutoStart);
                        StartServersHandler.this.runningModeControl.setRestartMode(RestartMode.SERVERS);
                    } else if (enabledAutoStart) {
                        StartServersHandler.this.cleanStartServers(servers, domainModel, context);
                    }
                }
                context.completeStep(OperationContext.RollbackHandler.NOOP_ROLLBACK_HANDLER);
            }
        }, OperationContext.Stage.RUNTIME);
    }

    private void cleanStartServers(ModelNode servers, ModelNode domainModel, OperationContext context) throws OperationFailedException {
        Map<String, ProcessInfo> processInfos = this.serverInventory.determineRunningProcesses();
        for (Property serverProp : servers.asPropertyList()) {
            String serverName = serverProp.getName();
            if (!ServerConfigResourceDefinition.AUTO_START.resolveModelAttribute(context, serverProp.getValue()).asBoolean(true)) continue;
            ProcessInfo info = processInfos.get(this.serverInventory.getServerProcessName(serverName));
            if (info != null) {
                this.serverInventory.reconnectServer(serverName, domainModel, info.getAuthKey(), info.isRunning(), info.isStopping());
                continue;
            }
            try {
                this.serverInventory.startServer(serverName, domainModel, START_BLOCKING, false);
            }
            catch (Exception e) {
                HostControllerLogger.ROOT_LOGGER.failedToStartServer(e, serverName);
            }
        }
    }

    private void restartedHcStartOrReconnectServers(ModelNode servers, ModelNode domainModel, OperationContext context, boolean enabledAutoStart) {
        Map<String, ProcessInfo> processInfos = this.serverInventory.determineRunningProcesses();
        for (String serverName : servers.keys()) {
            ProcessInfo info = processInfos.get(this.serverInventory.getServerProcessName(serverName));
            boolean auto = servers.get(new String[]{serverName, "auto-start"}).asBoolean(true);
            if (info == null && auto && enabledAutoStart) {
                try {
                    this.serverInventory.startServer(serverName, domainModel, START_BLOCKING, false);
                }
                catch (Exception e) {
                    HostControllerLogger.ROOT_LOGGER.failedToStartServer(e, serverName);
                }
                continue;
            }
            if (info == null) continue;
            this.serverInventory.reconnectServer(serverName, domainModel, info.getAuthKey(), info.isRunning(), info.isStopping());
        }
    }
}

