/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.model.hierarchy;

import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.protege.editor.owl.model.hierarchy.AbstractOWLObjectHierarchyProvider;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLObjectInverseOf;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyChange;
import org.semanticweb.owlapi.model.OWLOntologyChangeListener;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.model.OWLPropertyExpression;
import org.semanticweb.owlapi.model.OWLPropertyExpressionVisitorEx;
import org.semanticweb.owlapi.model.OWLPropertyRange;
import org.semanticweb.owlapi.model.OWLSubPropertyAxiom;
import org.semanticweb.owlapi.search.EntitySearcher;

public abstract class AbstractOWLPropertyHierarchyProvider<R extends OWLPropertyRange, E extends OWLPropertyExpression, P extends E>
extends AbstractOWLObjectHierarchyProvider<P> {
    private ReentrantReadWriteLock.ReadLock ontologySetReadLock;
    private ReentrantReadWriteLock.WriteLock ontologySetWriteLock;
    private Set<OWLOntology> ontologies;
    private Set<P> subPropertiesOfRoot = new HashSet<P>();
    private OWLOntologyChangeListener listener;

    public AbstractOWLPropertyHierarchyProvider(OWLOntologyManager owlOntologyManager) {
        super(owlOntologyManager);
        this.ontologies = new FakeSet<OWLOntology>();
        ReentrantReadWriteLock locks = new ReentrantReadWriteLock();
        this.ontologySetReadLock = locks.readLock();
        this.ontologySetWriteLock = locks.writeLock();
        this.listener = this::handleChanges;
        owlOntologyManager.addOntologyChangeListener(this.listener);
    }

    @Override
    public void dispose() {
        super.dispose();
        this.getManager().removeOntologyChangeListener(this.listener);
    }

    private void handleChanges(List<? extends OWLOntologyChange> changes) {
        HashSet<P> properties = new HashSet<P>(this.getPropertiesReferencedInChange(changes));
        for (OWLPropertyExpression prop : properties) {
            if (this.isSubPropertyOfRoot(prop)) {
                this.subPropertiesOfRoot.add(prop);
                this.fireNodeChanged(this.getRoot());
            } else if (this.getAncestors(prop).contains(prop)) {
                this.subPropertiesOfRoot.add(prop);
                this.getAncestors(prop).stream().filter(anc -> this.getAncestors(anc).contains(prop)).forEach(anc -> {
                    this.subPropertiesOfRoot.add(anc);
                    this.fireNodeChanged(anc);
                });
            } else {
                this.subPropertiesOfRoot.remove(prop);
            }
            this.fireNodeChanged(prop);
        }
        this.fireNodeChanged(this.getRoot());
    }

    protected abstract Set<P> getPropertiesReferencedInChange(List<? extends OWLOntologyChange> var1);

    private boolean isSubPropertyOfRoot(P prop) {
        if (prop.equals(this.getRoot())) {
            return false;
        }
        Set<P> parents = this.getParents(prop);
        if (parents.isEmpty() || parents.contains(this.getRoot())) {
            for (OWLOntology ont : this.ontologies) {
                if (!this.containsReference(ont, prop)) continue;
                return true;
            }
        }
        return this.getAncestors(prop).contains(prop);
    }

    private void rebuildRoots() {
        this.subPropertiesOfRoot.clear();
        for (OWLOntology ontology : this.ontologies) {
            for (OWLPropertyExpression prop : this.getReferencedProperties(ontology)) {
                if (!this.isSubPropertyOfRoot(prop)) continue;
                this.subPropertiesOfRoot.add(prop);
            }
        }
    }

    protected abstract boolean containsReference(OWLOntology var1, P var2);

    protected abstract Set<? extends P> getReferencedProperties(OWLOntology var1);

    protected abstract Set<? extends OWLSubPropertyAxiom> getSubPropertyAxiomForRHS(P var1, OWLOntology var2);

    protected abstract P getRoot();

    @Override
    public Set<P> getRoots() {
        return Collections.singleton(this.getRoot());
    }

    @Override
    public final void setOntologies(Set<OWLOntology> ontologies) {
        this.ontologySetWriteLock.lock();
        try {
            this.ontologies.clear();
            this.ontologies.addAll(ontologies);
            this.rebuildRoots();
            this.fireHierarchyChanged();
        }
        finally {
            this.ontologySetWriteLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean containsReference(P object) {
        this.ontologySetReadLock.lock();
        try {
            for (OWLOntology ont : this.ontologies) {
                if (!this.getReferencedProperties(ont).contains(object)) continue;
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.ontologySetReadLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<P> getUnfilteredChildren(P object) {
        this.ontologySetReadLock.lock();
        try {
            if (object.equals(this.getRoot())) {
                Set<P> set = Collections.unmodifiableSet(this.subPropertiesOfRoot);
                return set;
            }
            HashSet<OWLPropertyExpression> result = new HashSet<OWLPropertyExpression>();
            for (OWLPropertyExpression subProp : this.getSubProperties(object, this.ontologies)) {
                if (subProp.isAnonymous() || this.getAncestors(subProp).contains(subProp)) continue;
                result.add(subProp);
            }
            HashSet<OWLPropertyExpression> hashSet = result;
            return hashSet;
        }
        finally {
            this.ontologySetReadLock.unlock();
        }
    }

    protected abstract Collection<P> getSubProperties(P var1, Set<OWLOntology> var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<P> getEquivalents(P object) {
        this.ontologySetReadLock.lock();
        try {
            HashSet<OWLPropertyExpression> result = new HashSet<OWLPropertyExpression>();
            Set<P> ancestors = this.getAncestors(object);
            if (ancestors.contains(object)) {
                for (OWLPropertyExpression anc : ancestors) {
                    if (!this.getAncestors(anc).contains(object)) continue;
                    result.add(anc);
                }
            }
            for (OWLPropertyExpression prop : EntitySearcher.getEquivalentProperties(object, this.ontologies)) {
                if (prop.isAnonymous()) continue;
                result.add(prop);
            }
            result.remove(object);
            HashSet<OWLPropertyExpression> hashSet = result;
            return hashSet;
        }
        finally {
            this.ontologySetReadLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<P> getParents(P object) {
        this.ontologySetReadLock.lock();
        try {
            if (object.equals(this.getRoot())) {
                Set set = Collections.emptySet();
                return set;
            }
            HashSet<Object> result = new HashSet<Object>();
            for (OWLPropertyExpression prop : this.getSuperProperties(object, this.ontologies)) {
                if (prop.isAnonymous()) continue;
                result.add(prop);
            }
            if (result.isEmpty() && this.isReferenced(object)) {
                result.add(this.getRoot());
            }
            HashSet<Object> hashSet = result;
            return hashSet;
        }
        finally {
            this.ontologySetReadLock.unlock();
        }
    }

    protected abstract Collection<P> getSuperProperties(P var1, Set<OWLOntology> var2);

    private boolean isReferenced(P e) {
        return (Boolean)e.accept((OWLPropertyExpressionVisitorEx)new IsReferencePropertyExpressionVisitor());
    }

    private class FakeSet<X>
    extends AbstractSet<X> {
        private List<X> elements = new ArrayList<X>();

        private FakeSet() {
        }

        @Override
        public Iterator<X> iterator() {
            return this.elements.iterator();
        }

        @Override
        public int size() {
            return this.elements.size();
        }

        @Override
        public boolean add(X e) {
            if (!this.elements.contains(e)) {
                this.elements.add(e);
                return true;
            }
            return false;
        }

        @Override
        public void clear() {
            this.elements.clear();
        }
    }

    private class IsReferencePropertyExpressionVisitor
    implements OWLPropertyExpressionVisitorEx<Boolean> {
        private IsReferencePropertyExpressionVisitor() {
        }

        public Boolean visit(OWLAnnotationProperty owlAnnotationProperty) {
            return this.isReferenced((OWLEntity)owlAnnotationProperty);
        }

        public Boolean visit(OWLObjectProperty property) {
            return this.isReferenced((OWLEntity)property);
        }

        public Boolean visit(OWLObjectInverseOf property) {
            return (Boolean)property.getInverse().accept((OWLPropertyExpressionVisitorEx)this);
        }

        public Boolean visit(OWLDataProperty property) {
            return this.isReferenced((OWLEntity)property);
        }

        private boolean isReferenced(OWLEntity e) {
            for (OWLOntology ontology : AbstractOWLPropertyHierarchyProvider.this.ontologies) {
                if (!ontology.containsEntityInSignature(e)) continue;
                return true;
            }
            return false;
        }
    }
}

