/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.MemoryType;
import java.lang.management.MemoryUsage;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.concurrent.locks.Condition;
import java.util.logging.Level;
import java.util.regex.Pattern;
import javax.management.ListenerNotFoundException;
import javax.management.Notification;
import javax.management.NotificationEmitter;
import javax.management.NotificationListener;
import oracle.jdbc.diagnostics.CommonDiagnosable;
import oracle.jdbc.diagnostics.Diagnosable;
import oracle.jdbc.diagnostics.SecurityLabel;
import oracle.jdbc.internal.Monitor;

abstract class BlockSource
implements Diagnosable {
    private static final String CLASS_NAME = BlockSource.class.getName();
    private static final int BLOCK_SIZE = 32768;

    BlockSource() {
    }

    static final BlockSource createBlockSource(boolean useThreadLocal, Implementation impl) {
        if (useThreadLocal) {
            return ThreadLocalBlockSource.createBlockSource(impl);
        }
        return BlockSource.createBlockSource(impl);
    }

    static BlockSource createBlockSource(Implementation impl) {
        switch (impl) {
            case DUMB: {
                return DumbBlockSource.createBlockSource();
            }
            case SIMPLE: {
                return SimpleCachingBlockSource.createBlockSource();
            }
            case SOFT: {
                return SoftCachingBlockSource.createBlockSource();
            }
            case THREADED: {
                return ThreadedCachingBlockSource.createBlockSource();
            }
        }
        return null;
    }

    abstract int getBlockSize();

    abstract byte[] get();

    abstract void put(byte[] var1);

    @Override
    public Diagnosable getDiagnosable() {
        return CommonDiagnosable.getInstance();
    }

    private static final class ThreadLocalBlockSource
    extends BlockSource {
        private static Implementation IMPL = null;
        private static final ThreadLocal<BlockSource> REF = new ThreadLocal<BlockSource>(){

            @Override
            protected BlockSource initialValue() {
                return BlockSource.createBlockSource(IMPL);
            }
        };

        static BlockSource createBlockSource(Implementation impl) {
            assert (IMPL == null || IMPL == impl) : "IMPL: " + IMPL + " impl: " + impl;
            IMPL = impl;
            return new ThreadLocalBlockSource();
        }

        private ThreadLocalBlockSource() {
        }

        @Override
        int getBlockSize() {
            return REF.get().getBlockSize();
        }

        @Override
        byte[] get() {
            BlockSource s = REF.get();
            return s.get();
        }

        @Override
        void put(byte[] block) {
            BlockSource s = REF.get();
            s.put(block);
        }
    }

    private static final class SoftCachingBlockSource
    extends BlockSource {
        private static final int CACHE_SIZE = 1024;
        private final SoftReference<byte[]>[] blocks = new SoftReference[1024];
        private int top = 0;

        private static BlockSource createBlockSource() {
            return new SoftCachingBlockSource();
        }

        private SoftCachingBlockSource() {
        }

        @Override
        int getBlockSize() {
            return 32768;
        }

        @Override
        byte[] get() {
            while (this.top > 0) {
                SoftReference<byte[]> ref = this.blocks[--this.top];
                this.blocks[this.top] = null;
                byte[] blk = ref.get();
                if (blk == null) continue;
                return blk;
            }
            return new byte[32768];
        }

        @Override
        void put(byte[] block) {
            assert (block != null) : "block is null";
            assert (block.length == 32768) : "block.length: " + block.length;
            if (this.top < this.blocks.length) {
                this.blocks[this.top++] = new SoftReference<byte[]>(block);
            } else {
                int i = this.top;
                while (i > 0) {
                    if (this.blocks[--i].get() != null) continue;
                    this.blocks[i] = new SoftReference<byte[]>(block);
                    return;
                }
            }
        }
    }

    static final class ThreadedCachingBlockSource
    extends BlockSource
    implements Monitor {
        private static final String CLASS_NAME = ThreadedCachingBlockSource.class.getName();
        private static final BlockReleaser RELEASER = BlockReleaser.SOLE_INSTANCE;
        private static final BlockReleaserListener LISTENER = BlockReleaserListener.SOLE_INSTANCE;
        private static final Collection<WeakReference<ThreadedCachingBlockSource>> ALL_INSTANCES = new LinkedList<WeakReference<ThreadedCachingBlockSource>>();
        private static final Monitor ALL_INSTANCES_MONITOR = Monitor.newInstance();
        private static volatile long LAST_MEMORY_EVENT_MILLIS = 0L;
        private static final int INITIAL_CACHE_SIZE = 32;
        private int top = 0;
        private byte[][] stack = new byte[32][];
        private int lowWaterMark = 0;
        private int recentLowWaterMark = 0;
        private final Monitor.CloseableLock monitorLock = Monitor.newDefaultLock();

        static void stopBlockReleaserThread() {
            BlockReleaser.SOLE_INSTANCE.interrupt();
        }

        private static void releaseFromAllSources() {
            try (Monitor.CloseableLock lock = ALL_INSTANCES_MONITOR.acquireCloseableLock();){
                Iterator<WeakReference<ThreadedCachingBlockSource>> i = ALL_INSTANCES.iterator();
                while (i.hasNext()) {
                    ThreadedCachingBlockSource b = (ThreadedCachingBlockSource)i.next().get();
                    if (b == null) {
                        i.remove();
                        continue;
                    }
                    b.releaseUnusedBlocks();
                }
            }
        }

        static BlockSource createBlockSource() {
            try {
                ThreadedCachingBlockSource b = new ThreadedCachingBlockSource();
                WeakReference<ThreadedCachingBlockSource> r = new WeakReference<ThreadedCachingBlockSource>(b);
                try (Monitor.CloseableLock lock = ALL_INSTANCES_MONITOR.acquireCloseableLock();){
                    ALL_INSTANCES.add(r);
                }
                return b;
            }
            catch (OutOfMemoryError ex) {
                LAST_MEMORY_EVENT_MILLIS = System.currentTimeMillis();
                throw ex;
            }
        }

        private ThreadedCachingBlockSource() {
        }

        final void releaseUnusedBlocks() {
            try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
                assert (this.top >= this.recentLowWaterMark);
                this.lowWaterMark = System.currentTimeMillis() - LAST_MEMORY_EVENT_MILLIS < 300000L ? this.recentLowWaterMark : Math.min((this.lowWaterMark + this.recentLowWaterMark) / 2, this.recentLowWaterMark);
                int newTop = this.top - this.lowWaterMark;
                this.debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "releaseUnusedBlocks", "releasing={0}, newTop={1}. ", (String)null, (Throwable)null, (Object)this.lowWaterMark, (Object)newTop);
                while (this.top > newTop) {
                    this.stack[--this.top] = null;
                }
                this.recentLowWaterMark = this.top;
            }
        }

        private final void checkLowWater() {
            this.recentLowWaterMark = Math.min(this.recentLowWaterMark, this.top);
        }

        @Override
        final int getBlockSize() {
            return 32768;
        }

        @Override
        final byte[] get() {
            Monitor.CloseableLock lock;
            block9: {
                lock = this.acquireCloseableLock();
                if (this.top != 0) break block9;
                try {
                    byte[] byArray = new byte[32768];
                    return byArray;
                }
                catch (OutOfMemoryError ex) {
                    LAST_MEMORY_EVENT_MILLIS = System.currentTimeMillis();
                    throw ex;
                }
            }
            byte[] result = this.stack[--this.top];
            this.checkLowWater();
            byte[] byArray = result;
            return byArray;
            finally {
                if (lock != null) {
                    lock.close();
                }
            }
        }

        /*
         * Unable to fully structure code
         */
        @Override
        final void put(byte[] block) {
            block11: {
                lock = this.acquireCloseableLock();
                if (!ThreadedCachingBlockSource.$assertionsDisabled && block.length != 32768) {
                    throw new AssertionError((Object)("block.length: " + block.length));
                }
                if (this.top != this.stack.length) ** GOTO lbl20
                if (System.currentTimeMillis() - ThreadedCachingBlockSource.LAST_MEMORY_EVENT_MILLIS >= 300000L) break block11;
                this.debug(Level.INFO, SecurityLabel.UNKNOWN, ThreadedCachingBlockSource.CLASS_NAME, "put", "would grow cache but recent memory event. ", null, null);
                if (lock != null) {
                    lock.close();
                }
                return;
            }
            try {
                try {
                    this.debug(Level.INFO, SecurityLabel.UNKNOWN, ThreadedCachingBlockSource.CLASS_NAME, "put", "grow cache -- new cache size={0}. ", (String)null, (Throwable)null, (Object)(this.stack.length * 4));
                    s = new byte[this.stack.length * 4][];
                    System.arraycopy(this.stack, 0, s, 0, this.stack.length);
                    this.stack = s;
lbl20:
                    // 2 sources

                    this.stack[this.top++] = block;
                }
                catch (OutOfMemoryError ex) {
                    ThreadedCachingBlockSource.LAST_MEMORY_EVENT_MILLIS = System.currentTimeMillis();
                    this.debug(Level.WARNING, SecurityLabel.UNKNOWN, ThreadedCachingBlockSource.CLASS_NAME, "put", null, null, ex);
                }
            }
            catch (Throwable var3_5) {
                throw var3_5;
            }
            finally {
                if (lock != null) {
                    lock.close();
                }
            }
        }

        @Override
        public final Monitor.CloseableLock getMonitorLock() {
            return this.monitorLock;
        }

        private static final class BlockReleaserListener
        implements NotificationListener,
        Diagnosable {
            private static final String CLASS_NAME = BlockReleaserListener.class.getName();
            private static final BlockReleaserListener SOLE_INSTANCE = new BlockReleaserListener();

            private BlockReleaserListener() {
                MemoryMXBean mbean = ManagementFactory.getMemoryMXBean();
                NotificationEmitter emitter = (NotificationEmitter)((Object)mbean);
                emitter.addNotificationListener(this, null, null);
                Pattern old = Pattern.compile(".*Old.*");
                for (MemoryPoolMXBean pool : ManagementFactory.getMemoryPoolMXBeans()) {
                    if (pool.getType() != MemoryType.HEAP || !pool.isCollectionUsageThresholdSupported() || !old.matcher(pool.getName()).matches() || pool.getCollectionUsageThreshold() != 0L) continue;
                    MemoryUsage usage = pool.getUsage();
                    final long threshold = (long)(usage.getMax() == -1L ? (double)Runtime.getRuntime().maxMemory() * 0.9 : (double)usage.getMax() * 0.9);
                    final MemoryPoolMXBean memoryPool = pool;
                    this.debug(Level.CONFIG, SecurityLabel.UNKNOWN, CLASS_NAME, "BlockReleaserListener()", "pool={0}, threshold={1}. ", (String)null, (Throwable)null, (Object)pool.getName(), (Object)threshold);
                    AccessController.doPrivileged(new PrivilegedAction<Object>(){

                        @Override
                        public Object run() {
                            memoryPool.setCollectionUsageThreshold(threshold);
                            return null;
                        }
                    });
                }
            }

            @Override
            public void handleNotification(Notification notification, Object handback) {
                String notifType = notification.getType();
                if (notifType.equals("java.management.memory.collection.threshold.exceeded")) {
                    this.debug(Level.INFO, SecurityLabel.UNKNOWN, CLASS_NAME, "handleNotification", "MEMORY_COLLECTION_THRESHOLD_EXCEEDED", null, null);
                    LAST_MEMORY_EVENT_MILLIS = System.currentTimeMillis();
                    BlockReleaser.releaseAllUnusedBlocks();
                }
            }

            public void unregister() {
                MemoryMXBean mbean = ManagementFactory.getMemoryMXBean();
                NotificationEmitter emitter = (NotificationEmitter)((Object)mbean);
                this.debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "unregister", "removeNotificationListener", null, null);
                try {
                    emitter.removeNotificationListener(this, null, null);
                }
                catch (ListenerNotFoundException e) {
                    this.debug(Level.WARNING, SecurityLabel.UNKNOWN, CLASS_NAME, "unregister", null, null, e);
                }
            }

            @Override
            public Diagnosable getDiagnosable() {
                return CommonDiagnosable.getInstance();
            }
        }

        private static final class BlockReleaser
        extends Thread
        implements Monitor.WaitableMonitor,
        Diagnosable {
            private static final String CLASS_NAME = BlockReleaser.class.getName();
            private static final String BLOCK_RELEASER_THREAD_NAME = "oracle.jdbc.driver.BlockSource.ThreadedCachingBlockSource.BlockReleaser";
            private static final int DELAY_MILLIS = 300000;
            private static final BlockReleaser SOLE_INSTANCE = new BlockReleaser();
            private final Monitor.CloseableLock monitorLock = Monitor.newDefaultLock();
            private final Condition monitorCondition = this.newMonitorCondition();

            static void releaseAllUnusedBlocks() {
                try (Monitor.CloseableLock lock = SOLE_INSTANCE.acquireCloseableLock();){
                    SOLE_INSTANCE.monitorNotifyAll();
                }
            }

            private BlockReleaser() {
                super(BLOCK_RELEASER_THREAD_NAME);
                this.setDaemon(true);
                this.setPriority(4);
                this.start();
            }

            @Override
            public void run() {
                while (true) {
                    try {
                        while (true) {
                            try (Monitor.CloseableLock lock = SOLE_INSTANCE.acquireCloseableLock();){
                                SOLE_INSTANCE.monitorWait(300000L);
                            }
                            this.debug(Level.FINER, SecurityLabel.UNKNOWN, CLASS_NAME, "run", "wait terminated. ", null, null);
                            ThreadedCachingBlockSource.releaseFromAllSources();
                        }
                    }
                    catch (InterruptedException ex) {
                        BlockReleaserListener.SOLE_INSTANCE.unregister();
                        this.debug(Level.WARNING, SecurityLabel.UNKNOWN, CLASS_NAME, "run", "Interrupted. Listener unregistered. ", null, null);
                        return;
                    }
                    catch (ThreadDeath ex) {
                        BlockReleaserListener.SOLE_INSTANCE.unregister();
                        this.debug(Level.SEVERE, SecurityLabel.UNKNOWN, CLASS_NAME, "run", null, null, ex);
                        throw ex;
                    }
                    catch (Throwable ex) {
                        this.debug(Level.WARNING, SecurityLabel.UNKNOWN, CLASS_NAME, "run", null, null, ex);
                        continue;
                    }
                    break;
                }
            }

            @Override
            public final Monitor.CloseableLock getMonitorLock() {
                return this.monitorLock;
            }

            @Override
            public Condition getMonitorCondition() {
                return this.monitorCondition;
            }

            @Override
            public Diagnosable getDiagnosable() {
                return CommonDiagnosable.getInstance();
            }
        }
    }

    static final class SimpleCachingBlockSource
    extends BlockSource {
        private static final String CLASS_NAME = SimpleCachingBlockSource.class.getName();
        private static final int INITIAL_CACHE_SIZE = 32;
        private static final long RELEASE_NANOS = 300000000L;
        private int top = 0;
        private byte[][] stack = new byte[32][];
        private int lowWaterMark = 0;
        private int recentLowWaterMark = 0;
        private long nextReleaseNanos = System.nanoTime() + 300000000L;

        static BlockSource createBlockSource() {
            return new SimpleCachingBlockSource();
        }

        private SimpleCachingBlockSource() {
        }

        final void releaseUnusedBlocks() {
            long t = System.nanoTime();
            if (t < this.nextReleaseNanos) {
                return;
            }
            this.nextReleaseNanos = t + 300000000L;
            assert (this.top >= this.recentLowWaterMark);
            this.lowWaterMark = Math.min((this.lowWaterMark + this.recentLowWaterMark) / 2, this.recentLowWaterMark);
            int newTop = this.top - this.lowWaterMark;
            this.debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "releaseUnusedBlocks", "releasing={0}, newTop={1}. ", (String)null, (Throwable)null, (Object)this.lowWaterMark, (Object)newTop);
            while (this.top > newTop) {
                this.stack[--this.top] = null;
            }
            this.recentLowWaterMark = this.top;
        }

        private final void checkLowWater() {
            this.recentLowWaterMark = Math.min(this.recentLowWaterMark, this.top);
        }

        @Override
        final int getBlockSize() {
            return 32768;
        }

        @Override
        final byte[] get() {
            if (this.top == 0) {
                return new byte[32768];
            }
            byte[] result = this.stack[--this.top];
            this.checkLowWater();
            return result;
        }

        @Override
        final void put(byte[] block) {
            assert (block.length == 32768) : "block.length: " + block.length;
            if (this.top == this.stack.length) {
                this.debug(Level.FINER, SecurityLabel.UNKNOWN, CLASS_NAME, "put", "grow cache--old stack.length={0}, new stack.length={1}. ", (String)null, (Throwable)null, (Object)this.stack.length, (Object)(this.stack.length * 4));
                byte[][] s = new byte[this.stack.length * 4][];
                System.arraycopy(this.stack, 0, s, 0, this.stack.length);
                this.stack = s;
            }
            this.stack[this.top++] = block;
            this.releaseUnusedBlocks();
        }
    }

    static class DumbBlockSource
    extends BlockSource {
        static final BlockSource createBlockSource() {
            return new DumbBlockSource();
        }

        DumbBlockSource() {
        }

        @Override
        final int getBlockSize() {
            return 32768;
        }

        @Override
        final byte[] get() {
            return new byte[32768];
        }

        @Override
        final void put(byte[] block) {
        }
    }

    static enum Implementation {
        DUMB,
        SIMPLE,
        SOFT,
        THREADED;

    }
}

