/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.util.io;

import java.io.IOException;
import java.io.InputStream;
import org.jruby.Ruby;
import org.jruby.runtime.Helpers;

public class RubyInputStream {
    private final Ruby runtime;
    private final InputStream wrap;

    public RubyInputStream(Ruby runtime2, InputStream wrap2) {
        this.runtime = runtime2;
        this.wrap = wrap2;
    }

    public int read() {
        try {
            return this.wrap.read();
        }
        catch (IOException e) {
            throw Helpers.newIOErrorFromException(this.runtime, e);
        }
    }

    public int read(byte[] b2) {
        try {
            return this.wrap.read(b2);
        }
        catch (IOException e) {
            throw Helpers.newIOErrorFromException(this.runtime, e);
        }
    }

    public int read(byte[] b2, int off, int len) {
        try {
            return this.wrap.read(b2, off, len);
        }
        catch (IOException e) {
            throw Helpers.newIOErrorFromException(this.runtime, e);
        }
    }

    public byte[] readAllBytes() {
        try {
            return this.wrap.readAllBytes();
        }
        catch (IOException e) {
            throw Helpers.newIOErrorFromException(this.runtime, e);
        }
    }

    public byte[] readNBytes(int len) {
        try {
            return this.wrap.readNBytes(len);
        }
        catch (IOException e) {
            throw Helpers.newIOErrorFromException(this.runtime, e);
        }
    }

    public int readNBytes(byte[] b2, int off, int len) {
        try {
            return this.wrap.readNBytes(b2, off, len);
        }
        catch (IOException e) {
            throw Helpers.newIOErrorFromException(this.runtime, e);
        }
    }

    public long skip(long n) {
        try {
            return this.wrap.skip(n);
        }
        catch (IOException e) {
            throw Helpers.newIOErrorFromException(this.runtime, e);
        }
    }

    public void skipNBytes(long n) {
        try {
            this.wrap.skipNBytes(n);
        }
        catch (IOException e) {
            throw Helpers.newIOErrorFromException(this.runtime, e);
        }
    }

    public int available() {
        try {
            return this.wrap.available();
        }
        catch (IOException e) {
            throw Helpers.newIOErrorFromException(this.runtime, e);
        }
    }

    public void close() {
        try {
            this.wrap.close();
        }
        catch (IOException e) {
            throw Helpers.newIOErrorFromException(this.runtime, e);
        }
    }
}

