/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.tagging.presets.items;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.stream.Collectors;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Territories;
import org.openstreetmap.josm.tools.Utils;
import org.xml.sax.SAXException;

public interface RegionSpecific {
    public Collection<String> regions();

    default public void setRegions(String regions) throws SAXException {
        Set<String> regionSet = Collections.unmodifiableSet(Arrays.stream(regions.split(",")).map(Utils::intern).collect(Collectors.toSet()));
        for (String region : regionSet) {
            if (Territories.getKnownIso3166Codes().contains(region)) continue;
            throw new SAXException(I18n.tr("Unknown ISO-3166 Code: {0}", region));
        }
        this.realSetRegions(regionSet);
    }

    public void realSetRegions(Collection<String> var1);

    public boolean exclude_regions();

    public void setExclude_regions(boolean var1);
}

