/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.tagging.presets.items;

import java.awt.Component;
import java.awt.event.MouseEvent;
import java.util.Arrays;
import java.util.Optional;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.openstreetmap.josm.gui.dialogs.properties.HelpAction;
import org.openstreetmap.josm.gui.tagging.presets.TaggingPresetItemGuiSupport;
import org.openstreetmap.josm.gui.tagging.presets.items.TextItem;
import org.openstreetmap.josm.gui.widgets.UrlLabel;
import org.openstreetmap.josm.spi.preferences.Config;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.LanguageInfo;

public class Link
extends TextItem {
    public String wiki;
    public String href;
    public String locale_href;

    @Override
    public boolean addToPanel(JPanel p, TaggingPresetItemGuiSupport support) {
        this.initializeLocaleText(I18n.tr("More information about this feature", new Object[0]));
        UrlLabel label = this.buildUrlLabel();
        if (label != null) {
            label.applyComponentOrientation(support.getDefaultComponentOrientation());
            p.add((Component)label, GBC.eol().insets(0, 10, 0, 0).fill(2));
        }
        return false;
    }

    protected UrlLabel buildUrlLabel() {
        String url = this.getUrl();
        if (this.wiki != null) {
            UrlLabel urlLabel = new UrlLabel(url, this.locale_text, 2){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (SwingUtilities.isLeftMouseButton(e)) {
                        HelpAction.displayHelp(Arrays.asList(LanguageInfo.getWikiLanguagePrefix(LanguageInfo.LocaleType.OSM_WIKI) + Link.this.wiki, Link.this.wiki));
                    } else {
                        super.mouseClicked(e);
                    }
                }
            };
            this.addIcon(urlLabel);
            return urlLabel;
        }
        if (this.href != null || this.locale_href != null) {
            UrlLabel urlLabel = new UrlLabel(url, this.locale_text, 2);
            this.addIcon(urlLabel);
            return urlLabel;
        }
        return null;
    }

    public String getUrl() {
        if (this.wiki != null) {
            return Config.getUrls().getOSMWiki() + "/wiki/" + this.wiki;
        }
        if (this.href != null || this.locale_href != null) {
            return Optional.ofNullable(this.locale_href).orElse(this.href);
        }
        return null;
    }

    @Override
    protected String fieldsToString() {
        return super.fieldsToString() + (String)(this.wiki != null ? "wiki=" + this.wiki + ", " : "") + (String)(this.href != null ? "href=" + this.href + ", " : "") + (String)(this.locale_href != null ? "locale_href=" + this.locale_href + ", " : "");
    }
}

