/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.model.idrange;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.Comparator;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.protege.editor.owl.model.idrange.IdRangesPolicy;
import org.protege.editor.owl.model.idrange.UserIdRange;
import org.protege.editor.owl.model.idrange.UserIdRangeListCellRenderer;

public class NoRangeFoundForUserNamePanel
extends JPanel {
    private static final String MSG_TEMPLATE = "<html><body>Prot\u00e9g\u00e9 has detected and loaded an Id range policy.  However, no Id range has been found for the current user (<b>%s</b>).  Please select the Id range that you wish to use.</body></html>";
    private final JLabel messageLabel = new JLabel();
    private final JList<UserIdRange> userNameList = new JList();

    public NoRangeFoundForUserNamePanel() {
        this.setLayout(new BorderLayout(7, 7));
        this.add((Component)this.messageLabel, "North");
        JScrollPane sp = new JScrollPane(this.userNameList);
        this.userNameList.setCellRenderer(new UserIdRangeListCellRenderer());
        this.add((Component)sp, "Center");
        this.setPreferredSize(new Dimension(600, 300));
    }

    public void setUserName(@Nonnull String userName) {
        String msg = String.format(MSG_TEMPLATE, userName, userName);
        this.messageLabel.setText(msg);
    }

    public void setIdRangesPolicy(@Nonnull IdRangesPolicy policy) {
        UserIdRange[] userNames = (UserIdRange[])policy.getUserIdRanges().stream().sorted(Comparator.comparing(UserIdRange::getUserId).thenComparing(rng -> rng.getIdRange().getLowerBound())).toArray(UserIdRange[]::new);
        this.userNameList.setListData((UserIdRange[])userNames);
    }

    public Optional<UserIdRange> getSelectedRange() {
        return Optional.ofNullable(this.userNameList.getSelectedValue());
    }
}

