/*
 * spectralData.h - Chromatic Match Functions from CIE Standard Observer 1932 2-Degrees
 *
 *  Created on: 28/03/2009
 *
 *      Author: Rodrigo Placencia (DarkTide)
 *
 */
#ifndef SPECTRALDATA_H_
#define SPECTRALDATA_H_

__BEGIN_YAFRAY

static const float chromaMatch2Deg[95][3] = //[Lambda][chromacord] Wavelength range 360-830 @ 5nm interval
{
		{0.000129900000, 0.000003917000, 0.000606100000}, {0.000232100000, 0.000006965000, 0.001086000000},
		{0.000414900000, 0.000012390000, 0.001946000000}, {0.000741600000, 0.000022020000, 0.003486000000},
		{0.001368000000, 0.000039000000, 0.006450001000}, {0.002236000000, 0.000064000000, 0.010549990000},
		{0.004243000000, 0.000120000000, 0.020050010000}, {0.007650000000, 0.000217000000, 0.036210000000},
		{0.014310000000, 0.000396000000, 0.067850010000}, {0.023190000000, 0.000640000000, 0.110200000000},

		{0.043510000000, 0.001210000000, 0.207400000000}, {0.077630000000, 0.002180000000, 0.371300000000},
		{0.134380000000, 0.004000000000, 0.645600000000}, {0.214770000000, 0.007300000000, 1.039050100000},
		{0.283900000000, 0.011600000000, 1.385600000000}, {0.328500000000, 0.016840000000, 1.622960000000},
		{0.348280000000, 0.023000000000, 1.747060000000}, {0.348060000000, 0.029800000000, 1.782600000000},
		{0.336200000000, 0.038000000000, 1.772110000000}, {0.318700000000, 0.048000000000, 1.744100000000},

		{0.290800000000, 0.060000000000, 1.669200000000}, {0.251100000000, 0.073900000000, 1.528100000000},
		{0.195360000000, 0.090980000000, 1.287640000000}, {0.142100000000, 0.112600000000, 1.041900000000},
		{0.095640000000, 0.139020000000, 0.812950100000}, {0.057950010000, 0.169300000000, 0.616200000000},
		{0.032010000000, 0.208020000000, 0.465180000000}, {0.014700000000, 0.258600000000, 0.353300000000},
		{0.004900000000, 0.323000000000, 0.272000000000}, {0.002400000000, 0.407300000000, 0.212300000000},

		{0.009300000000, 0.503000000000, 0.158200000000}, {0.029100000000, 0.608200000000, 0.111700000000},
		{0.063270000000, 0.710000000000, 0.078249990000}, {0.109600000000, 0.793200000000, 0.057250010000},
		{0.165500000000, 0.862000000000, 0.042160000000}, {0.225749900000, 0.914850100000, 0.029840000000},
		{0.290400000000, 0.954000000000, 0.020300000000}, {0.359700000000, 0.980300000000, 0.013400000000},
		{0.433449900000, 0.994950100000, 0.008749999000}, {0.512050100000, 1.000000000000, 0.005749999000},

		{0.594500000000, 0.995000000000, 0.003900000000}, {0.678400000000, 0.978600000000, 0.002749999000},
		{0.762100000000, 0.952000000000, 0.002100000000}, {0.842500000000, 0.915400000000, 0.001800000000},
		{0.916300000000, 0.870000000000, 0.001650001000}, {0.978600000000, 0.816300000000, 0.001400000000},
		{1.026300000000, 0.757000000000, 0.001100000000}, {1.056700000000, 0.694900000000, 0.001000000000},
		{1.062200000000, 0.631000000000, 0.000800000000}, {1.045600000000, 0.566800000000, 0.000600000000},

		{1.002600000000, 0.503000000000, 0.000340000000}, {0.938400000000, 0.441200000000, 0.000240000000},
		{0.854449900000, 0.381000000000, 0.000190000000}, {0.751400000000, 0.321000000000, 0.000100000000},
		{0.642400000000, 0.265000000000, 0.000049999990}, {0.541900000000, 0.217000000000, 0.000030000000},
		{0.447900000000, 0.175000000000, 0.000020000000}, {0.360800000000, 0.138200000000, 0.000010000000},
		{0.283500000000, 0.107000000000, 0.000000000000}, {0.218700000000, 0.081600000000, 0.000000000000},

		{0.164900000000, 0.061000000000, 0.000000000000}, {0.121200000000, 0.044580000000, 0.000000000000},
		{0.087400000000, 0.032000000000, 0.000000000000}, {0.063600000000, 0.023200000000, 0.000000000000},
		{0.046770000000, 0.017000000000, 0.000000000000}, {0.032900000000, 0.011920000000, 0.000000000000},
		{0.022700000000, 0.008210000000, 0.000000000000}, {0.015840000000, 0.005723000000, 0.000000000000},
		{0.011359160000, 0.004102000000, 0.000000000000}, {0.008110916000, 0.002929000000, 0.000000000000},

		{0.005790346000, 0.002091000000, 0.000000000000}, {0.004109457000, 0.001484000000, 0.000000000000},
		{0.002899327000, 0.001047000000, 0.000000000000}, {0.002049190000, 0.000740000000, 0.000000000000},
		{0.001439971000, 0.000520000000, 0.000000000000}, {0.000999949300, 0.000361100000, 0.000000000000},
		{0.000690078600, 0.000249200000, 0.000000000000}, {0.000476021300, 0.000171900000, 0.000000000000},
		{0.000332301100, 0.000120000000, 0.000000000000}, {0.000234826100, 0.000084800000, 0.000000000000},

		{0.000166150500, 0.000060000000, 0.000000000000}, {0.000117413000, 0.000042400000, 0.000000000000},
		{0.000083075270, 0.000030000000, 0.000000000000}, {0.000058706520, 0.000021200000, 0.000000000000},
		{0.000041509940, 0.000014990000, 0.000000000000}, {0.000029353260, 0.000010600000, 0.000000000000},
		{0.000020673830, 0.000007465700, 0.000000000000}, {0.000014559770, 0.000005257800, 0.000000000000},
		{0.000010253980, 0.000003702900, 0.000000000000}, {0.000007221456, 0.000002607800, 0.000000000000},

		{0.000005085868, 0.000001836600, 0.000000000000}, {0.000003581652, 0.000001293400, 0.000000000000},
		{0.000002522525, 0.000000910930, 0.000000000000}, {0.000001776509, 0.000000641530, 0.000000000000},
		{0.000001251141, 0.000000451810, 0.000000000000}
};
static const float koWavelengths[64] = {
	300, 305, 310, 315, 320, 325, 330, 335, 340, 345, 350, 355, 445, 450, 455, 460,
	465, 470, 475, 480, 485, 490, 495, 500, 505, 510, 515, 520,	525, 530, 535, 540,
	545, 550, 555, 560, 565, 570, 575, 580, 585, 590, 595, 600, 605, 610, 620, 630,
	640, 650, 660, 670, 680, 690, 700, 710, 720, 730, 740, 750, 760, 770, 780, 790
};

static const float koAmplitudes[64] = {
	10.0,  4.8,  2.7, 1.35,   .8, .380, .160, .075,  .04, .019, .007,   .0, .003, .003, .004, .006,
	.008, .009, .012, .014,	.017, .021,	.025,  .03, .035,  .04, .045, .048,	.057, .063,  .07, .075,
	 .08, .085, .095, .103, .110,  .12,	.122,  .12, .118, .115,  .12, .125, .130,  .12, .105,  .09,
	.079, .067, .057, .048, .036, .028,	.023, .018, .014, .011, .010, .009,	.007, .004,   .0,   .0
};


static const float kgWavelengths[4] = {
  759,  760,  770,  771
};

static const float kgAmplitudes[4] = {
  0,  3.0,  0.210,  0
};

static const float kwaWavelengths[13] = {
  689,  690,  700,  710,  720,  730,  740,
  750,  760,  770,  780,  790,  800
};

static const float kwaAmplitudes[13] = {
  0.00000, 0.01600, 0.02400, 0.01250, 1.0000, 0.8700, 0.06100,
  0.00100, 0.00001, 0.00001, 0.00060, 0.0175, 0.0360
};

//Sun Spectral Radiance [W / (m^2 sr nm)]
static const float sunRadiance[38] = {
    1.65590e+2,
    1.62337e+2,
    2.11275e+2,
    2.58882e+2,
    2.58291e+2,
    2.42323e+2,
    2.67605e+2,
    2.96583e+2,
    3.05454e+2,
    3.00575e+2,
    3.06637e+2,
    2.88304e+2,
    2.87121e+2,
    2.78250e+2,
    2.71006e+2,
    2.72336e+2,
    2.63613e+2,
    2.55038e+2,
    2.50602e+2,
    2.53116e+2,
    2.53559e+2,
    2.51342e+2,
    2.46315e+2,
    2.41732e+2,
    2.36853e+2,
    2.32121e+2,
    2.28277e+2,
    2.23398e+2,
    2.19702e+2,
    2.15267e+2,
    2.10979e+2,
    2.07283e+2,
    2.02404e+2,
    1.98708e+2,
    1.94272e+2,
    1.90724e+2,
    1.86289e+2,
    1.82592e+2
};

color_t chromaMatch(float wl)
{
	color_t r(0.0);
	if(wl < 360 || wl > 830) return r;
	int i = (int)((wl - 360) / 5);
	r.set(chromaMatch2Deg[i][0], chromaMatch2Deg[i][1], chromaMatch2Deg[i][2]);
	return r;
}

//lazy experiment
float wavelengthMatch(float x, float y, float z)
{
	int x0 = -1;
	int x1 = -1;

	for(int i=0;i<95;i++)
	{
		if((chromaMatch2Deg[i][0] == x) && (chromaMatch2Deg[i][1] == y) && (chromaMatch2Deg[i][2] == z)) return i + 360.0;

		if((x0 = -1 && chromaMatch2Deg[i][0] < x) && (chromaMatch2Deg[i][1] < y) && (chromaMatch2Deg[i][2] < z)) x0 = i;
		if((x1 = -1 && chromaMatch2Deg[i][0] > x) && (chromaMatch2Deg[i][1] > y) && (chromaMatch2Deg[i][2] > z)) x1 = i;
	}

	return 360.0 + (x1 - x0)/2;
}

__END_YAFRAY

#endif /* SPECTRALDATA_H_ */
