/*
 * Decompiled with CFR 0.152.
 */
package traer.animation;

import java.util.Vector;
import traer.animation.Smoother;
import traer.animation.Smoother2D;
import traer.animation.Smoother3D;
import traer.animation.Tickable;

public class Animator
implements Tickable {
    Vector smoothers;
    float smoothness;

    public Animator(float smoothness) {
        this.smoothness = smoothness;
        this.smoothers = new Vector();
    }

    public final Smoother makeSmoother() {
        Smoother s = new Smoother(this.smoothness);
        this.smoothers.add(s);
        return s;
    }

    public final Smoother2D make2DSmoother() {
        Smoother2D s = new Smoother2D(this.smoothness);
        this.smoothers.add(s);
        return s;
    }

    public final Smoother3D make3DSmoother() {
        Smoother3D s = new Smoother3D(this.smoothness);
        this.smoothers.add(s);
        return s;
    }

    public final void tick() {
        int i = 0;
        while (i < this.smoothers.size()) {
            Tickable t = (Tickable)this.smoothers.get(i);
            t.tick();
            ++i;
        }
    }

    public final void setSmoothness(float smoothness) {
        int i = 0;
        while (i < this.smoothers.size()) {
            Tickable t = (Tickable)this.smoothers.get(i);
            t.setSmoothness(smoothness);
            ++i;
        }
    }
}

