/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.io.eval;

import java.io.IOException;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import org.apache.solr.client.solrj.io.Tuple;
import org.apache.solr.client.solrj.io.eval.BooleanEvaluator;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpression;
import org.apache.solr.client.solrj.io.stream.expr.StreamFactory;

public class ExclusiveOrEvaluator
extends BooleanEvaluator {
    protected static final long serialVersionUID = 1L;

    public ExclusiveOrEvaluator(StreamExpression expression, StreamFactory factory) throws IOException {
        super(expression, factory);
        if (this.subEvaluators.size() < 2) {
            throw new IOException(String.format(Locale.ROOT, "Invalid expression %s - expecting at least two values but found %d", expression, this.subEvaluators.size()));
        }
    }

    @Override
    public Boolean evaluate(Tuple tuple) throws IOException {
        List<Object> results = this.evaluateAll(tuple);
        if (results.size() < 2) {
            String message = null;
            message = 1 == results.size() ? String.format(Locale.ROOT, "%s(...) only works with at least 2 values but 1 was provided", this.constructingFactory.getFunctionName(this.getClass())) : String.format(Locale.ROOT, "%s(...) only works with at least 2 values but 0 were provided", this.constructingFactory.getFunctionName(this.getClass()));
            throw new IOException(message);
        }
        if (results.stream().anyMatch(result -> null == result)) {
            throw new IOException(String.format(Locale.ROOT, "Unable to check %s(...) because a null value was found", this.constructingFactory.getFunctionName(this.getClass())));
        }
        if (results.stream().anyMatch(result -> !(result instanceof Boolean))) {
            throw new IOException(String.format(Locale.ROOT, "Unable to check %s(...) of non-boolean values [%s]", this.constructingFactory.getFunctionName(this.getClass()), results.stream().map(item -> item.getClass().getSimpleName()).collect(Collectors.joining(","))));
        }
        return 1L == results.stream().filter(result -> (Boolean)result).count();
    }
}

