/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search.facet;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.function.IntFunction;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.Query;
import org.apache.lucene.util.PriorityQueue;
import org.apache.solr.common.util.SimpleOrderedMap;
import org.apache.solr.schema.FieldType;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.search.DocSet;
import org.apache.solr.search.facet.AggValueSource;
import org.apache.solr.search.facet.CountSlotArrAcc;
import org.apache.solr.search.facet.FacetContext;
import org.apache.solr.search.facet.FacetDebugInfo;
import org.apache.solr.search.facet.FacetField;
import org.apache.solr.search.facet.FacetProcessor;
import org.apache.solr.search.facet.HLLAgg;
import org.apache.solr.search.facet.SlotAcc;
import org.apache.solr.search.facet.SortSlotAcc;

abstract class FacetFieldProcessor
extends FacetProcessor<FacetField> {
    SchemaField sf;
    SlotAcc indexOrderAcc;
    int effectiveMincount;
    Map<String, AggValueSource> deferredAggs;
    SlotAcc collectAcc;
    SlotAcc sortAcc;
    SlotAcc[] otherAccs;
    SpecialSlotAcc allBucketsAcc;

    FacetFieldProcessor(FacetContext fcontext, FacetField freq, SchemaField sf) {
        super(fcontext, freq);
        this.sf = sf;
        this.effectiveMincount = (int)(fcontext.isShard() ? Math.min(1L, freq.mincount) : freq.mincount);
    }

    @Override
    protected void createAccs(int docCount, int slotCount) throws IOException {
        if (this.accMap == null) {
            this.accMap = new LinkedHashMap();
        }
        if (this.countAcc == null) {
            this.countAcc = new CountSlotArrAcc(this.fcontext, slotCount);
            this.countAcc.key = "count";
        }
        if (this.accs != null) {
            for (SlotAcc acc : this.accs) {
                acc.reset();
            }
            return;
        }
        this.accs = new SlotAcc[((FacetField)this.freq).getFacetStats().size()];
        int accIdx = 0;
        for (Map.Entry<String, AggValueSource> entry : ((FacetField)this.freq).getFacetStats().entrySet()) {
            SlotAcc acc = null;
            if (slotCount == 1 && (acc = (SlotAcc)this.accMap.get(entry.getKey())) != null) {
                acc.reset();
            }
            if (acc == null) {
                acc = entry.getValue().createSlotAcc(this.fcontext, docCount, slotCount);
                acc.key = entry.getKey();
                this.accMap.put(acc.key, acc);
            }
            this.accs[accIdx++] = acc;
        }
    }

    void createCollectAcc(int numDocs, int numSlots) throws IOException {
        boolean needOtherAccs;
        this.accMap = new LinkedHashMap();
        if (this.countAcc == null) {
            this.countAcc = new CountSlotArrAcc(this.fcontext, numSlots);
        }
        if ("count".equals(((FacetField)this.freq).sortVariable)) {
            this.sortAcc = this.countAcc;
            this.deferredAggs = ((FacetField)this.freq).getFacetStats();
        } else if ("index".equals(((FacetField)this.freq).sortVariable)) {
            if (this.indexOrderAcc == null) {
                this.indexOrderAcc = new SortSlotAcc(this.fcontext);
            }
            this.sortAcc = this.indexOrderAcc;
            this.deferredAggs = ((FacetField)this.freq).getFacetStats();
        } else {
            AggValueSource sortAgg = ((FacetField)this.freq).getFacetStats().get(((FacetField)this.freq).sortVariable);
            if (sortAgg != null) {
                this.collectAcc = sortAgg.createSlotAcc(this.fcontext, numDocs, numSlots);
                this.collectAcc.key = ((FacetField)this.freq).sortVariable;
            }
            this.sortAcc = this.collectAcc;
            this.deferredAggs = new HashMap<String, AggValueSource>(((FacetField)this.freq).getFacetStats());
            this.deferredAggs.remove(((FacetField)this.freq).sortVariable);
        }
        if (this.deferredAggs.size() == 0) {
            this.deferredAggs = null;
        }
        if (!(needOtherAccs = ((FacetField)this.freq).allBuckets)) {
            return;
        }
        this.createOtherAccs(numDocs, 1);
    }

    private void createOtherAccs(int numDocs, int numSlots) throws IOException {
        int numDeferred;
        if (this.otherAccs != null) {
            for (SlotAcc acc : this.otherAccs) {
                acc.reset();
            }
            return;
        }
        int n = numDeferred = this.deferredAggs == null ? 0 : this.deferredAggs.size();
        if (numDeferred <= 0) {
            return;
        }
        this.otherAccs = new SlotAcc[numDeferred];
        int otherAccIdx = 0;
        for (Map.Entry<String, AggValueSource> entry : this.deferredAggs.entrySet()) {
            AggValueSource agg = entry.getValue();
            SlotAcc acc = agg.createSlotAcc(this.fcontext, numDocs, numSlots);
            acc.key = entry.getKey();
            this.accMap.put(acc.key, acc);
            this.otherAccs[otherAccIdx++] = acc;
        }
        if (numDeferred == ((FacetField)this.freq).getFacetStats().size()) {
            this.accs = this.otherAccs;
        }
    }

    int collectFirstPhase(DocSet docs, int slot) throws IOException {
        int num = -1;
        if (this.collectAcc != null) {
            num = this.collectAcc.collect(docs, slot);
        }
        if (this.allBucketsAcc != null) {
            num = this.allBucketsAcc.collect(docs, slot);
        }
        return num >= 0 ? num : docs.size();
    }

    void collectFirstPhase(int segDoc, int slot) throws IOException {
        if (this.collectAcc != null) {
            this.collectAcc.collect(segDoc, slot);
        }
        if (this.allBucketsAcc != null) {
            this.allBucketsAcc.collect(segDoc, slot);
        }
    }

    SimpleOrderedMap<Object> findTopSlots(int numSlots, int slotCardinality, IntFunction<Comparable> bucketValFromSlotNumFunc, Function<Comparable, String> fieldQueryValFunc) throws IOException {
        FacetDebugInfo fdebug;
        int numBuckets = 0;
        int off = this.fcontext.isShard() ? 0 : (int)((FacetField)this.freq).offset;
        long effectiveLimit = Integer.MAX_VALUE;
        if (((FacetField)this.freq).limit >= 0L) {
            effectiveLimit = ((FacetField)this.freq).limit;
            if (this.fcontext.isShard()) {
                if (((FacetField)this.freq).overrequest == -1) {
                    if (((FacetField)this.freq).offset < 10L) {
                        effectiveLimit = (long)((double)effectiveLimit * 1.1 + 4.0);
                    }
                } else {
                    effectiveLimit += (long)((FacetField)this.freq).overrequest;
                }
            }
        }
        int sortMul = ((FacetField)this.freq).sortDirection.getMultiplier();
        int maxTopVals = (int)(effectiveLimit >= 0L ? Math.min(((FacetField)this.freq).offset + effectiveLimit, 0x7FFFFFFEL) : 0x7FFFFFFEL);
        maxTopVals = Math.min(maxTopVals, slotCardinality);
        SlotAcc sortAcc = this.sortAcc;
        SlotAcc indexOrderAcc = this.indexOrderAcc;
        final BiPredicate<Slot, Slot> orderPredicate = indexOrderAcc != null && indexOrderAcc != sortAcc ? (a, b) -> {
            int cmp = sortAcc.compare(a.slot, b.slot) * sortMul;
            return cmp == 0 ? indexOrderAcc.compare(a.slot, b.slot) > 0 : cmp < 0;
        } : (a, b) -> {
            int cmp = sortAcc.compare(a.slot, b.slot) * sortMul;
            return cmp == 0 ? b.slot < a.slot : cmp < 0;
        };
        PriorityQueue<Slot> queue = new PriorityQueue<Slot>(maxTopVals){

            protected boolean lessThan(Slot a, Slot b) {
                return orderPredicate.test(a, b);
            }
        };
        Slot bottom = null;
        Slot scratchSlot = new Slot();
        for (int slotNum = 0; slotNum < numSlots; ++slotNum) {
            int count;
            if (this.effectiveMincount > 0 && (count = this.countAcc.getCount(slotNum)) < this.effectiveMincount) {
                if (count <= 0) continue;
                ++numBuckets;
                continue;
            }
            ++numBuckets;
            if (bottom != null) {
                scratchSlot.slot = slotNum;
                if (!orderPredicate.test(bottom, scratchSlot)) continue;
                bottom.slot = slotNum;
                bottom = (Slot)queue.updateTop();
                continue;
            }
            if (effectiveLimit <= 0L) continue;
            Slot s = new Slot();
            s.slot = slotNum;
            queue.add((Object)s);
            if (queue.size() < maxTopVals) continue;
            bottom = (Slot)queue.top();
        }
        assert (queue.size() <= numBuckets);
        SimpleOrderedMap res = new SimpleOrderedMap();
        if (((FacetField)this.freq).numBuckets) {
            if (!this.fcontext.isShard()) {
                res.add("numBuckets", (Object)numBuckets);
            } else {
                this.calculateNumBuckets((SimpleOrderedMap<Object>)res);
            }
        }
        if ((fdebug = this.fcontext.getDebugInfo()) != null) {
            fdebug.putInfoItem("numBuckets", numBuckets);
        }
        if (((FacetField)this.freq).allBuckets) {
            SimpleOrderedMap allBuckets = new SimpleOrderedMap();
            allBuckets.add("count", (Object)this.allBucketsAcc.getSpecialCount());
            this.allBucketsAcc.setValues((SimpleOrderedMap<Object>)allBuckets, -1);
            res.add("allBuckets", (Object)allBuckets);
        }
        if (((FacetField)this.freq).missing) {
            SimpleOrderedMap missingBucket = new SimpleOrderedMap();
            this.fillBucket((SimpleOrderedMap<Object>)missingBucket, FacetFieldProcessor.getFieldMissingQuery(this.fcontext.searcher, ((FacetField)this.freq).field), null, false, null);
            res.add("missing", (Object)missingBucket);
        }
        int collectCount = Math.max(0, queue.size() - off);
        assert (collectCount <= maxTopVals);
        int[] sortedSlots = new int[collectCount];
        for (int i = collectCount - 1; i >= 0; --i) {
            sortedSlots[i] = ((Slot)queue.pop()).slot;
        }
        ArrayList<SimpleOrderedMap> bucketList = new ArrayList<SimpleOrderedMap>(collectCount);
        res.add("buckets", bucketList);
        boolean needFilter = this.deferredAggs != null || ((FacetField)this.freq).getSubFacets().size() > 0;
        for (int slotNum : sortedSlots) {
            SimpleOrderedMap bucket = new SimpleOrderedMap();
            Comparable val = bucketValFromSlotNumFunc.apply(slotNum);
            bucket.add("val", (Object)val);
            Query filter = needFilter ? this.sf.getType().getFieldQuery(null, this.sf, fieldQueryValFunc.apply(val)) : null;
            this.fillBucket((SimpleOrderedMap<Object>)bucket, this.countAcc.getCount(slotNum), slotNum, null, filter);
            bucketList.add(bucket);
        }
        return res;
    }

    private void calculateNumBuckets(SimpleOrderedMap<Object> target) throws IOException {
        DocSet domain = this.fcontext.base;
        if (((FacetField)this.freq).prefix != null) {
            Query prefixFilter = this.sf.getType().getPrefixQuery(null, this.sf, ((FacetField)this.freq).prefix);
            domain = this.fcontext.searcher.getDocSet(prefixFilter, domain);
        }
        HLLAgg agg = new HLLAgg(((FacetField)this.freq).field);
        SlotAcc acc = agg.createSlotAcc(this.fcontext, domain.size(), 1);
        acc.collect(domain, 0);
        acc.key = "numBuckets";
        acc.setValues(target, 0);
    }

    private void fillBucket(SimpleOrderedMap<Object> target, int count, int slotNum, DocSet subDomain, Query filter) throws IOException {
        target.add("count", (Object)count);
        if (count <= 0 && !((FacetField)this.freq).processEmpty) {
            return;
        }
        if (this.collectAcc != null && slotNum >= 0) {
            this.collectAcc.setValues(target, slotNum);
        }
        this.createOtherAccs(-1, 1);
        if (this.otherAccs == null && ((FacetField)this.freq).subFacets.isEmpty()) {
            return;
        }
        if (subDomain == null) {
            subDomain = this.fcontext.searcher.getDocSet(filter, this.fcontext.base);
        }
        if (this.otherAccs != null) {
            for (SlotAcc acc : this.otherAccs) {
                acc.reset();
                acc.collect(subDomain, 0);
                acc.setValues(target, 0);
            }
        }
        this.processSubs(target, filter, subDomain, false, null);
    }

    @Override
    protected void processStats(SimpleOrderedMap<Object> bucket, DocSet docs, int docCount) throws IOException {
        if (docCount == 0 && !((FacetField)this.freq).processEmpty || ((FacetField)this.freq).getFacetStats().size() == 0) {
            bucket.add("count", (Object)docCount);
            return;
        }
        this.createAccs(docCount, 1);
        int collected = this.collect(docs, 0);
        assert (collected == docCount);
        this.addStats(bucket, collected, 0);
    }

    private void addStats(SimpleOrderedMap<Object> target, int count, int slotNum) throws IOException {
        target.add("count", (Object)count);
        if (count > 0 || ((FacetField)this.freq).processEmpty) {
            for (SlotAcc acc : this.accs) {
                acc.setValues(target, slotNum);
            }
        }
    }

    @Override
    void setNextReader(LeafReaderContext ctx) throws IOException {
        super.setNextReader(ctx);
    }

    void setNextReaderFirstPhase(LeafReaderContext ctx) throws IOException {
        if (this.collectAcc != null) {
            this.collectAcc.setNextReader(ctx);
        }
        if (this.otherAccs != null) {
            for (SlotAcc acc : this.otherAccs) {
                acc.setNextReader(ctx);
            }
        }
    }

    static <T> List<T> asList(Object list) {
        return list != null ? (List)list : Collections.EMPTY_LIST;
    }

    protected SimpleOrderedMap<Object> refineFacets() throws IOException {
        Map bucketFacetInfo;
        Map facetInfo;
        Object bucketVal;
        boolean skipThisFacet = (this.fcontext.flags & 4) != 0;
        List leaves = FacetFieldProcessor.asList(this.fcontext.facetInfo.get("_l"));
        List<List> skip = FacetFieldProcessor.asList(this.fcontext.facetInfo.get("_s"));
        List<List> partial = FacetFieldProcessor.asList(this.fcontext.facetInfo.get("_p"));
        SimpleOrderedMap res = new SimpleOrderedMap();
        ArrayList<SimpleOrderedMap<Object>> bucketList = new ArrayList<SimpleOrderedMap<Object>>(leaves.size() + skip.size() + partial.size());
        res.add("buckets", bucketList);
        this.createAccs(-1, 1);
        for (Object bucketVal2 : leaves) {
            bucketList.add(this.refineBucket(bucketVal2, false, null));
        }
        for (List bucketAndFacetInfo : skip) {
            assert (bucketAndFacetInfo.size() == 2);
            bucketVal = bucketAndFacetInfo.get(0);
            facetInfo = (Map)bucketAndFacetInfo.get(1);
            bucketList.add(this.refineBucket(bucketVal, true, facetInfo));
        }
        for (List bucketAndFacetInfo : partial) {
            assert (bucketAndFacetInfo.size() == 2);
            bucketVal = bucketAndFacetInfo.get(0);
            facetInfo = (Map)bucketAndFacetInfo.get(1);
            bucketList.add(this.refineBucket(bucketVal, false, facetInfo));
        }
        if (((FacetField)this.freq).missing && ((bucketFacetInfo = (Map)this.fcontext.facetInfo.get("missing")) != null || !skipThisFacet)) {
            SimpleOrderedMap missingBucket = new SimpleOrderedMap();
            this.fillBucket((SimpleOrderedMap<Object>)missingBucket, FacetFieldProcessor.getFieldMissingQuery(this.fcontext.searcher, ((FacetField)this.freq).field), null, skipThisFacet, bucketFacetInfo);
            res.add("missing", (Object)missingBucket);
        }
        if (((FacetField)this.freq).numBuckets && !skipThisFacet) {
            this.calculateNumBuckets((SimpleOrderedMap<Object>)res);
        }
        return res;
    }

    private SimpleOrderedMap<Object> refineBucket(Object bucketVal, boolean skip, Map<String, Object> facetInfo) throws IOException {
        SimpleOrderedMap bucket = new SimpleOrderedMap();
        FieldType ft = this.sf.getType();
        bucket.add("val", bucketVal);
        Query domainQ = ft.getFieldQuery(null, this.sf, bucketVal.toString());
        this.fillBucket((SimpleOrderedMap<Object>)bucket, domainQ, null, skip, facetInfo);
        return bucket;
    }

    static class SpecialSlotAcc
    extends SlotAcc {
        SlotAcc collectAcc;
        SlotAcc[] otherAccs;
        int collectAccSlot;
        int otherAccsSlot;
        long count;

        SpecialSlotAcc(FacetContext fcontext, SlotAcc collectAcc, int collectAccSlot, SlotAcc[] otherAccs, int otherAccsSlot) {
            super(fcontext);
            this.collectAcc = collectAcc;
            this.collectAccSlot = collectAccSlot;
            this.otherAccs = otherAccs;
            this.otherAccsSlot = otherAccsSlot;
        }

        public int getCollectAccSlot() {
            return this.collectAccSlot;
        }

        public int getOtherAccSlot() {
            return this.otherAccsSlot;
        }

        long getSpecialCount() {
            return this.count;
        }

        @Override
        public void collect(int doc, int slot) throws IOException {
            assert (slot != this.collectAccSlot || slot < 0);
            ++this.count;
            if (this.collectAcc != null) {
                this.collectAcc.collect(doc, this.collectAccSlot);
            }
            if (this.otherAccs != null) {
                for (SlotAcc otherAcc : this.otherAccs) {
                    otherAcc.collect(doc, this.otherAccsSlot);
                }
            }
        }

        @Override
        public void setNextReader(LeafReaderContext readerContext) throws IOException {
            if (this.collectAcc != null) {
                this.collectAcc.setNextReader(readerContext);
            }
            if (this.otherAccs != null) {
                for (SlotAcc otherAcc : this.otherAccs) {
                    otherAcc.setNextReader(readerContext);
                }
            }
        }

        @Override
        public int compare(int slotA, int slotB) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Object getValue(int slotNum) throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setValues(SimpleOrderedMap<Object> bucket, int slotNum) throws IOException {
            if (this.collectAcc != null) {
                this.collectAcc.setValues(bucket, this.collectAccSlot);
            }
            if (this.otherAccs != null) {
                for (SlotAcc otherAcc : this.otherAccs) {
                    otherAcc.setValues(bucket, this.otherAccsSlot);
                }
            }
        }

        @Override
        public void reset() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void resize(SlotAcc.Resizer resizer) {
            if (this.collectAccSlot >= 0) {
                this.collectAccSlot = resizer.getNewSlot(this.collectAccSlot);
            }
        }
    }

    private static class Slot {
        int slot;

        private Slot() {
        }
    }
}

