/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.schema;

import java.lang.invoke.MethodHandles;
import java.util.Collection;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.document.FloatPoint;
import org.apache.lucene.document.StoredField;
import org.apache.lucene.index.DocValuesType;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.queries.function.ValueSource;
import org.apache.lucene.queries.function.valuesource.FloatFieldSource;
import org.apache.lucene.queries.function.valuesource.MultiValuedFloatFieldSource;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.SortField;
import org.apache.lucene.search.SortedNumericSelector;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefBuilder;
import org.apache.lucene.util.NumericUtils;
import org.apache.solr.schema.FloatValueFieldType;
import org.apache.solr.schema.NumberType;
import org.apache.solr.schema.PointField;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.search.QParser;
import org.apache.solr.uninverting.UninvertingReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FloatPointField
extends PointField
implements FloatValueFieldType {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    public FloatPointField() {
        this.type = NumberType.FLOAT;
    }

    @Override
    public Object toNativeType(Object val) {
        if (val == null) {
            return null;
        }
        if (val instanceof Number) {
            return Float.valueOf(((Number)val).floatValue());
        }
        if (val instanceof String) {
            return Float.valueOf(Float.parseFloat((String)val));
        }
        return super.toNativeType(val);
    }

    @Override
    public Query getPointRangeQuery(QParser parser, SchemaField field, String min, String max, boolean minInclusive, boolean maxInclusive) {
        float actualMax;
        float actualMin;
        if (min == null) {
            actualMin = Float.NEGATIVE_INFINITY;
        } else {
            actualMin = Float.parseFloat(min);
            if (!minInclusive) {
                actualMin = FloatPoint.nextUp((float)actualMin);
            }
        }
        if (max == null) {
            actualMax = Float.POSITIVE_INFINITY;
        } else {
            actualMax = Float.parseFloat(max);
            if (!maxInclusive) {
                actualMax = FloatPoint.nextDown((float)actualMax);
            }
        }
        return FloatPoint.newRangeQuery((String)field.getName(), (float)actualMin, (float)actualMax);
    }

    @Override
    public Object toObject(SchemaField sf, BytesRef term) {
        return Float.valueOf(FloatPoint.decodeDimension((byte[])term.bytes, (int)term.offset));
    }

    @Override
    public Object toObject(IndexableField f) {
        Number val = f.numericValue();
        if (val != null) {
            if (!f.fieldType().stored() && f.fieldType().docValuesType() == DocValuesType.NUMERIC) {
                return Float.valueOf(Float.intBitsToFloat(val.intValue()));
            }
            if (!f.fieldType().stored() && f.fieldType().docValuesType() == DocValuesType.SORTED_NUMERIC) {
                return Float.valueOf(NumericUtils.sortableIntToFloat((int)val.intValue()));
            }
            return val;
        }
        throw new AssertionError((Object)("Unexpected state. Field: '" + f + "'"));
    }

    @Override
    protected Query getExactQuery(SchemaField field, String externalVal) {
        return FloatPoint.newExactQuery((String)field.getName(), (float)Float.parseFloat(externalVal));
    }

    @Override
    public Query getSetQuery(QParser parser, SchemaField field, Collection<String> externalVal) {
        assert (externalVal.size() > 0);
        if (!field.indexed()) {
            return super.getSetQuery(parser, field, externalVal);
        }
        float[] values = new float[externalVal.size()];
        int i = 0;
        for (String val : externalVal) {
            values[i] = Float.parseFloat(val);
            ++i;
        }
        return FloatPoint.newSetQuery((String)field.getName(), (float[])values);
    }

    @Override
    protected String indexedToReadable(BytesRef indexedForm) {
        return Float.toString(FloatPoint.decodeDimension((byte[])indexedForm.bytes, (int)indexedForm.offset));
    }

    @Override
    public void readableToIndexed(CharSequence val, BytesRefBuilder result) {
        result.grow(4);
        result.setLength(4);
        FloatPoint.encodeDimension((float)Float.parseFloat(val.toString()), (byte[])result.bytes(), (int)0);
    }

    @Override
    public SortField getSortField(SchemaField field, boolean top) {
        field.checkSortability();
        Float missingValue = null;
        boolean sortMissingLast = field.sortMissingLast();
        boolean sortMissingFirst = field.sortMissingFirst();
        if (sortMissingLast) {
            missingValue = Float.valueOf(top ? Float.NEGATIVE_INFINITY : Float.POSITIVE_INFINITY);
        } else if (sortMissingFirst) {
            missingValue = Float.valueOf(top ? Float.POSITIVE_INFINITY : Float.NEGATIVE_INFINITY);
        }
        SortField sf = new SortField(field.getName(), SortField.Type.FLOAT, top);
        sf.setMissingValue((Object)missingValue);
        return sf;
    }

    @Override
    public UninvertingReader.Type getUninversionType(SchemaField sf) {
        if (sf.multiValued()) {
            return null;
        }
        return UninvertingReader.Type.FLOAT_POINT;
    }

    @Override
    public ValueSource getValueSource(SchemaField field, QParser qparser) {
        field.checkFieldCacheSource();
        return new FloatFieldSource(field.getName());
    }

    @Override
    protected ValueSource getSingleValueSource(SortedNumericSelector.Type choice, SchemaField f) {
        return new MultiValuedFloatFieldSource(f.getName(), choice);
    }

    @Override
    public FieldType.LegacyNumericType getNumericType() {
        return FieldType.LegacyNumericType.FLOAT;
    }

    @Override
    public IndexableField createField(SchemaField field, Object value, float boost) {
        if ((double)boost != 1.0 && log.isTraceEnabled()) {
            log.trace("Can't use document/field boost for PointField. Field: " + field.getName() + ", boost: " + boost);
        }
        float floatValue = value instanceof Number ? ((Number)value).floatValue() : Float.parseFloat(value.toString());
        return new FloatPoint(field.getName(), new float[]{floatValue});
    }

    @Override
    protected StoredField getStoredField(SchemaField sf, Object value) {
        return new StoredField(sf.getName(), ((Float)this.toNativeType(value)).floatValue());
    }
}

