/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.cloud;

import com.codahale.metrics.Timer;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.solr.cloud.Overseer;
import org.apache.solr.cloud.OverseerCollectionMessageHandler;
import org.apache.solr.cloud.OverseerTaskProcessor;
import org.apache.solr.common.cloud.ClusterState;
import org.apache.solr.common.cloud.ZkNodeProps;
import org.apache.solr.common.cloud.ZkStateReader;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.SimpleOrderedMap;
import org.apache.solr.util.stats.MetricUtils;
import org.apache.zookeeper.data.Stat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OverseerStatusCmd
implements OverseerCollectionMessageHandler.Cmd {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final OverseerCollectionMessageHandler ocmh;

    public OverseerStatusCmd(OverseerCollectionMessageHandler ocmh) {
        this.ocmh = ocmh;
    }

    @Override
    public void call(ClusterState state, ZkNodeProps message, NamedList results) throws Exception {
        ZkStateReader zkStateReader = this.ocmh.zkStateReader;
        String leaderNode = OverseerTaskProcessor.getLeaderNode(zkStateReader.getZkClient());
        results.add("leader", (Object)leaderNode);
        Stat stat = new Stat();
        zkStateReader.getZkClient().getData("/overseer/queue", null, stat, true);
        results.add("overseer_queue_size", (Object)stat.getNumChildren());
        stat = new Stat();
        zkStateReader.getZkClient().getData("/overseer/queue-work", null, stat, true);
        results.add("overseer_work_queue_size", (Object)stat.getNumChildren());
        stat = new Stat();
        zkStateReader.getZkClient().getData("/overseer/collection-queue-work", null, stat, true);
        results.add("overseer_collection_queue_size", (Object)stat.getNumChildren());
        NamedList overseerStats = new NamedList();
        NamedList collectionStats = new NamedList();
        NamedList stateUpdateQueueStats = new NamedList();
        NamedList workQueueStats = new NamedList();
        NamedList collectionQueueStats = new NamedList();
        Overseer.Stats stats = this.ocmh.stats;
        for (Map.Entry<String, Overseer.Stat> entry : stats.getStats().entrySet()) {
            int errors;
            String key = entry.getKey();
            SimpleOrderedMap lst = new SimpleOrderedMap();
            if (key.startsWith("collection_")) {
                collectionStats.add(key.substring(11), (Object)lst);
                int successes = stats.getSuccessCount(entry.getKey());
                errors = stats.getErrorCount(entry.getKey());
                lst.add("requests", (Object)successes);
                lst.add("errors", (Object)errors);
                List<Overseer.FailedOp> failureDetails = stats.getFailureDetails(key);
                if (failureDetails != null) {
                    ArrayList<SimpleOrderedMap> failures = new ArrayList<SimpleOrderedMap>();
                    for (Overseer.FailedOp failedOp : failureDetails) {
                        SimpleOrderedMap fail = new SimpleOrderedMap();
                        fail.add("request", (Object)failedOp.req.getProperties());
                        fail.add("response", (Object)failedOp.resp.getResponse());
                        failures.add(fail);
                    }
                    lst.add("recent_failures", failures);
                }
            } else if (key.startsWith("/overseer/queue_")) {
                stateUpdateQueueStats.add(key.substring(16), (Object)lst);
            } else if (key.startsWith("/overseer/queue-work_")) {
                workQueueStats.add(key.substring(21), (Object)lst);
            } else if (key.startsWith("/overseer/collection-queue-work_")) {
                collectionQueueStats.add(key.substring(32), (Object)lst);
            } else {
                overseerStats.add(key, (Object)lst);
                int successes = stats.getSuccessCount(entry.getKey());
                errors = stats.getErrorCount(entry.getKey());
                lst.add("requests", (Object)successes);
                lst.add("errors", (Object)errors);
            }
            Timer timer = entry.getValue().requestTime;
            MetricUtils.addMetrics((NamedList<Object>)lst, timer);
        }
        results.add("overseer_operations", (Object)overseerStats);
        results.add("collection_operations", (Object)collectionStats);
        results.add("overseer_queue", (Object)stateUpdateQueueStats);
        results.add("overseer_internal_queue", (Object)workQueueStats);
        results.add("collection_queue", (Object)collectionQueueStats);
    }
}

