/*
 * Decompiled with CFR 0.152.
 */
package Common;

import java.util.Collection;
import java.util.Iterator;

public class IntVector {
    protected int[] data = new int[10];
    int capacityIncr = 10;
    int elt = 0;

    public IntVector() {
    }

    public IntVector(int size) {
        this.data = new int[size];
    }

    public int size() {
        return this.elt;
    }

    public void ensureAdditionalCapacity(int addCapacity) {
        this.ensureCapacity(this.data.length + addCapacity);
    }

    private void ensureCapacity(int minCapacity) {
        int oldCapacity = this.data.length;
        if (minCapacity > oldCapacity) {
            int[] oldData = this.data;
            int newCapacity = oldCapacity + this.capacityIncr;
            if (newCapacity < minCapacity) {
                newCapacity = minCapacity;
            }
            this.data = new int[newCapacity];
            System.arraycopy(oldData, 0, this.data, 0, this.elt);
        }
    }

    public int get(int index) {
        if (index >= this.elt) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        return this.data[index];
    }

    public void Reserve(int s) {
        this.ensureCapacity(s);
    }

    public void add(int b) {
        this.ensureCapacity(this.elt + 1);
        this.data[this.elt++] = b;
    }

    public void addAll(Collection c) {
        this.ensureCapacity(this.elt + c.size());
        Iterator it = c.iterator();
        while (it.hasNext()) {
            this.data[this.elt++] = (Integer)it.next();
        }
    }

    public void addAll(Integer[] b) {
        this.ensureCapacity(this.elt + b.length);
        for (int i = 0; i < b.length; ++i) {
            this.data[this.elt++] = b[i];
        }
    }

    public void set(int index, int value) {
        if (index >= this.data.length) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        this.data[index] = value;
        this.elt = index + 1;
    }

    public void setRange(int start, int value) {
        this.setRange(start, this.data.length - start, value);
    }

    public void setRange(int start, int length, int value) {
        if (start + length > this.data.length) {
            throw new ArrayIndexOutOfBoundsException("start = " + start + ", length = " + length);
        }
        for (int i = 0; i < length; ++i) {
            this.data[start + i] = value;
        }
        this.elt = start + length;
    }

    public void clear() {
        this.elt = 0;
    }

    public boolean isEmpty() {
        return this.elt == 0;
    }

    public int Back() {
        if (this.elt < 1) {
            throw new ArrayIndexOutOfBoundsException(0);
        }
        return this.data[this.elt - 1];
    }

    public int Front() {
        if (this.elt < 1) {
            throw new ArrayIndexOutOfBoundsException(0);
        }
        return this.data[0];
    }

    public void DeleteBack() {
        this.remove(this.elt - 1);
    }

    public int remove(int index) {
        if (index >= this.elt) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        int oldValue = this.data[index];
        int numMoved = this.elt - index - 1;
        Integer n = new Integer(this.elt);
        if (numMoved > 0) {
            System.arraycopy(n, index + 1, n, index, numMoved);
        }
        this.elt = n;
        return oldValue;
    }
}

