/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.tools.image;

import VASSAL.tools.image.ImageIOException;
import VASSAL.tools.image.ImageTypeConverter;
import VASSAL.tools.io.IOUtils;
import VASSAL.tools.io.TemporaryFileFactory;
import VASSAL.tools.lang.Reference;
import java.awt.image.BufferedImage;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileImageTypeConverter
implements ImageTypeConverter {
    protected final TemporaryFileFactory tfactory;

    public FileImageTypeConverter(TemporaryFileFactory temporaryFileFactory) {
        if (temporaryFileFactory == null) {
            throw new IllegalArgumentException();
        }
        this.tfactory = temporaryFileFactory;
    }

    @Override
    public BufferedImage convert(Reference<BufferedImage> reference, int n) throws ImageIOException {
        if (reference == null) {
            throw new IllegalArgumentException();
        }
        BufferedImage bufferedImage = (BufferedImage)reference.obj;
        reference.obj = null;
        if (n == 0) {
            throw new IllegalArgumentException();
        }
        File file = null;
        try {
            file = this.tfactory.create();
        }
        catch (IOException iOException) {
            throw new ImageIOException("", (Throwable)iOException);
        }
        try {
            BufferedImage bufferedImage2;
            BufferedOutputStream bufferedOutputStream = null;
            try {
                bufferedOutputStream = new BufferedOutputStream(new GZIPOutputStream(new FileOutputStream(file)));
                this.write(bufferedImage, bufferedOutputStream);
                ((OutputStream)bufferedOutputStream).close();
            }
            catch (IOException iOException) {
                try {
                    throw new ImageIOException(file, (Throwable)iOException);
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(bufferedOutputStream);
                    throw throwable;
                }
            }
            IOUtils.closeQuietly((OutputStream)bufferedOutputStream);
            int n2 = bufferedImage.getWidth();
            int n3 = bufferedImage.getHeight();
            bufferedImage = null;
            BufferedImage bufferedImage3 = new BufferedImage(n2, n3, n);
            BufferedInputStream bufferedInputStream = null;
            try {
                bufferedInputStream = new BufferedInputStream(new GZIPInputStream(new FileInputStream(file)));
                this.read(bufferedInputStream, bufferedImage3);
                ((InputStream)bufferedInputStream).close();
                bufferedImage2 = bufferedImage3;
            }
            catch (IOException iOException) {
                try {
                    throw new ImageIOException(file, (Throwable)iOException);
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(bufferedInputStream);
                    throw throwable;
                }
            }
            IOUtils.closeQuietly((InputStream)bufferedInputStream);
            return bufferedImage2;
        }
        finally {
            if (!file.delete()) {
                throw new ImageIOException(file, "failed to delete");
            }
        }
    }

    protected void write(BufferedImage bufferedImage, OutputStream outputStream) throws IOException {
        int n = bufferedImage.getWidth();
        int n2 = bufferedImage.getHeight();
        ByteBuffer byteBuffer = ByteBuffer.allocate(4 * n);
        int[] nArray = new int[n];
        for (int i = 0; i < n2; ++i) {
            bufferedImage.getRGB(0, i, n, 1, nArray, 0, n);
            byteBuffer.asIntBuffer().put(nArray);
            outputStream.write(byteBuffer.array());
        }
    }

    protected void read(InputStream inputStream, BufferedImage bufferedImage) throws IOException {
        int n = bufferedImage.getWidth();
        int n2 = bufferedImage.getHeight();
        byte[] byArray = new byte[4 * n];
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
        int[] nArray = new int[n];
        for (int i = 0; i < n2; ++i) {
            IOUtils.read((InputStream)inputStream, (byte[])byArray);
            byteBuffer.asIntBuffer().get(nArray);
            bufferedImage.setRGB(0, i, n, 1, nArray, 0, n);
        }
    }
}

