/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.counters;

import VASSAL.build.GameModule;
import VASSAL.build.module.GlobalOptions;
import VASSAL.build.module.Map;
import VASSAL.build.module.documentation.HelpFile;
import VASSAL.build.module.map.MovementReporter;
import VASSAL.build.module.map.boardPicker.Board;
import VASSAL.build.module.properties.PropertySource;
import VASSAL.command.Command;
import VASSAL.command.NullCommand;
import VASSAL.configure.BooleanConfigurer;
import VASSAL.configure.FormattedExpressionConfigurer;
import VASSAL.configure.NamedHotKeyConfigurer;
import VASSAL.configure.StringConfigurer;
import VASSAL.counters.Deck;
import VASSAL.counters.DeckVisitor;
import VASSAL.counters.DeckVisitorDispatcher;
import VASSAL.counters.Decorator;
import VASSAL.counters.FreeRotator;
import VASSAL.counters.GamePiece;
import VASSAL.counters.KeyCommand;
import VASSAL.counters.PieceEditor;
import VASSAL.counters.Stack;
import VASSAL.i18n.PieceI18nData;
import VASSAL.i18n.TranslatablePiece;
import VASSAL.tools.FormattedString;
import VASSAL.tools.NamedKeyStroke;
import VASSAL.tools.SequenceEncoder;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Window;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;

public class Translate
extends Decorator
implements TranslatablePiece {
    private static final String _0 = "0";
    public static final String ID = "translate;";
    protected KeyCommand[] commands;
    protected String commandName;
    protected NamedKeyStroke keyCommand;
    protected FormattedString xDist = new FormattedString("");
    protected FormattedString xIndex = new FormattedString("");
    protected FormattedString xOffset = new FormattedString("");
    protected FormattedString yDist = new FormattedString("");
    protected FormattedString yIndex = new FormattedString("");
    protected FormattedString yOffset = new FormattedString("");
    protected String description;
    protected boolean moveStack;
    protected KeyCommand moveCommand;
    protected static MoveExecuter mover;

    public Translate() {
        this("translate;Move Forward", null);
    }

    public Translate(String string, GamePiece gamePiece) {
        this.mySetType(string);
        this.setInner(gamePiece);
    }

    public String getDescription() {
        String string = "Move fixed distance";
        if (this.description.length() > 0) {
            string = string + " - " + this.description;
        }
        return string;
    }

    public void mySetType(String string) {
        string = string.substring(ID.length());
        SequenceEncoder.Decoder decoder = new SequenceEncoder.Decoder(string, ';');
        this.commandName = decoder.nextToken("Move Forward");
        this.keyCommand = decoder.nextNamedKeyStroke('M');
        this.xDist.setFormat(decoder.nextToken(_0));
        this.yDist.setFormat(decoder.nextToken("60"));
        this.moveStack = decoder.nextBoolean(true);
        this.xIndex.setFormat(decoder.nextToken(_0));
        this.yIndex.setFormat(decoder.nextToken(_0));
        this.xOffset.setFormat(decoder.nextToken(_0));
        this.yOffset.setFormat(decoder.nextToken(_0));
        this.description = decoder.nextToken("");
        this.commands = null;
    }

    protected KeyCommand[] myGetKeyCommands() {
        if (this.commands == null) {
            this.moveCommand = new KeyCommand(this.commandName, this.keyCommand, Decorator.getOutermost(this), (TranslatablePiece)this);
            this.commands = this.commandName.length() > 0 && this.keyCommand != null && !this.keyCommand.isNull() ? new KeyCommand[]{this.moveCommand} : new KeyCommand[0];
        }
        this.moveCommand.setEnabled(this.getMap() != null);
        return this.commands;
    }

    public String myGetState() {
        return "";
    }

    public String myGetType() {
        SequenceEncoder sequenceEncoder = new SequenceEncoder(';');
        sequenceEncoder.append(this.commandName).append(this.keyCommand).append(this.xDist.getFormat()).append(this.yDist.getFormat()).append(this.moveStack).append(this.xIndex.getFormat()).append(this.yIndex.getFormat()).append(this.xOffset.getFormat()).append(this.yOffset.getFormat()).append(this.description);
        return ID + sequenceEncoder.getValue();
    }

    public Command keyEvent(KeyStroke keyStroke) {
        this.myGetKeyCommands();
        if (this.moveCommand.matches(keyStroke)) {
            return this.myKeyEvent(keyStroke);
        }
        return super.keyEvent(keyStroke);
    }

    public Command myKeyEvent(KeyStroke keyStroke) {
        this.myGetKeyCommands();
        Command command = null;
        if (this.moveCommand.matches(keyStroke)) {
            GamePiece gamePiece;
            this.setOldProperties();
            if (mover == null) {
                mover = new MoveExecuter();
                mover.setKeyEvent(keyStroke);
                SwingUtilities.invokeLater(mover);
            }
            if ((gamePiece = this.findTarget(keyStroke)) != null) {
                command = this.moveTarget(gamePiece);
            }
            mover.addKeyEventTarget(this.piece);
            command = new NullCommand(){

                public boolean isNull() {
                    return false;
                }
            };
        }
        return command;
    }

    protected Command moveTarget(GamePiece gamePiece) {
        Point point = mover.getUpdatedPosition(gamePiece);
        if (point == null) {
            point = new Point(this.getPosition());
        }
        this.translate(point);
        FreeRotator freeRotator = (FreeRotator)Decorator.getDecorator(this, FreeRotator.class);
        if (freeRotator != null) {
            Point point2 = this.getPosition().getLocation();
            Point2D point2D = point.getLocation();
            point2D = AffineTransform.getRotateInstance(freeRotator.getCumulativeAngleInRadians(), ((Point2D)point2).getX(), ((Point2D)point2).getY()).transform(point2D, null);
            point = new Point((int)point2D.getX(), (int)point2D.getY());
        }
        if (!Boolean.TRUE.equals(Decorator.getOutermost(this).getProperty("IgnoreGrid"))) {
            point = this.getMap().snapTo(point);
        }
        mover.add(gamePiece.getMap(), gamePiece, point);
        return null;
    }

    protected void translate(Point point) {
        int n = 0;
        int n2 = 0;
        GamePiece gamePiece = Decorator.getOutermost(this);
        Board board = gamePiece.getMap().findBoard(point);
        int n3 = this.xDist.getTextAsInt((PropertySource)gamePiece, "Xdistance", this);
        int n4 = this.xIndex.getTextAsInt((PropertySource)gamePiece, "Xindex", this);
        int n5 = this.xOffset.getTextAsInt((PropertySource)gamePiece, "Xoffset", this);
        n = n3 + n4 * n5;
        if (board != null) {
            n = (int)Math.round(board.getMagnification() * (double)n);
        }
        int n6 = this.yDist.getTextAsInt((PropertySource)gamePiece, "Ydistance", this);
        int n7 = this.yIndex.getTextAsInt((PropertySource)gamePiece, "Yindex", this);
        int n8 = this.yOffset.getTextAsInt((PropertySource)gamePiece, "Yoffset", this);
        n2 = n6 + n7 * n8;
        if (board != null) {
            n2 = (int)Math.round(board.getMagnification() * (double)n2);
        }
        point.translate(n, -n2);
    }

    protected GamePiece findTarget(KeyStroke keyStroke) {
        GamePiece gamePiece;
        GamePiece gamePiece2 = gamePiece = Decorator.getOutermost(this);
        if (this.moveStack && gamePiece.getParent() != null && !gamePiece.getParent().isExpanded()) {
            gamePiece2 = gamePiece != gamePiece.getParent().topPiece(GameModule.getUserId()) ? null : gamePiece.getParent();
        }
        return gamePiece2;
    }

    public void mySetState(String string) {
    }

    public Rectangle boundingBox() {
        return this.getInner().boundingBox();
    }

    public void draw(Graphics graphics, int n, int n2, Component component, double d) {
        this.getInner().draw(graphics, n, n2, component, d);
    }

    public String getName() {
        return this.getInner().getName();
    }

    public Shape getShape() {
        return this.getInner().getShape();
    }

    public PieceEditor getEditor() {
        return new Editor(this);
    }

    public HelpFile getHelpFile() {
        return HelpFile.getReferenceManualPage("Translate.htm");
    }

    public PieceI18nData getI18nData() {
        return this.getI18nData(this.commandName, this.getCommandDescription(this.description, "Move Fixed Distance command"));
    }

    public static class MoveExecuter
    implements Runnable {
        private List<Move> moves = new ArrayList<Move>();
        private Set<GamePiece> pieces = new HashSet<GamePiece>();
        private KeyStroke stroke;
        private List<GamePiece> innerPieces = new ArrayList<GamePiece>();

        public void run() {
            mover = null;
            NullCommand nullCommand = new NullCommand();
            for (final Move object : this.moves) {
                final Map.Merger merger = new Map.Merger(object.map, object.pos, object.piece);
                DeckVisitor deckVisitor = new DeckVisitor(){

                    public Object visitDeck(Deck deck) {
                        return merger.visitDeck(deck);
                    }

                    public Object visitStack(Stack stack) {
                        if (!MoveExecuter.this.pieces.contains(stack) && object.map.getPieceCollection().canMerge(stack, object.piece)) {
                            return merger.visitStack(stack);
                        }
                        return null;
                    }

                    public Object visitDefault(GamePiece gamePiece) {
                        if (!MoveExecuter.this.pieces.contains(gamePiece) && object.map.getPieceCollection().canMerge(gamePiece, object.piece)) {
                            return merger.visitDefault(gamePiece);
                        }
                        return null;
                    }
                };
                DeckVisitorDispatcher deckVisitorDispatcher = new DeckVisitorDispatcher(deckVisitor);
                Command command = object.map.apply(deckVisitorDispatcher);
                if (command == null) {
                    command = object.map.placeAt(object.piece, object.pos);
                    if (object.map.getMoveKey() != null) {
                        command.append(Decorator.getOutermost(object.piece).keyEvent(object.map.getMoveKey()));
                    }
                }
                nullCommand.append(command);
                if (object.piece.getMap() == object.map) {
                    object.map.ensureVisible(object.map.selectionBoundsOf(object.piece));
                }
                this.pieces.remove(object.piece);
                object.map.repaint();
            }
            MovementReporter movementReporter = new MovementReporter(nullCommand);
            if (GlobalOptions.getInstance().autoReportEnabled()) {
                Command command = movementReporter.getReportCommand();
                if (command != null) {
                    command.execute();
                }
                nullCommand.append(command);
            }
            nullCommand.append(movementReporter.markMovedPieces());
            if (this.stroke != null) {
                for (GamePiece gamePiece : this.innerPieces) {
                    nullCommand.append(gamePiece.keyEvent(this.stroke));
                }
            }
            GameModule.getGameModule().sendAndLog(nullCommand);
        }

        public void add(Map map, GamePiece gamePiece, Point point) {
            this.moves.add(new Move(map, gamePiece, point));
            this.pieces.add(gamePiece);
        }

        public void addKeyEventTarget(GamePiece gamePiece) {
            this.innerPieces.add(gamePiece);
        }

        public void setKeyEvent(KeyStroke keyStroke) {
            this.stroke = keyStroke;
        }

        public Point getUpdatedPosition(GamePiece gamePiece) {
            Point point = null;
            for (Move move : this.moves) {
                if (move.piece != gamePiece) continue;
                point = move.pos;
            }
            return point;
        }

        private static class Move {
            private Map map;
            private GamePiece piece;
            private Point pos;

            public Move(Map map, GamePiece gamePiece, Point point) {
                this.map = map;
                this.piece = gamePiece;
                this.pos = point;
            }
        }
    }

    public static class Editor
    implements PieceEditor {
        private FormattedExpressionConfigurer xDist;
        private FormattedExpressionConfigurer yDist;
        private StringConfigurer name;
        private NamedHotKeyConfigurer key;
        private JPanel controls = new JPanel();
        private BooleanConfigurer moveStack;
        protected BooleanConfigurer advancedInput;
        protected FormattedExpressionConfigurer xIndexInput;
        protected FormattedExpressionConfigurer xOffsetInput;
        protected FormattedExpressionConfigurer yIndexInput;
        protected FormattedExpressionConfigurer yOffsetInput;
        protected StringConfigurer descInput;

        public Editor(Translate translate) {
            this.controls.setLayout(new BoxLayout(this.controls, 1));
            this.descInput = new StringConfigurer(null, "Description:  ", translate.description);
            this.controls.add(this.descInput.getControls());
            this.name = new StringConfigurer(null, "Command Name:  ", translate.commandName);
            this.controls.add(this.name.getControls());
            this.key = new NamedHotKeyConfigurer(null, "Keyboard shortcut:  ", translate.keyCommand);
            this.controls.add(this.key.getControls());
            this.xDist = new FormattedExpressionConfigurer(null, "Distance to the right:  ", translate.xDist.getFormat(), translate);
            this.controls.add(this.xDist.getControls());
            this.yDist = new FormattedExpressionConfigurer(null, "Distance upwards:  ", translate.yDist.getFormat(), translate);
            this.controls.add(this.yDist.getControls());
            this.moveStack = new BooleanConfigurer(null, "Move entire stack?", (Boolean)translate.moveStack);
            this.controls.add(this.moveStack.getControls());
            this.advancedInput = new BooleanConfigurer(null, "Advanced Options", false);
            this.advancedInput.addPropertyChangeListener(new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    Editor.this.updateAdvancedVisibility();
                }
            });
            this.controls.add(this.advancedInput.getControls());
            Box box = Box.createHorizontalBox();
            this.xIndexInput = new FormattedExpressionConfigurer(null, "Additional offset to the right:  ", translate.xIndex.getFormat(), translate);
            box.add(this.xIndexInput.getControls());
            this.xOffsetInput = new FormattedExpressionConfigurer(null, " times ", translate.xOffset.getFormat(), translate);
            box.add(this.xOffsetInput.getControls());
            this.controls.add(box);
            box = Box.createHorizontalBox();
            this.yIndexInput = new FormattedExpressionConfigurer(null, "Additional offset upwards:  ", translate.yIndex.getFormat(), translate);
            box.add(this.yIndexInput.getControls());
            this.yOffsetInput = new FormattedExpressionConfigurer(null, " times ", translate.yOffset.getFormat(), translate);
            box.add(this.yOffsetInput.getControls());
            this.controls.add(box);
            this.updateAdvancedVisibility();
        }

        private void updateAdvancedVisibility() {
            boolean bl = this.advancedInput.booleanValue();
            this.xIndexInput.getControls().setVisible(bl);
            this.xOffsetInput.getControls().setVisible(bl);
            this.yIndexInput.getControls().setVisible(bl);
            this.yOffsetInput.getControls().setVisible(bl);
            Window window = SwingUtilities.getWindowAncestor(this.controls);
            if (window != null) {
                window.pack();
            }
        }

        public Component getControls() {
            return this.controls;
        }

        public String getState() {
            return "";
        }

        public String getType() {
            SequenceEncoder sequenceEncoder = new SequenceEncoder(';');
            sequenceEncoder.append(this.name.getValueString()).append(this.key.getValueString()).append(this.xDist.getValueString()).append(this.yDist.getValueString()).append(this.moveStack.getValueString()).append(this.xIndexInput.getValueString()).append(this.yIndexInput.getValueString()).append(this.xOffsetInput.getValueString()).append(this.yOffsetInput.getValueString()).append(this.descInput.getValueString());
            return Translate.ID + sequenceEncoder.getValue();
        }
    }
}

