/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.configure;

import VASSAL.build.Buildable;
import VASSAL.build.Builder;
import VASSAL.build.Configurable;
import VASSAL.build.module.documentation.HelpWindow;
import VASSAL.configure.ConfigureTree;
import VASSAL.configure.Configurer;
import VASSAL.configure.ShowHelpAction;
import VASSAL.tools.ErrorDialog;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class PropertiesWindow
extends JDialog {
    private static final long serialVersionUID = 1L;
    private Configurer configurer;
    private Configurable target;
    private Element originalState;

    public PropertiesWindow(Frame frame, boolean bl, Configurable configurable, HelpWindow helpWindow) {
        super(frame, bl);
        this.initialize(configurable, helpWindow);
    }

    protected void initialize(Configurable configurable, HelpWindow helpWindow) {
        Serializable serializable;
        Object object;
        this.target = configurable;
        this.originalState = configurable.getBuildElement(Builder.createNewDocument());
        Node node = this.originalState.getFirstChild();
        while (node != null) {
            object = node.getNextSibling();
            if (1 == node.getNodeType()) {
                try {
                    serializable = Class.forName(((Element)node).getTagName());
                    if (Buildable.class.isAssignableFrom((Class<?>)serializable)) {
                        this.originalState.removeChild(node);
                    }
                }
                catch (ClassNotFoundException classNotFoundException) {
                }
                catch (ExceptionInInitializerError exceptionInInitializerError) {
                    ErrorDialog.bug(exceptionInInitializerError);
                }
                catch (LinkageError linkageError) {
                    ErrorDialog.bug(linkageError);
                }
            }
            node = object;
        }
        this.setLayout(new BoxLayout(this.getContentPane(), 1));
        this.configurer = configurable.getConfigurer();
        configurable.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if ("name".equals(propertyChangeEvent.getPropertyName())) {
                    PropertiesWindow.this.setTitle((String)propertyChangeEvent.getNewValue());
                }
            }
        });
        this.add(this.configurer.getControls());
        this.setTitle(ConfigureTree.getConfigureName(configurable));
        object = Box.createHorizontalBox();
        serializable = new JButton("Ok");
        ((AbstractButton)serializable).addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PropertiesWindow.this.save();
            }
        });
        ((Container)object).add((Component)serializable);
        JButton jButton = new JButton("Cancel");
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PropertiesWindow.this.cancel();
            }
        });
        ((Container)object).add(jButton);
        if (configurable.getHelpFile() != null) {
            ShowHelpAction showHelpAction = new ShowHelpAction(configurable.getHelpFile().getContents(), null);
            JButton jButton2 = new JButton(showHelpAction);
            ((Container)object).add(jButton2);
            this.pack();
        }
        this.add((Component)object);
        this.pack();
        this.setLocationRelativeTo(this.getParent());
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                PropertiesWindow.this.cancel();
            }
        });
    }

    public void cancel() {
        this.target.build(this.originalState);
        this.dispose();
    }

    public void save() {
        this.configurer.getValue();
        this.dispose();
    }
}

