topic "GUI Tutorial";
[2 $$0,0#00000000000000000000000000000000:Default]
[l288;i1120;a17;O9;~~~.1408;2 $$1,0#10431211400427159095818037425705:param]
[a83;*R6 $$2,5#31310162474203024125188417583966:caption]
[H4;b83;*4 $$3,5#07864147445237544204411237157677:title]
[i288;O9;C2 $$4,6#40027414424643823182269349404212:item]
[b42;a42;ph2 $$5,5#45413000475342174754091244180557:text]
[l288;b17;a17;2 $$6,6#27521748481378242620020725143825:desc]
[l321;C@5;1 $$7,7#20902679421464641399138805415013:code]
[b2503;2 $$8,0#65142375456100023862071332075487:separator]
[*@(0.0.255)2 $$9,0#83433469410354161042741608181528:base]
[C2 $$10,0#37138531426314131251341829483380:class]
[l288;a17;*1 $$11,11#70004532496200323422659154056402:requirement]
[i417;b42;a42;O9;~~~.416;2 $$12,12#10566046415157235020018451313112:tparam]
[b167;C2 $$13,13#92430459443460461911108080531343:item1]
[i288;a42;O9;C2 $$14,14#77422149456609303542238260500223:item2]
[*@2$(0.128.128)2 $$15,15#34511555403152284025741354420178:NewsDate]
[l321;*C$7;2 $$16,16#03451589433145915344929335295360:result]
[l321;b83;a83;*C$7;2 $$17,17#07531550463529505371228428965313:result`-line]
[l160;*C+117 $$18,5#88603949442205825958800053222425:package`-title]
[2 $$19,0#53580023442335529039900623488521:gap]
[C2 $$20,20#70211524482531209251820423858195:class`-nested]
[b50;2 $$21,21#03324558446220344731010354752573:Par]
[{_}%EN-US 
[s2; GUI Tutorial&]
[s5;~~~2240; Welcome in GUI Tutorial! Here you will learn how to 
write GUI applications using U`+`+ library. All code mentions 
in this tutorial is multi platform. It means it works exactly 
the same on different operating system. Moreover, examples attached 
in this tutorial are bundle with U`+`+ standard distribution 
and they are localized in [* tutorial] assembly. So, you don`'t 
need to rewrite it by yourself. Good luck!&]
[s3; Table of contents&]
[s0; &]
[s0; [^topic`:`/`/CtrlLib`/srcdoc`/Tutorial`$en`-us`#1^ 1. GUI application 
main function]&]
[s0; [^topic`:`/`/CtrlLib`/srcdoc`/Tutorial`$en`-us`#2^ 2. Application 
window]&]
[s0; [^topic`:`/`/CtrlLib`/srcdoc`/Tutorial`$en`-us`#3^ 3. Modifying 
TopWindow properties]&]
[s0; [^topic`:`/`/CtrlLib`/srcdoc`/Tutorial`$en`-us`#4^ 4. Painting 
the view area]&]
[s0; [^topic`:`/`/CtrlLib`/srcdoc`/Tutorial`$en`-us`#5^ 5. Reacting 
to input events]&]
[s0; [^topic`:`/`/CtrlLib`/srcdoc`/Tutorial`$en`-us`#6^ 6. Multiple 
main windows]&]
[s0; [^topic`:`/`/CtrlLib`/srcdoc`/Tutorial`$en`-us`#7^ 7. Menu]&]
[s0; [^topic`:`/`/CtrlLib`/srcdoc`/Tutorial`$en`-us`#8^ 8. Context 
menu]&]
[s0; [^topic`:`/`/CtrlLib`/srcdoc`/Tutorial`$en`-us`#9^ 9. Context 
menu alternative]&]
[s0; [^topic`:`/`/CtrlLib`/srcdoc`/Tutorial`$en`-us`#10^ 10. Adding 
images]&]
[s0; [^topic`:`/`/CtrlLib`/srcdoc`/Tutorial`$en`-us`#11^ 11. Toolbar]&]
[s0; [^topic`:`/`/CtrlLib`/srcdoc`/Tutorial`$en`-us`#12^ 12. StatusBar 
and decorative Frames]&]
[s0; [^topic`:`/`/CtrlLib`/srcdoc`/Tutorial`$en`-us`#13^ 13. Adding 
child Ctrls `- widgets, reacting to widget events]&]
[s0; [^topic`:`/`/CtrlLib`/srcdoc`/Tutorial`$en`-us`#14^ 14. More about 
logical coordinates]&]
[s0; [^topic`:`/`/CtrlLib`/srcdoc`/Tutorial`$en`-us`#15^ 15. Font`-zoomed 
logical coordinates]&]
[s0; [^topic`:`/`/CtrlLib`/srcdoc`/Tutorial`$en`-us`#16^ 16. Layouts]&]
[s0; [^topic`:`/`/CtrlLib`/srcdoc`/Tutorial`$en`-us`#17^ 17. Value 
of widget]&]
[s0; [^topic`:`/`/CtrlLib`/srcdoc`/Tutorial`$en`-us`#18^ 18. Accepting 
and rejecting widgets]&]
[s0; [^topic`:`/`/CtrlLib`/srcdoc`/Tutorial`$en`-us`#19^ 19. Widget 
edit status flags]&]
[s0; [^topic`:`/`/CtrlLib`/srcdoc`/Tutorial`$en`-us`#20^ 20. Breaking 
the modal loop]&]
[s0; [^topic`:`/`/CtrlLib`/srcdoc`/Tutorial`$en`-us`#21^ 21. Creating 
and using custom widgets]&]
[s0; [^topic`:`/`/CtrlLib`/srcdoc`/Tutorial`$en`-us`#22^ 22. Non`-modal 
dialogs]&]
[s0; &]
[s3;:1: 1. GUI application main function&]
[s5; To hide platform specific differences, U`+`+ GUI application 
main function is defined using [* GUI`_APP`_MAIN] macro:&]
[s5; &]
[s7; #include <CtrlLib/CtrlLib.h>&]
[s7; &]
[s7; using namespace Upp;&]
[s7; &]
[s7; [* GUI`_APP`_MAIN] `{&]
[s7; -|PromptOK(`"Hello world`");&]
[s7; `}&]
[s5; &]
[s0;= 
@@rawimage:1068&818
(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)
&]
[s5; &]
[s5; Please notice that [* PromptOK] function display simply information 
dialog with the given parameter in this case it is `"Hello world`". 
Of course, in the [* CtrlLib ]package, there are more similar library 
calls. For example `- if you want to display an error you can 
use [* ErrorOK ]and for warnings it is corresponding [* Exclamation 
]function.&]
[s5; To use U`+`+ GUI related code, all you need to do is include 
[*/ <CtrlLib/CtrlLib.h>] header. Please also make sure that [* CtrlLib 
]package is attached to your current project.&]
[s5; &]
[s3;:2: 2. Application window&]
[s5; Application top`-level windows are of [* TopWindow] class. You 
can run modal event loop for [* TopWindow] using the [* Run] or [* Execute] 
methods. Both methods open the window if it is not yet open (you 
can also open it using [* Open] or [* OpenMain]). Unlike [* Run], [* Execute] 
also closes the window at the end of modal loop. [* TopWindow] 
is also closed by destructor.&]
[s5; &]
[s7; #include <CtrlLib/CtrlLib.h>&]
[s7; &]
[s7; using namespace Upp;&]
[s7; &]
[s7; GUI`_APP`_MAIN `{&]
[s7; -|[* TopWindow] w;&]
[s7; -|w.[* Run]();&]
[s7; `}&]
[s5; &]
[s0;= 
@@rawimage:2692&1419
(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)
&]
[s5; &]
[s3;:3: 3. Modifying TopWindow properties&]
[s5; You can modify properties and behaviour of [* TopWindow] using 
`"modifier`" methods. Note that modifiers usually return `*this 
as return value, which results in simplified syntax. You can 
also setup the size of [* TopWindow] using [* SetRect] (note that 
unless instructed otherwise, U`+`+ will center the position of 
window).&]
[s5; &]
[s7; #include <CtrlLib/CtrlLib.h>&]
[s7; &]
[s7; using namespace Upp;&]
[s7; &]
[s7; GUI`_APP`_MAIN&]
[s7; `{&]
[s7; -|TopWindow w;&]
[s7; -|w.[* Title](`"My application`").[* MinimizeBox]().[* Sizeable]();&]
[s7; -|w.[* SetRect](0, 0, 200, 300);&]
[s7; -|w.Run();&]
[s7; `}&]
[s5; &]
[s0;= 
@@rawimage:2000&1085
(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)
&]
[s5; &]
[s3;:4: 4. Painting the view area&]
[s5; In order to display something inside [* TopWindow] view area, 
you have to create derived class and override [* Paint] method:&]
[s5; &]
[s7; #include <CtrlLib/CtrlLib.h>&]
[s7; &]
[s7; using namespace Upp;&]
[s7; &]
[s7; struct MyAppWindow : TopWindow `{&]
[s7; [* -|virtual void Paint(Draw`& w) `{]&]
[s7; [* -|-|w.DrawRect(GetSize(), SWhite);]&]
[s7; [* -|-|w.DrawText(20, 20, `"Hello world!`", Arial(30), Magenta);]&]
[s7; [* -|`}]&]
[s7; -|&]
[s7; -|MyAppWindow() `{&]
[s7; -|-|Title(`"My application`").Zoomable().Sizeable();&]
[s7; -|`}&]
[s7; `};&]
[s7; &]
[s7; GUI`_APP`_MAIN&]
[s7; `{&]
[s7; -|MyAppWindow app;&]
[s7; -|app.SetRect(0, 0, 200, 100);&]
[s7; -|app.Run();&]
[s7; `}&]
[s5; &]
[s0;= 
@@rawimage:1426&573
(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)
 &]
[s0;= &]
[s0;= 
@@rawimage:1675&695
(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)
&]
[s5;=l288;r224; The same application running in different operating 
systems. On the top MS Windows and on the bottom GNU/Linux with 
KDE.&]
[s5; &]
[s3;:5: 5. Reacting to input events&]
[s5; In order to react to user actions like mouse clicks or keyboard 
events, you have to override appropriate virtual methods. To 
issue the repainting of view area, use the [* Refresh] method.&]
[s5; &]
[s7; #include <CtrlLib/CtrlLib.h>&]
[s7; &]
[s7; using namespace Upp;&]
[s7; &]
[s7; struct MyAppWindow : TopWindow `{&]
[s7; -|Point  p;&]
[s7; -|String text;&]
[s7; -|&]
[s7; [* -|virtual void LeftDown(Point pos, dword flags) `{]&]
[s7; [* -|-|p `= pos;]&]
[s7; [* -|-|Refresh();]&]
[s7; [* -|`}]&]
[s7;* &]
[s7; [* -|virtual void MouseMove(Point pos, dword flags) `{]&]
[s7; [* -|-|text `= Format(`"`[%d:%d`]`", pos.x, pos.y);]&]
[s7; [* -|-|Refresh();]&]
[s7; [* -|`}]&]
[s7; &]
[s7; -|virtual void Paint(Draw`& w) `{&]
[s7; -|-|w.DrawRect(GetSize(), SWhite);&]
[s7; -|-|w.DrawText(p.x, p.y, text, Arial(20), Magenta);&]
[s7; -|`}&]
[s7; &]
[s7; -|MyAppWindow() `{&]
[s7; -|-|Title(`"My application`").Zoomable().Sizeable();&]
[s7; -|-|p.x `= p.y `= 0;&]
[s7; -|`}&]
[s7; `};&]
[s7; &]
[s7; GUI`_APP`_MAIN&]
[s7; `{&]
[s7; -|MyAppWindow app;&]
[s7; -|app.Run();&]
[s7; `}&]
[s5; &]
[s0;= 
@@rawimage:2612&1625
(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)
&]
[s5; &]
[s3;:6: 6. Multiple main windows&]
[s5; If you application uses multiple top`-level peer windows, you 
cannot use the [* Run] method as it runs the modal loop for the 
window. Instead, you have to allocate top`-level windows on the 
heap and use [* Ctrl`::EventLoop] `- this event loop runs as long 
as there are any top`-level windows opened. Use `"[* delete this]`" 
in overridden [* Close] method to close and deallocate the main 
window.&]
[s5; &]
[s7; #include <CtrlLib/CtrlLib.h>&]
[s7; &]
[s7; using namespace Upp;&]
[s7; &]
[s7; struct MyAppWindow : TopWindow `{&]
[s7; -|virtual void Close() `{&]
[s7; -|-|delete this;&]
[s7; -|`}&]
[s7; &]
[s7; -|virtual void LeftDown(Point pos, dword flags) `{&]
[s7; [* -|-|(new MyAppWindow)`->OpenMain();]&]
[s7; -|`}&]
[s7; &]
[s7; -|virtual void Paint(Draw`& w) `{&]
[s7; -|-|w.DrawRect(GetSize(), SWhite);&]
[s7; -|-|w.DrawText(0, 0, `"Click the view area to open next window!`", 
Arial(20));&]
[s7; -|`}&]
[s7; &]
[s7; -|MyAppWindow() `{&]
[s7; -|-|Title(`"My multiwindowed application`").Zoomable().Sizeable();&]
[s7; -|`}&]
[s7; `};&]
[s7; &]
[s7; GUI`_APP`_MAIN&]
[s7; `{&]
[s7; [* -|(new MyAppWindow)`->OpenMain();]&]
[s7; [* -|Ctrl`::EventLoop();]&]
[s7; `}&]
[s5; &]
[s0;= 
@@rawimage:2000&1447
(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)
&]
[s5; &]
[s3;:7: 7. Menu&]
[s5; Content of menu in U`+`+ is represented by the function or method 
adding required menu items to the [* Bar]. Items can contain [^topic`:`/`/Core`/src`/Callbacks`$en`-us^ E
vents] to actions invoked by choosing the menu item or [^topic`:`/`/Core`/src`/Function`$en`-us`#Upp`:`:Event`:`:typedef^ E
vents] to represent sub`-menus. Menu itself is managed by [* MenuBar]. 
[* MenuBar] can act both as widget or as a [*/^topic`:`/`/CtrlCore`/srcdoc`/AboutFrames`$en`-us^ F
rame]. Frames are placed to the window border and reduce its 
view area.&]
[s5; &]
[s7; #include <CtrlLib/CtrlLib.h>&]
[s7; &]
[s7; using namespace Upp;&]
[s7; &]
[s7; struct MyAppWindow : TopWindow `{&]
[s7; -|MenuBar menu;&]
[s7; &]
[s7; -|void [* Exit]() `{&]
[s7; -|-|if(PromptOKCancel(`"Exit MyApp?`"))&]
[s7; -|-|-|Break();&]
[s7; -|`}&]
[s7; &]
[s7; -|void [* SubMenu](Bar`& bar) `{&]
[s7; -|-|bar.[* Add](`"Exit`", `[`=`] `{ [* Exit](); `});&]
[s7; -|`}&]
[s7; &]
[s7; -|void [* MainMenu](Bar`& bar) `{&]
[s7; -|-|bar.[* Sub](`"Menu`", `[`=`](Bar`& bar) `{ [* SubMenu](bar); `});&]
[s7; -|`}&]
[s7; &]
[s7; -|typedef MyAppWindow CLASSNAME;&]
[s7; &]
[s7; -|MyAppWindow() `{&]
[s7; -|-|Title(`"My application with menu`").Sizeable();&]
[s7; -|-|[* AddFrame](menu);&]
[s7; -|-|menu.[* Set](`[`=`](Bar`& bar) `{ [* MainMenu](bar); `});&]
[s7; -|`}&]
[s7; `};&]
[s7; &]
[s7; GUI`_APP`_MAIN&]
[s7; `{&]
[s7; -|MyAppWindow app;&]
[s7; -|app.Run();&]
[s7; `}&]
[s7; &]
[s5; &]
[s0;= 
@@rawimage:1434&1333
(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)
                 
@@rawimage:1434&1332
(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)
&]
[s5; Of course, with power of C`+`+11 lambdas, it is also possible, 
if not always advisable, to `'inline`' the whole menu structure 
to single MenuBar`::Set call:&]
[s7; &]
[s7; #include <CtrlLib/CtrlLib.h>&]
[s7; &]
[s7; using namespace Upp;&]
[s7; &]
[s7; struct MyAppWindow : TopWindow `{&]
[s7; -|MenuBar menu;&]
[s7; &]
[s7; -|MyAppWindow() `{&]
[s7; -|-|Title(`"My application with menu`").Sizeable();&]
[s7; -|-|AddFrame(menu);&]
[s7; -|-|menu.[* Set](`[`=`](Bar`& bar) `{&]
[s7; -|-|-|bar.Sub(`"Menu`", `[`=`](Bar`& bar) `{&]
[s7; -|-|-|-|bar.Add(`"Exit`", `[`=`] `{&]
[s7; -|-|-|-|-|if(PromptOKCancel(`"Exit MyApp?`"))&]
[s7; -|-|-|-|-|-|Break();&]
[s7; -|-|-|-|`});&]
[s7; -|-|-|`});&]
[s7; -|-|`});&]
[s7; -|`}&]
[s7; `};&]
[s7; &]
[s7; GUI`_APP`_MAIN&]
[s7; `{&]
[s7; -|MyAppWindow app;&]
[s7; -|app.Run();&]
[s7; `}&]
[s7; &]
[s5; &]
[s3;:8: 8. Context menu&]
[s5; Context local menu (usually invoked by right mouse click) is 
similar to the standard menu bar handling, just instead of adding 
MenuBar to your application, you [/ execute] the callback to the 
menu:&]
[s5; &]
[s7; #include <CtrlLib/CtrlLib.h>&]
[s7; &]
[s7; using namespace Upp;&]
[s7; &]
[s7; struct MyAppWindow : TopWindow `{&]
[s7; -|void Exit() `{&]
[s7; -|-|if(PromptOKCancel(`"Exit MyApp?`"))&]
[s7; -|-|-|Break();&]
[s7; -|`}&]
[s7; &]
[s7; -|void RightDown(Point, dword) `{&]
[s7; -|-|MenuBar`::Execute(&]
[s7; -|-|-|`[`=`](Bar`& bar) `{&]
[s7; -|-|-|-|bar.Add(`"Exit`", `[`=`] `{ Exit(); `});&]
[s7; -|-|-|`}&]
[s7; -|-|);&]
[s7; -|`}&]
[s7; &]
[s7; -|MyAppWindow() `{&]
[s7; -|-|Title(`"My application with local menu`").Sizeable();&]
[s7; -|`}&]
[s7; `};&]
[s7; &]
[s7; GUI`_APP`_MAIN&]
[s7; `{&]
[s7; -|MyAppWindow app;&]
[s7; -|app.Run();&]
[s7; `}&]
[s7; &]
[s7; &]
[s0;= 
@@rawimage:1710&1225
(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)
&]
[s5;= &]
[s3;:9: 9. Context menu alternative&]
[s5; It is also possible to create context menu by adding menu items 
directly to MenuBar. Example also demonstrates how to convert 
the menu item to same value, by using lambda capture by reference:&]
[s5; &]
[s7; #include <CtrlLib/CtrlLib.h>&]
[s7; &]
[s7; using namespace Upp;&]
[s7; &]
[s7; struct MyAppWindow : TopWindow `{&]
[s7; -|void Exit() `{&]
[s7; -|-|if(PromptOKCancel(`"Exit MyApp?`"))&]
[s7; -|-|-|Break();&]
[s7; -|`}&]
[s7; &]
[s7; -|void RightDown(Point, dword) `{&]
[s7; -|-|int [* result ]`= Null;&]
[s7; -|-|[* MenuBar menu];&]
[s7; -|-|for(int i `= 0; i < 10; i`+`+)&]
[s7; -|-|-|menu.Add(AsString(i), `[`=, [* `&result]`] `{ [* result ]`= i; 
`});&]
[s7; -|-|menu.Separator();&]
[s7; -|-|menu.Add(`"Exit`", `[`=`] `{ Exit(); `});&]
[s7; -|-|menu.[* Execute]();&]
[s7; -|-|if(!IsNull([* result]))&]
[s7; -|-|-|PromptOK(`"You have selected `" `+ AsString((int)result));&]
[s7; -|`}&]
[s7; &]
[s7; -|MyAppWindow() `{&]
[s7; -|-|Title(`"My application with context menu`").Sizeable();&]
[s7; -|`}&]
[s7; `};&]
[s7; &]
[s7; GUI`_APP`_MAIN&]
[s7; `{&]
[s7; -|MyAppWindow app;&]
[s7; -|app.Run();&]
[s7; `}&]
[s7; &]
[s7; &]
[s5; &]
[s0;= 
@@rawimage:1448&1660
(iVBORw0KGgoAAAANSUhEUgAAAfIAAAI7CAIAAACY/I5mAAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAAAJcEhZcwAADsMAAA7DAcdvqGQAAAASdEVYdFNvZnR3YXJlAEdyZWVuc2hvdF5VCAUAABR+SURBVHhe7d0xjyTlmcDxSU53IiIjAcnnyBfYCdLqxBcghtDRnANnDk6kJ13GICc2xA6OvWg1liDfD3AEq02Q9gvsSiAhFiKnd2/1U93TPdODh719nrf1zO+nR0NtTXV1V8P+u6gZdZ/929d/McYY02aWrP/Lk/80xhjTYGTdGGNajawbY0yrkXVjjGk1sm6MMa1G1o0xptXIujHGtBpZN8aYViPrxhjTamTdGGNObs7Ozv75v39/beWYsXJ869rKa/N3sv6rJ799c+zjw99eW//Lj94+O3v7rS8OVr7G2dzvsv9fffH+G690R698w5+eo7vdPdr9lcYY88oz8v0P//hP18p+dOXNuUvW337jNwfNWlufGbJXC2VlXvfvK+9+f9aeKw/fGJM91yJ+x6aPuVPW3/zw7Tc++sPVyk/fPfvw3dSCvFqhKru2f1959/uz9lx5+MaYgtml/O5NH3OnrL/1xfj67jvrmj+8tZy8x/qxfPbmp9uNR+5/8/4v927+zofLWf1icxln3dun77+xWRcvFT+18ourhc3K5e5C3On+/jdbbq1/3N5wuXKyihuu3/3o3Vi5/6I1Zuz2YLPdTq52e+y+Dg9hf24+8rs8pM2arXgCr241/nUs+1yfruWZf3u3w9g45tpjG/e1uYC22D3Ow90ef3LWleu/iKtlY0zqRNDv3vQxd8z6XulGApZ2r+s3Z+5rRHbbXJvdTjYLZ5H+TUp+euW1hauKXZubG99YuR/Tq5VrK8chbF+0YnYHNRbeGLnc3Omo4Vi4/b62h3Bzbzce+d0f0o172S6PB7Y+mLFZfD3YYDfrbq8e294rwc27uNrtXR+JMSZ1ErO+rfna7qv1y8L2r/1mg4Obbzqysdv4KgfXdnV05dXCkr/ljmKzmJ/Y/203vHmn+8sxewe7Oc9dlkeaD+7itj0c39vhI7/7QzpYudxqz1V2l5vv32os7+bobveXb+72+Ga37McYkzfR9PF1t3Btg6Nz56xH19bGHfzFjtPY+Hpw22281tteT8NyDnsjZ9dXXi3cHsdb9n/8hnfK+rrDeKEay+++M3ZyeOC37eHI3m5/5PHHn5P1g/0sK19P1g8f3tHNbtmPMSZprqX87mW/a9aX5U1B1v+F31+/JO/dNzdhjVvFLNtHCpdwLN/d3Gq7h21Nbl+5u0ksLMXff+W4Zf/rwzjcwzZ8N/a/v2XsNmZ5ldq7/PLmh8vVibF8uNsje7i5tyOPfNnmTg/pxsqb+xm3ja8HGx9uc323+8ubhZu7vbnZchTrY17+S1g3MMZkzNGI37HsPyfrcd56Y/2Ycb4Z1wT2J0Kw2EY/bvXmh+uP7PbPMY+u3N1k+wDG8mpsdnP/Y5vlkQy3/sh0f1dHlneze6m4vry38fH7Orq3ZeVqr+bhyA2P3svhrcaa93evFuOFJ17h9jeOuW23B8sHu731cOJ1fbNN7u9BGWPG37Oj+R4rx7eurbw2fyfrd5xRk6jVT89+I356pTHGmFeb15D15Vxvc6p4bf3NkXVjjMme/1fWt5dB7hplWTfGmOx5DWfrxhhjTmdk3RhjWo2sG2NMq5F1Y4xpNbJujDGtRtaNMabVyLoxxrQaWTfGmFazZv1HAFqQdYBWZB2gFVkHaEXWAVqRdYBWZB2gFVkHaEXWAVqRdYBWZB2gFVkHaEXWAVqRdYBWZB2gFVkHaEXWAVqRdYBWZB2gFVkHaEXWAVqRdYBWZB2gFVkHaEXWAVqRdYBWZB2gFVkHaEXWAVqRdYBWZB2gFVkHaEXWAVqRdYBWZB2gFVkHaEXWAVqRdYBWZB2gFVkHaEXWAVqRdYBWZB2gFVkHaEXWAVqRdYBWZB2gFVkHaEXWAVqRdYBWZB2gFVkHaEXWAVqRdYBWZB2gFVkHaEXWAVqRdYBWZB2gFVkHaEXWAVqRdYBWZB2gFVkHaEXWAVqRdYBWZB2gFVkHaEXWAVqRdYBWZB2gFVkHaEXWAVqRdYBWZB2gFVkHaEXWAVqRdYBWZB2gFVkHaEXWAVqRdYBWZB2gFVkHaEXWAVqRdYBWZB2gFVkHaEXWAVqR9Vz/xdb6jADJZD2XnAXPA5SR9VxyFjwPUEbWc8lZ8DxAGVnPJWfB8wBlZD2XnIXxPLx48eLbb7/97rvvXr58+cMPP6zfAF43Wc8l62E8D0+ePHn27Nnz589H2WUd8sh6LlkP43l49OjR48ePR9m/+eabccK+fgN43WQ9l6yH8Tx89tlno+zjnP3FixeyDnlkPdfkrF+en208uHi6rplkPA+ffPLJw4cPv/rqq+fPn3///ffrN4DXTdZzTc36iPr55bowOezjefj4448///xzWYdssp5rZtZ3Vf/xx6cXD+Z2XdahjKznmpj1g5TvJX4KWYcysp5L1oOsQxlZzyXrQdahjKznmph119bhfpL1XDOzPlq+dn0Efm7VZR3qyHqumVkfRs83pl6AWcg6lJH1XJOzfjJkHcrIei5ZD7IOZWQ9l6wHWYcysp5L1oOsQxlZzyXrQdahjKznkvUg61BG1nPJepB1KCPruWQ9yDqUkfVcsh5kHcrIei5ZD7IOZWQ9l6wHWYcysp5L1oOsQxlZzzU/68u7fU1/py9Zhzqynmtq1pd35j07P5/8CRobsg5lZD3X/LP16R+MtCHrUEbWc8l6kHUoI+u5ZD3IOpSR9VyyHmQdysh6LlkPsg5lZD2XrAdZhzKynkvWg6xDGVnPdQJZPwmyDmVkPZesB1mHMrKeS9aDrEMZWc8l60HWoYys55L1IOtQRtZzyXqQdSgj67lkPcg6lJH1XLIeZB3KyHouWQ+yDmVkPZesB1mHMrKeS9aDrEMZWc8l60HWoYys55qb9cvzs/Dg4um6ahJZhzKynmtm1p9eXKzv3DjyPjnssg5lZD3X3LP1racXD2Qd7gtZz3UaWZ//luuyDmVkPdcpZH3+JRhZh0Kynmt21p9ePJjf9EHWoYys55qa9fmX1HdkHcrIeq6ZWT+JDzFdyTqUkfVcE7O+XH/ZM/e8XdahjKznmnm2fkpkHcrIei5ZD7IOZWQ9l6wHWYcysp5L1oOsQxlZzyXrQdahjKznkvUg61BG1nPJepB1KCPruWQ9yDqUkfVcsh5kHcrIei5ZD7IOZWQ9l6wHWYcysp5L1oOsQxlZzzU161dv9jX9nRxlHcrIeq6pWb+8jJovefehd3BfyHquqVnf8VmmcI/Ieq6TyPoJfJ6GrEMZWc81N+vrxfUT+IwkWYcysp7rVM7WZ39OtaxDGVnPdRJZP4HLMLIOZWQ918ysb38RZlN1Z+twX8h6rplZ3/uM6ulX12Udysh6rplZPyWyDmVkPZesB1mHMrKeS9aDrEMZWc8l60HWoYys55L1IOtQRtZzyXqQdSgj67lkPcg6lJH1XLIeZB3KyHouWQ+yDmVkPZesB1mHMrKeS9aDrEMZWc8l60HWoYys5zqFrC9v+TX5DRxlHerIeq4TyPryIRqyDveHrOeanvVxqn5+cfFA1uHekPVck7O+RP1y+SrrcG/Ieq6pWd/mXNbhPpH1XBOzfhVzWYf7RNZzzcv65iel+6aWXdahjKznmni2fsXZOtwnsp5L1oOsQxlZz3USWT8Bsg5lZD2XrAdZhzKynkvWg6xDGVnPJetB1qGMrOeS9SDrUEbWc8l6kHUoI+u5ZD3IOpSR9VyyHmQdysh6LlkPsg5lZD2XrAdZhzKynkvWg6xDGVnPJetB1qGMrOeam/WnFw/Wd+U9O79c180h61BG1nPNzfrl+eycb8k6lJH1XLOzPvsNebdkHcrIeq6pWb+6BjO97rIOZWQ919yz9a3L89lhl3UoI+u5TiPr87su61BG1nOdTtbn/uxU1qGMrOc6iawv19hdhIH7QtZzTc36OEdfTf81R1mHMrKe6yTO1k+ArEMZWc8l60HWoYys55L1IOtQRtZzyXqQdSgj67lkPcg6lJH1XLIeZB3KyHquXdb//NXf7ufE4cs6lJH1XLIehy/rUEbWc8l6HL6sQxlZzyXrcfiyDmVkPZesx+HLOpSR9VyyHocv61BG1nNNz/rvP4g3+/rXD/56/Vs1E4cv61BG1nPNzfpo+i/+/etrK4snDl/WoYys55qa9S/f+/Uf/+P6yuqJw5d1KCPruWZm/U+/O/vgd+/FNZh5fY/Dl3UoI+u5Jmd9e0l94tWYOHxZhzKynmv22fqXR5ZrJw5f1qGMrOeS9Th8WYcysp5rZta/+vK99SLM1x/8+uy9P+1/q27i8GUdysh6rqlZ/9uf//rHX8SPTCedqo+Jw5d1KCPruSZn/QQmDl/WoYys55L1OHxZhzKynkvW4/BlHcrIei5Zj8OXdSgj67lkPQ5f1qGMrOeS9Th8WYcysp5rl/V7TtahjKznkvUg61BG1nPJepB1KCPruWQ9yDqUkfVcsh5kHcrIei5ZD7IOZWQ918SsP714EG/ztXV+uX5nAlmHMrKe60TO1kfiH1w8Xf8wg6xDGVnPdRpZvzyfeqo+yDqUkfVcJ5H1y/O5p+qDrEMZWc91AlmffgFmIetQRtZzzc/6qPrkCzALWYcysp5retZPo+qyDnVkPdfsrJ/EFZhB1qGMrOeanfX5vwMTZB3KyHqu2Vk/FbIOZWQ9l6wHWYcysp5L1oOsQxlZzyXrQdahjKznkvUg61BG1nPJepB1KCPruWQ9yDqUkfVcsh5kHcrIei5ZD7IOZWQ9l6wHWYcysp5L1oOsQxlZzyXrQdahjKznmpz1y/P4dGqfjgT3h6znmpr1EfXo+W5hGlmHMrKea2bW995rffr788o6lJH1XFPP1nddn/+u67IOZWQ919Ssb8K+ubY+/aM0ZB3KyHqumVl3EQbuJVnPNTHrBx9jOrvrsg5lZD3XzLP1vd9/2VucQ9ahjKznmpn1q0vr8y+uyzqUkfVcc7N+OmQdysh6LlkPsg5lZD2XrAdZhzKynkvWg6xDGVnPJetB1qGMrOeS9SDrUEbWc8l6kHUoI+u5ZD3IOpSR9VyyHmQdysh6LlkPsg5lZD2XrAdZhzKynkvWg6xDGVnPNTnrlz6iGu4dWc81M+vL+zfGOzdOf19eWYc6sp5rYtb3P0bj4CM1ZpB1KCPruWQ9yDqUkfVcE7O+ubAeF2GWyzGyDveErOeamfXI+eYnpufnztbhvpD1XHOzvjNO3Od+7J2sQxlZz3USWZ//izCyDnVkPdfUrG9/a336B1TLOhSS9VwncbZ+AmQdysh6LlkPsg5lZD2XrAdZhzKynkvWg6xDGVnPJetB1qGMrOeS9SDrUEbWc8l6kHUoI+u5ZD3IOpSR9VyyHmQdysh6ruKs/88pWR/ThqxDGVnPVZz1/z0l62PakHUoI+u5irN+smQdysh6LlkPsg5lZD2XrAdZhzKynkvWg6xDGVnPJetB1qGMrOeS9SDrUEbWc8l6kHUoI+u5ZD3IOpSR9VyyHmQdysh6rqlZ331E9eLIx1Q/vXhw9uDi6fqnVLIOZWQ91+ys37Had9/yFck6lJH1XLIeZB3KyHquU8r63jWX9Tvxj/F168iVmtdD1qGMrOeanfWdCPZYMxbia/wxOr9byCLrUEbWc53S2frGWHd1Ui7r0JCs55L1IOtQRtZznVjWxxoXYaA5Wc81O+tXHlxc7n5kuv3h6VXN1023p/GvnaxDGVnPNTXrJ0TWoYys55L1IOtQRtZzyXqQdSgj67lkPcg6lJH1XLIeZB3KyHouWQ+yDmVkPZesB1mHMrKeS9aDrEMZWc81ckaQdagh66VevHjx5MmTR48effbZZ5988sko3f0xDnkc+Dj88SS8fPlyfUaA103WS3377bfPnj17/PjxCNzDhw/H2ev9MQ55HPg4/G+++UbWIY+sl/ruu++eP38+0jZOWr+6Z8YhjwMfhz+ehB9++GF9RoDXTdZLjbPUEbVxuvrixYsRuHtlHPL4n5Vx+ONJkHXII+ulRs6G0bXh+3smjjqegfXpABLIOkArsg7QiqwDtCLrAK3IOkArsg7QiqwDtCLrAK3IOkArsg7QiqwDtCLrAK3IOkArsg7QiqwDtCLrAK3IOkArsg7QiqwDtCLrAK3IOkArsg7QiqwDtCLrAK3IOkArsg7QiqwDtCLrAK3IOkArsg7QiqwDtCLrAK3IOkArsg7QiqwDtCLrAK3IOkArsg7QiqwDtCLrAK3IOkArsg7QiqwDtCLrAK3IOkArsg7QiqwDtCLrAK3IOkArsg7QiqwDtCLrAK3IOkArsg7QiqwDtCLrAK3IOkArsg7QiqwDtCLrAK3IOkArsg7QiqwDtCLrAK3IOkArsg7QiqwDtCLrAK3IOkArsg7QiqwDtCLrAK3IOkArsg7QiqwDtCLrAK3IOkArsg7QiqwDtCLrAK3IOkArsg7QiqwDtCLrAK3IOkArsg7QiqwDtCLrAK3IOkArsg7QiqwDtCLrAK3IOkArsg7QiqwDtCLrAK3IOkArsg7QiqwDtCLrAK3IOkArsg7QiqwDtCLrAK3IOkArsg7QiqwDtCLrAK3IOkArsg7QiqwDtCLrAK3IOkArsg7QiqwDtCLrAK3IOkArsg7QiqwDtCLrAK3IOkArsg7QiqwDtCLrAK3IOkArsg7QiqwDtCLrAK3IOkArsg7QiqwDtCLrAK3IOkArsg7QiqwDtCLrAK3IOkArsg7QiqwDtCLrAK3IOkArsg7QiqwDtCLrAK3IOkArsg7QiqwDtCLrAK3IOkArsg7QiqwDtCLrAK3IOkArsg7QiqwDtCLrAK3IOkArsg7QiqwDtCLrAK3IOkArsg7QiqwDtCLrAK3IOkArsg7QiqwDtCLrAK3IOkArsg7QiqwDtCLrAK3IOkArsg7QiqwDtCLrAK3IOkArsg7QiqwDtCLrAK3IOkArsg7QiqwDtCLrAK3IOkArsg7QiqwDtCLrAK3IOkArsg7QiqwDtCLrAK3IOkArsg7QiqwDtCLrAK3IOkArsg7QiqwDtCLrAK2sWTfGGNNkvv7L/wGcVgKZuITFggAAAABJRU5ErkJggg==)
         
@@rawimage:1448&1661
(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)
&]
[s5; &]
[s3;:10: 10. Adding images&]
[s5; To add some eye`-candy to the menu, you can add small raster 
images. In U`+`+, images are represented by Image values. You 
can use image designer, part of TheIDE, to design Image constants&]
[s5; &]
[s0;= 
@@rawimage:3100&1890
(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)
&]
[s5; &]
[s5; To get the image constants into your application you have to 
use somewhat obfuscated but thankfully short sequence of preprocessor 
commands:&]
[s5; &]
[s7; #include <CtrlLib/CtrlLib.h>&]
[s7; &]
[s7; using namespace Upp;&]
[s7; &]
[s7; [* #define IMAGECLASS TutorialImg]&]
[s7; [* #define IMAGEFILE <Gui10/images.iml>]&]
[s7; [* #include <Draw/iml.h>]&]
[s7; &]
[s7; struct MyAppWindow : TopWindow `{&]
[s7; -|MenuBar menu;&]
[s7; &]
[s7; -|void Exit() `{&]
[s7; -|-|if(PromptOKCancel(`"Exit MyApp?`"))&]
[s7; -|-|-|Break();&]
[s7; -|`}&]
[s7; &]
[s7; -|void SubMenu(Bar`& bar) `{&]
[s7; -|-|bar.Add(`"Exit`", [* TutorialImg`::Exit()], `[`=`] `{ Exit(); 
`});&]
[s7; -|`}&]
[s7; &]
[s7; -|MyAppWindow() `{&]
[s7; -|-|Title(`"My application with menu and images`").Sizeable();&]
[s7; -|-|AddFrame(menu);&]
[s7; -|-|menu.Set(`[`=`](Bar`& bar) `{&]
[s7; -|-|-|bar.Sub(`"Menu`", `[`=`](Bar`& bar) `{ SubMenu(bar); `});&]
[s7; -|-|`});&]
[s7; -|`}&]
[s7; `};&]
[s7; &]
[s7; GUI`_APP`_MAIN&]
[s7; `{&]
[s7; -|MyAppWindow app;&]
[s7; -|app.Run();&]
[s7; `}&]
[s7; &]
[s5; &]
[s5; Here [*/ Tutorial ]is the name of package where .iml file resides.&]
[s5; Image constants are represented by class methods of class defined 
as [* IMAGECLASS] ([/ TutorialImg] in this case). Image constant 
then can be added to menu as another parameter of Bar`::Add.&]
[s5; Note: [* #include <Draw/iml.h>] works only when images are to be 
used in single .cpp file, otherwise you must put `"obsuscated`" 
sequence with [* #include <Draw/iml`_header.h>] to you header and 
[* #include <Draw/iml`_source.h>] to any .cpp file.&]
[s5; &]
[s0;= 
@@rawimage:1605&720
(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)
&]
[s5; &]
[s3;:11: 11. Toolbar&]
[s5; Toolbars are in fact quite similar to menus `- they provide 
set of operations with names and Images that can be invoked by 
user. In U`+`+ you can take advantage of this similarity as toolbars 
can share the definition with menus `- if [* Bar`::Add] command 
contains the Image, it also adds toolbar button with that Image 
when used with [* ToolBar]. The text of menu item then translates 
to button tip. If you want one particular Bar item to be used 
with menu or toolbar only, you can do that by using [* AddMenu] 
or [* AddTool] instead of simple Add. Also, items without Image 
are automatically added to menus only and vice versa, items without 
text are added to toolbars only.&]
[s5; &]
[s7; #include <CtrlLib/CtrlLib.h>&]
[s7; &]
[s7; using namespace Upp;&]
[s7; &]
[s7; #define IMAGECLASS TutorialImg&]
[s7; #define IMAGEFILE <[/ Tutorial]/images.iml>&]
[s7; #include <Draw/iml.h>&]
[s7; &]
[s7; struct MyAppWindow : TopWindow `{&]
[s7; -|MenuBar menu;&]
[s7; [* -|ToolBar tool;]&]
[s7; &]
[s7; -|void MenuFn() `{&]
[s7; -|-|PromptOK(`"Fn activated!`");&]
[s7; -|`}&]
[s7; &]
[s7; -|void BarFn() `{&]
[s7; -|-|PromptOK(`"Fn2 activated!`");&]
[s7; -|`}&]
[s7; -|&]
[s7; -|void Exit() `{&]
[s7; -|-|if(PromptOKCancel(`"Exit MyApp?`"))&]
[s7; -|-|-|Break();&]
[s7; -|`}&]
[s7; &]
[s7; -|void SubBar(Bar`& bar) `{&]
[s7; -|-|bar.AddMenu(`"Function`", TutorialImg`::Fn(), THISBACK(MenuFn));&]
[s7; [* -|-|bar.Add(TutorialImg`::Fn2(), THISBACK(BarFn));]&]
[s7; [* -|-|bar.Add(`"Exit`", TutorialImg`::Exit(), THISBACK(Exit));]&]
[s7; -|`}&]
[s7; &]
[s7; -|void MainMenu(Bar`& bar) `{&]
[s7; -|-|bar.Add(`"Menu`", THISBACK(SubBar));&]
[s7; -|`}&]
[s7; &]
[s7; -|typedef MyAppWindow CLASSNAME;&]
[s7; &]
[s7; -|MyAppWindow() `{&]
[s7; -|-|Title(`"My application with bars`").Sizeable();&]
[s7; -|-|AddFrame(menu);&]
[s7; [* -|-|AddFrame(tool);]&]
[s7; -|-|menu.Set(THISBACK(MainMenu));&]
[s7; [* -|-|tool.Set(THISBACK(SubBar));]&]
[s7; -|`}&]
[s7; `};&]
[s7; &]
[s7; GUI`_APP`_MAIN&]
[s7; `{&]
[s7; -|MyAppWindow app;&]
[s7; -|app.Run();&]
[s7; `}&]
[s5; &]
[s0;= 
@@rawimage:1669&879
(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)
&]
[s5; &]
[s3;:12: 12. StatusBar and decorative Frames&]
[s5; To improve the visual aspect of the application, we will add 
some decorative Frames `- those are frames that do not represent 
any action, just draw some kind of border at given frame level. 
We will also add the [* StatusBar] and connect it to the menu and 
toolbar `- this way it will start displaying descriptions placed 
to Bar items using a Help method. Note that decorative frame 
functions ([* TopSeparatorFrame] and [* InsetFrame] here) usually 
return a reference to single global object, as there are no changing 
properties required when using them with different windows and 
widgets concurrently.&]
[s5; &]
[s7; #include <CtrlLib/CtrlLib.h>&]
[s7; &]
[s7; using namespace Upp;&]
[s7; &]
[s7; #define IMAGECLASS TutorialImg&]
[s7; #define IMAGEFILE <[/ Tutorial]/images.iml>&]
[s7; #include <Draw/iml.h>&]
[s7; &]
[s7; struct MyAppWindow : TopWindow `{&]
[s7; -|MenuBar   menu;&]
[s7; -|ToolBar   tool;&]
[s7; -|StatusBar status;&]
[s7; &]
[s7; -|void MenuFn() `{&]
[s7; -|-|PromptOK(`"Fn activated!`");&]
[s7; -|`}&]
[s7; &]
[s7; -|void BarFn() `{&]
[s7; -|-|PromptOK(`"Fn2 activated!`");&]
[s7; -|`}&]
[s7; -|&]
[s7; -|void Exit() `{&]
[s7; -|-|if(PromptOKCancel(`"Exit MyApp?`"))&]
[s7; -|-|-|Break();&]
[s7; -|`}&]
[s7; &]
[s7; -|void SubBar(Bar`& bar) `{&]
[s7; -|-|bar.AddMenu(`"Function`", TutorialImg`::Fn(), THISBACK(MenuFn))&]
[s7; [* -|-|   .Help(`"This invokes MenuFn method of tutorial example`");]&]
[s7; -|-|bar.Add(TutorialImg`::Fn2(), THISBACK(BarFn))&]
[s7; [* -|-|   .Help(`"This invokes BarFn method of tutorial example`");]&]
[s7; -|-|bar.Add(`"Exit`", TutorialImg`::Exit(), THISBACK(Exit));&]
[s7; -|`}&]
[s7; &]
[s7; -|void MainMenu(Bar`& bar) `{&]
[s7; -|-|bar.Add(`"Menu`", THISBACK(SubBar));&]
[s7; -|`}&]
[s7; &]
[s7; -|typedef MyAppWindow CLASSNAME;&]
[s7; &]
[s7; -|MyAppWindow() `{&]
[s7; -|-|Title(`"My application with bars`").Sizeable();&]
[s7; -|-|AddFrame(menu);&]
[s7; [* -|-|AddFrame(TopSeparatorFrame());]&]
[s7; -|-|AddFrame(tool);&]
[s7; [* -|-|AddFrame(status);]&]
[s7; [* -|-|AddFrame(InsetFrame());]&]
[s7; -|-|menu.Set(THISBACK(MainMenu));&]
[s7; [* -|-|menu.WhenHelp `= status;]&]
[s7; -|-|tool.Set(THISBACK(SubBar));&]
[s7; [* -|-|tool.WhenHelp `= status;]&]
[s7; -|`}&]
[s7; `};&]
[s7; &]
[s7; GUI`_APP`_MAIN&]
[s7; `{&]
[s7; -|MyAppWindow app;&]
[s7; -|app.Run();&]
[s7; `}&]
[s5; &]
[s0;= 
@@rawimage:1837&876
(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)
&]
[s5; &]
[s3;:13: 13. Adding child Ctrls `- widgets, reacting to widget events&]
[s5; If you need to use some predefined child Ctrl (widget), place 
as variable somewhere, usually as member variable of your window 
or dialog class and use [* Add] (or [* operator <<]) to put it to 
your window.&]
[s7; &]
[s7; #include <CtrlLib/CtrlLib.h>&]
[s7; &]
[s7; using namespace Upp;&]
[s7; &]
[s7; struct MyAppWindow : TopWindow `{&]
[s7; -|[* Button button;]&]
[s7; -|&]
[s7; -|void Click() `{ PromptOK(`"You have clicked the button!`"); 
`}&]
[s7; &]
[s7; -|typedef MyAppWindow CLASSNAME;&]
[s7; &]
[s7; -|MyAppWindow() `{&]
[s7; -|-|Title(`"My application with button`");&]
[s7; -|-|[* Add(button.LeftPos(10, 100).TopPos(10, 30));]&]
[s7; -|-|button.SetLabel(`"Click me!`");&]
[s7; -|-|[* button <<`= THISBACK(Click);]&]
[s7; -|`}&]
[s7; `};&]
[s7; &]
[s7; GUI`_APP`_MAIN&]
[s7; `{&]
[s7; -|MyAppWindow app;&]
[s7; -|app.Run();&]
[s7; `}&]
[s7; &]
[s5; Position within parent view is given in logical coordinates 
(e.g. [* LeftPos] or [* TopPos]) that allow no`-nonsense resizing 
of dialog. Widget events (like `"button pushed`") are reflected 
by its callbacks. There exists a `"default`" [* WhenAction] callback 
in each widget that is usually invoked for `"user changed a value 
or a state of widget`" situation. You can assign this callback 
either as&]
[s7; &]
[s7; widget.[* WhenAction] `= ....&]
[s7; &]
[s5; or use equivalent operator version to save some typing&]
[s7; &]
[s7; widget [* <<`=] ....&]
[s7; &]
[s5; Note also that to make the code more clear and less verbose, 
U`+`+ uses `"method chaining`" technique, where methods (usually 
those that affect appearance, position or behaviour of widgets 
`- `"modifiers`" in U`+`+ lingo) are designed to return a reference 
to `*this `- that should explain the line&]
[s5; &]
[s7; Add(button.LeftPos(10, 100).TopPos(10, 30));&]
[s5; &]
[s0;= 
@@rawimage:1724&1324
(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)
&]
[s5; &]
[s3;:14: 14. More about logical coordinates&]
[s5; Logical coordinates can align one or both sides of widget to 
the side of parent view at specified distance(s) in both vertical 
and horizontal direction. If only one side is aligned, logical 
coordinate specifies the size. There is also specific kind of 
logical coordinate the specifies the center position.&]
[s5; &]
[s7; #include <CtrlLib/CtrlLib.h>&]
[s7; &]
[s7; using namespace Upp;&]
[s7; &]
[s7; struct MyAppWindow : TopWindow `{&]
[s7; -|Button lt, rt, lb, rb, lv, ht, hv, cb, rc;&]
[s7; &]
[s7; -|typedef MyAppWindow CLASSNAME;&]
[s7; &]
[s7; -|MyAppWindow() `{&]
[s7; -|-|Title(`"My application with button`").Sizeable();&]
[s7; -|-|`*this&]
[s7; [* -|-|-|<< lt.SetLabel(`"left`-top`").LeftPos(10, 100).TopPos(10, 
20)]&]
[s7; [* -|-|-|<< rt.SetLabel(`"right`-top`").RightPos(10, 100).TopPos(10, 
20)]&]
[s7; [* -|-|-|<< lb.SetLabel(`"left`-bottom`").LeftPos(10, 100).BottomPos(10, 
20)]&]
[s7; [* -|-|-|<< rb.SetLabel(`"right`-bottom`").RightPos(10, 100).BottomPos(10, 
20)]&]
[s7; [* -|-|-|<< lv.SetLabel(`"left`-vsize`").LeftPos(10, 100).VSizePos(40, 
40)]&]
[s7; [* -|-|-|<< ht.SetLabel(`"hsize`-pos`").HSizePos(120, 120).TopPos(10, 
20)]&]
[s7; [* -|-|-|<< hv.SetLabel(`"hsize`-vsize`").HSizePos(120, 120).VSizePos(40, 
40)]&]
[s7; [* -|-|-|<< cb.SetLabel(`"hcenter`-bottom`").HCenterPos(90).BottomPos(10, 
20)]&]
[s7; [* -|-|-|<< rc.SetLabel(`"right`-vcenter`").RightPos(10, 100).VCenterPos(40)]&]
[s7; -|-|;&]
[s7; -|`}&]
[s7; `};&]
[s7; &]
[s7; GUI`_APP`_MAIN&]
[s7; `{&]
[s7; -|MyAppWindow app;&]
[s7; -|app.Run();&]
[s7; `}&]
[s7; &]
[s5; &]
[s0;= 
@@rawimage:2000&923
(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)
&]
[s0;= &]
[s0;= 
@@rawimage:1495&1546
(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)
&]
[s5; &]
[s3;:15: 15. Font`-zoomed logical coordinates&]
[s5; All distances in U`+`+ widgets are always in pixels. However, 
to respond to platform setting of GUI font, there are `"font`-zoomed`" 
logical coordinates. Such coordinates scale distances by the 
ratio of current standard GUI font size to design font size (which 
is fixed to the default Windows font):&]
[s5; &]
[s7; #include <CtrlLib/CtrlLib.h>&]
[s7; &]
[s7; using namespace Upp;&]
[s7; &]
[s7; struct MyAppWindow : TopWindow `{&]
[s7; -|Button button;&]
[s7; &]
[s7; -|typedef MyAppWindow CLASSNAME;&]
[s7; &]
[s7; -|MyAppWindow() `{&]
[s7; -|-|Title(`"My application with font`-zoomed button`").Sizeable();&]
[s7; -|-|`*this << button.SetLabel(`"Button`").[* LeftPos][*@6 Z](10, 64).[* TopPos][*@6 Z](10,
 24);&]
[s7; -|`}&]
[s7; `};&]
[s7; &]
[s7; GUI`_APP`_MAIN&]
[s7; `{&]
[s7; -|MyAppWindow app;&]
[s7; -|app.Run();&]
[s7; `}&]
[s5; &]
[s0;= 
@@image:1640&509
(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)
       
@@image:1749&524
(A14BaQAAAJf/AAAAAHic7Z0JWBRHvsAbEEazX/LcmLgm8QiexCMRNGpUvFBQEAUBFVHEAyWeEY/cm83m5fli4vdiNNFo1sR1N+8RMVmzvs2Lmt1N3By7YlS80AXlmJtDARFBzLx/zX+mpunuaWaGEVjmP9/vm6+rqru6qrrr11U9Mz0WS6OXEHPSb/ppQIi6yIjOsxFXKCQUCfO0QqoB3/0WmYVUkzDPIMw3sYX5duaWEk1RQTgl2UioIT2RGp9a8YiOvccYrAs66wIErTExJUKklgELLGhg8ZFmYXyuxckLhRC0/IYm806XFywP/5rR53XLgK2W0LcsoTsso7cxwt9ljN/pFFyBUEGl9YhWPzptH3mLYcfk785gHbkx0MEB6O9BqxpADkLod3It+C8wgRb8V1VqNvwEa3I5BL/BAD8MetsBiAIRRxIEcbeBnoiIg9jB8TqOHZYDkeIgdmoO9nRAs/YOIMytFsY4Bg/CxH8IccVCwmW/9FJAWF6OgCUC1tQErK0HVwjr7wRkWgBchnceiQsYGbTuJxhy4JoE4QF+q34iVMAmwq6H/Q7xW1Hvn14XkHEjIL3SL61GWFglzLO+p1RB0BaTVmFjfhl7h5gks20aAjFAYokQcVYIz3eYIeakMO+qg1SDsNiElgA/IMwSTmCpUCROeiVBEC3EkjLGolK/RWYY+QPs7t9cPSNJZwO6PJJQxIgrBPxi84XofHYXkd9UBC2MPCF0O8C0EPY1SwUzJFy2IZID94ONp6sc8Mjl5WwdsY6IJjARhOdAx5eAEpB1fHvftxuAgyoADwDjc4XwHBugBRAC8OBHtoWJ/2CfRzgxA0diAxYDK+CHFKmiMqOvCILwOvzqLxoMBM4qXvaOUVd229nnCyqvZZuvBo6xOiH0O6aCgV8I/bOZGfp+rGQGraIZuA1EQjBYP8c0NHICH8MQivCDS8jBqx7RJLy54pgW6ovyS99cb3oxzbAuSb8iVrdsqnbRJO2SydqF45CS+WOA4tnDGAlDC2ND8qf0Op0w/FpeLsiBaQHN0PtL5oT7XoY5BQuG5/hPkZqB9X00APfDIrMjMrXxwEbuNILwgFbvcW0fNlkoRidYKYRLf9nWTdf2v3394x0Vu18v3brRvHmN+dUM0yvLTC8tNj6/0EqqcWOyIXO2fk2cLmOaNm18YVLY6cg+f4oZqjPX28YMg3+Qm4HNO8QDhlQTegDB+xt4i8MxfVCcQbT6Fbnt0+q9ry3T6v2ujWOzgRhmBtMr6dezdlZm7674zRtl214ofTPT/Ppq06sZxl+mgxwYLy4yPrvAuCFZv3aWbsV07ZKIouSRudEhnwx7kN1vBDMAYIZHfyAzkBnaIq3e9do4Tsxg3DAXnHBt39byd18p3bLO/NoK08tLjc+lGtYnG9YmAvrV8bqMGF1GNJtipI0vmT+6cPbw3OkDs0d0c2oGGEWMz7V9BRoODf/Cs0gOYAbxxyLskxHF2URLda5dR27kG263fh9vVdxthMSt5eXVDXAaHDlT2+qFbyOotGEbPcfidY20EFsCwDE1rJ1Vtu35su0vgRZqc75hMZnJhtUJuoxY7dJIxsKJJSmjIb766KfFSWHFSaFXE4aenTH44OgezAwjchlohv7ZzAwPH2OuGJPLPtcAI8GurWbAvp9vug2gFhAWY7zt8EMrmQFvq3bs9TYGT+TXAV7fy13K1lsFkDSCOhGvlvLb0R/8NkcT8kEr1kuN+BbF0YbuJLUJrE7gZtCviC3dvKZ0yzMwWuAH2qqFKO3CCQBqAV/F8YOLZw25Ouvxs7FKZsAxg6oZMJ+QcXtRC303ltua69G324IZ7un2Gu9BObkmTd/3mpPn5s+qJNcIr2TbHCQFkJRQ0gjqwDgBVl65/jCsDwQO/cSLDeVNWsMMrA3dSVJn80Fr+6jGeN0MuvRI06sZbBLxy3Tjs6lcAtpFEdoF4YBDCzNDimcMKI4bWBg/+GzswINPdXdqBoiZYP0uRKL1Q9JkI84mhv3K5gE4nTrMKQAzLP+wCmNGT9njGDY4fgXWcnKQdwroPs3swoqX4OZn20zEBZCU0C0z8JUDxn7llcZ3cazSxlFpQ7eaV719vNlizs1gfCHN+NJi9r4hxbAmkaugZL5jtFACWojtWxzTuzi2X2HcY+emP/bpU48wM4zKYx547HSj2QQ3Q7x118wM7GvVm7JqMLev/loQNPl44JKKo+fqMObF144FzLiYc6UelvtmVjCTJBuD15gheKJAefQLzsRtYaoLMzhJo+EVDdaBubDrSXjUeK15aueFetgFzqlhQxhIu1gMcT7ybMM2mbAwrJr5deJsISbr2xqeKs5ZDGyFa/Jy4vqwgDGQhJnLC+CshDA1UN+pZFu+uWfVkefT5O5cb8YmSwUlgRELpkIJYWVsMXGrIrAhtrbkzMEkPA34yaBiBjj55ZlIauTKYXK9EVQav5EfuBlimBlKFow1bkhmnz5sWmDITNavTdCtnCE5BNqkwdr4AdqZfUqmP1oS27toZr/z0f0+G/mQBc3wZJ6yGeKK2RUfBwxWM2T9/RbPs+OgvWAGHsw+dD4o/Mjsdyph+a13/uaXcEWYW7r5UDUEU5Ye0PTdyX6p0Zisb2vFhdx9oADj5afQ8PQzLiZZD6hjNQwGrywrr74j3mrP73L9J//oejEUsw3bVC4vz+SNl50VlecsJn1XJaZ2HZUlDsKoDNq/80IzD0IbOiuPYozKTuVrwuYeV0dejCZ3Z7Hqy5VmdLdUktexb/XO8pmSeV5lF4oVka/GM5FsJQ7Ks5XHeOFc4iOHGAOOGUqSRxpWxxsz5xjXJxvWzdGvmcW+77Q8imeiSxmumzNYl9BfF9dbF9tTF9ureEbwhWnBnz3Z1cLNgMOGgV8wM4AiIDJSax0wmG2/ukqrCEirzDexay46Mzppf9R/3eTBgqvlmic+hnXKq+orrt0MGvlH2Ar6Y3llHRuvTvpB8YklQYN/h5NcyAG2CgzNhkgs9kP9t0A8DEUsVu34RV9wJYm1szVncTDrO9b3P9h/CjfEmTXuS6UY4kwUsz1yhl2A8AwHoCQQPHla5x/1I18TWgmSwI0YFO+Ug0lQHVDBkTM290KrBoz966b91XyPEFQ5A8WnHMzsGu10aLZKb8VtAdy1QnWsClWujj1nxWLgi+8OU3FbyNZ6Z4Ntrr5fV0qFBxTKJq4+D2pCfsP9j+WHFcSZYBJmAmeIpIWdtRiefpKSKJpB3j7ymOY0vt0MpWIsTsxgafxSM0N4vjD6km3YAGOGLm82MoNdC8JC9stNzG3giO0W68Bgy0EzD8KrY/A2MMN/HmbtPG/5Z4nb2Ppv7vi+U/c3FJ/Vs+toraScuKajVRP0GGSqGfx7V5OsmYuDfDkw9CBuGDDueJPFkOepmC2cZizbuRVhz13HGE2/XeI1/aPOKGbFyfqOnRWg1g6jj8JCztlSOCVYPiF7841MxXCeKNZLJegXnae+U2fbelYdxaB878Grr0FMeWU9RGK2Lu63yVLhAVWpvkXppZ6Jiy0mycSVw+TdxmckVTqwm6E4MUz3dIzhmUTDutnGZ5IMa2fxiusXj8WFOzVVhqT+hlnB+hnd9bHdS6Z3vxDZ/Q/D7ockYUyxMKaQmaHPBTZmADP0ymW6ADMk2c1g1cLwX7EeBCcwFCnnSj0sFGhrTl68DsECYz3WK2DRzS4r2UACTuZP/sKqABIOHPEnIaVKQtb39fIjxSqbUiVe5kHWW91PUszQxWIobijPFmrNfr+WUhXxHzearIViGfiG2YcvWayTr+TVX2IbYjxcLIKG/LdiPm4FJSiu7Fl15DviQxFxJM7p4FKCh8z1/bLU6HxhbnXEv9c4UudWi5fVg/Kj7GImYprM35WSqKzgWTUbYfcDrFA0c5B2yWT9yhngBMPaBF5rw/IIQ3o4wGOMicHGuEcMsd200d0uTur6eei/WdijGIzChCImh8fzmRkefIeZAYLMDGbUAjPD0rpns9nNGRjwdOz9zvL9ths1K57/qmPI7t3fsEsbuwmZVOSfXnf0rO225LHvDUzgKeX4pAgxvHZ8GI9BcRIsP5vFssLBp+tJkuCJKw1YckyCDV0phjxPZ9n6x1/hQVfKI6e8yn4X9PotdvGK+LG80hYDgyJ2sZh6gT12Y57ohHE/KEGSeqLA3krTr/AgVqeZOxLnD4NJ1ggwHG0c72y/3ioVbogD8kbWEu0CljsvVauLOGnTx+z0sw3n7EnQtWE5fc+tJtvHi43fCLsfYIXCmH4lqeG65VP1qxw3Hg1PRxkyJhnSxwLGxSN4vCnuIeP0rtqoLnnjOx8aco8FzQDAyIGbAQYPzAzWmQtqAc7epXWfnGClhSta0KjDfX9pO2/B/5roE3M/sA16gyZ9HZBRn7TTdiFm9x4H7RPS6uTkmxrdEnQ0bFqdPJ7l03+3elJ59U88B74ma720uog3pAOD3Yd0TRaD58layV5scbZhryiUB7YVFxXXlAclbD5sa084Nzp13wIxu/7cgDEwa8MYxXwkJXRrp5LU5lRH3lASeHXEL1f225xSiYOJO6TnAC+b/PRw1miKJQl6IguSjpxTqKBK+0himnUuzRdh9wOscHVKz+K5I7SLJ+mWT6s5/gXE6J+eqs+YYlg+0bB0DGBc/KQ5dQjE1x79vXnmL0zRP9dPvvfimJ8dGhTEChZ1jUkA5RD2tcMMMQY2lbBqAeYIMBLIN7NOBLMDzcyzQasaCky3cWahWVL2i+dYs7CbkMMP+K/4CbDYL3YB0efAKnJ6P1d3MteIq8HJjyNn6Ob+iUVYccgN3/HWUIfoM7CVShJkCFmxK3hiEV+TXZ6su5vycjFO3i1WFcO1I3DE5+rFgFRUHFYE85FkO3yjXpwt3vtSLIAkKG8NXAFMywvmiBnzJV9Tko+khG7tVJ7qcXXkDaW4L8nLlWYEhq03ylP94rVCWoOojzQ0GXzuAwOeOZJ4YPKLWkzC2+mSVI7Fqm6oJj+LeEmCN9zOOVeKjcA/NeaZJO5o4O3jLMbjatpt0yAWBaxwZUK3ovjHS+aPZnJIj9Qtm6JPj9CnT9QvDTcsHgUY08JM8weak/uaE3uYZzxomnqfbkKniyMC/zDA34JmAMAMo8zs+0622UQxe7L0XNuNR+vT5OoDVt6GeQRTwdM3gtaxBzx26rMdYE+AzLwTtKIGkiAYsMYyfAszA0wuOvXYgqJQJGBhuSaEVR9WCwo/pgk7wLr5jHO84h17b8f3DtNyuHCcJWGGLKtRhzGIw0VHamI+7o5VIWQPBNWLgamwgEk8H2m2ybpG2SbrnK0pCcpbA1eABWcxivlISujWTuWpHldH3lCK+5Lgyn6F9Dt+SVrNAHvqgD0QhEjENilwLdhh4vGOwdsdUwl7POAfl49JmsG/laeKMwwc8UeoJpYEtuJJfillWEhIhXUkmcAlEpNUYjyupgORxArGPgATiqLE0JKUp7Sp4dqF4drUMbrUp3SpI/ULwgBDymDjnH6mxF4wlYABg3Hyz7ThgReG+X/W34+ZYXq1bdgAZgj9jpnh4VPcDHzAgGYIWluvWXsHtQA2wKfCcjAeO295dQOMLoIi/waiAFT8IId3f7eSCMKXkfgBukneyPv+GdG9YHrIlVlPXE0aVjhneGFSaOHs0KLZjxcnDQS0Cf20cb100x/STe2ii7hXO05TOMr/zBPCJ30EmxlQDmAGnE00NgPKgZkhox4mEfisaaYFmRlQDhbrDQd2/7nnloCMm2gGt+Dd362kf2la/bwi2gFiOejK75ycFpIzqkvOuEdOTQ4+FdXvVFT/U5F9T0f1ORMZnDulJ3B+yiPnJ3W9MKHL+fD7LjzV6fyTHc4M9ftmoHBgbC9mhvgbjczQ5U2xGfAB1DhswJFD0Io6qR8ybaMIJCCT9VzNkwc6LK7w+LRXGQOrD48JwjeRTCuWvV9TceH0/04O+XjQvdlDf34g9P6ssAeyht6fHdblYFiXT0M7A4eG3vv54/ccHtLx0MCgQyEBhwf4fdpXyB7by3zu1LLtlU7MUMjNgO8BaZUMNni4YfMDsqoBgbmGHCwzjjcIFRSntAThBo3uRtYFptYu26n8LQ71l66sAbQQOLOq0X0GiRlirU/UsT2ayfFlSMdj7cX/KJFR77dCChQYby87+zCLEN1YJpzR6kenbTPfev7Ae/It21ca5twU5tYyYCHpBrv64zsucOKvC9OvsXdM5TcWJEjMwORQyJ75FnHKb/Jp/ykM/nR6fHA9+9JaXCETCH+ejPzZU6JfhhKEJ0QWEmpAP41x0koR+eynkUC4nXGXbcEJdjAG3kdfYozKs/1cAn9RBR5QNEPEKWYGqxy4HxTBFRh8fdGGhDrYzoQifkRT3MX2x29H42cTD53SDL/cdUVFx6SCMlMeQRA+izC1UhhzWQjOErq8RWYgCAKRmKETmYEgCDRDeL7Q4yMyA0EQHDIDQRByJGboGHqJzEAQBJmBIAg5EjNoQvPIDARB2MzQk8xAEIQDMgNBEHLIDARByJGYoSOZgSAINMO4fKHHPjIDQRCcZprh4rnjZ05+lfPD/7V7oJpQ2VY/XgTRMkjM4NZ9BugpQOra10fHZ3YbvqgdE564aenGrQbdpdqb11v9kBFEC2C9z1Ag9PTEDHAZBS0Ax/9+pkhr9OABU/8Sr2Kd6dsT58AMwO362lY/ZATRAkjM4NZsAsbYMFoALbR2322J17Z3d8DIARZa/ZARRAsg+3a0e2aAkTaMFu74wGvv3vegsmQGwkdozu8m0AzQWRoabrd7sv/nfTID4TvIvs/giRlu19e3e8gMhE8h/Q5kmCdmqKu71e4hMxA+hf0OZLPMcOtWbbuHzED4FF4xQ+3NmnYPmYHwKSRm8OCzCegsNTXV7R4yA+FTNOcXVdwMN6qr3EVo/HJxE5Xg3YbMQPgUXrkDWV113V2gX6sEvbWJFyEzED6FV8xQVXnNXaBfKwYl8TxGUH3xNcVBxW09KCpCZiB8Cq/MJq5fK3cX6KSKQUm8SpJKULyJ+lauQ2YgfArbby09/d0EdpZrFaXuIrnoi+PlayomubKVSm7uQmYgfAqZGTyZTVSUmd0FeqhiUBKvkiQOOttKJTd3ITMQPoVXzFBWanQX6KGKMc7i5UnioAe5uQuZgfApvGKGUrPBXaCHKsY4i5cniYMe5OYuZAbCp/CKGcxGnbtAD1UMyuNVkpwFnW2iGOMiZAbCp/CKGYyGEneR3IF0loRBeZIrQcm2zmJchMxA+BReMYNBV9zuITMQPoVXzKDXFrqL4OTlQVYtA5mB8Cm8YgZdydV2D5mB8Cm8YobCgovtHjID4VN4xQz/zDvV7iEzED5F881QrDOdz/2+3fPhh7vIDITv0EwzhCdu+vbEudMn/9Lu2b5z54Q5L5IZCB+hOWY4c/Ir/Oembe/u2Lv3PRhvt0tgtABaWPHiewD9RxXhI1jNUCD6x1s3zHDx3HG99hKYAUYOrf7Xk3cVGC2AFmpvXqf/tSR8hOaYAYCeApfRu/FvcW3tBdUkLRC+g/3JLR6agSCIdonEDBoyA0EQZAaCIJQgMxAEIcf2TzT2/8ImMxAEUUZmIAhCCTIDQRBypP94S2YgCILMQBCEEvbfTZAZCIJwQGYgCEKO7XcT9H0GgiBESMxAv5sgCKLM8VvLj8gMBEFwyAwEQciRmEETmkdmIAhC9osqMgNBEPTkFoIgFLCbge4zEAThQGIGTRiZgSAI+3cg7U+IJTMQBFEmMwPNJgiCKKP7DARBKEFmIAhCDpmBIAg5NjPQt6MJghAhN8P9s3QoB81MszPYVgRBtGNAC0P+LDbDvVGXOydevWfapQ4T85zBfmqhCOTmXcY5IbzAOR7syHluzgrAcNIInrWDB7l5WACVpvNik3p0jFRau8WOeIudP54UwLNie3TER54WBh8Teu5nZuj6KbvhwNhnX3CXfc7xKMMe7uNBbirFVtuR+5Xtsc8pHraqs2J7hCfF9oxWP7W8faJ6cm63yJng+QHazxYe2cPM8MD77J0gCELE/wPPQkbT)
&]
[s5; &]
[s3;:16: 16. Layouts&]
[s5; Placing widgets by specifying their numeric logical coordinates 
is time consuming, therefore TheIDE provides visual designer 
to simplify this task.&]
[s5; &]
[s0;= 
@@rawimage:3502&2261
(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)
&]
[s5; &]
[s5; Visual design in U`+`+ is called `"layout`" and group of layouts 
is stored in .lay file. Format of .lay files is such that it 
can be directly included into C`+`+:&]
[s5; &]
[s7; #include <CtrlLib/CtrlLib.h>&]
[s7; &]
[s7; using namespace Upp;&]
[s7; &]
[s7; [* #define LAYOUTFILE <Gui16/dlg.lay>]&]
[s7; [* #include <CtrlCore/lay.h>]&]
[s7; &]
[s7; struct MyApp : public WithDlgLayout<TopWindow> `{&]
[s7; -|MyApp() `{&]
[s7; -|-|[* CtrlLayout(`*this, `"My dialog`");]&]
[s7; -|`}&]
[s7; `};&]
[s7; &]
[s7; GUI`_APP`_MAIN&]
[s7; `{&]
[s7; -|MyApp().Run();&]
[s7; `}&]
[s5; &]
[s0;= 
@@rawimage:1235&551
(iVBORw0KGgoAAAANSUhEUgAAAOAAAABkCAIAAAAQbqt4AAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAAAJcEhZcwAADsMAAA7DAcdvqGQAAAASdEVYdFNvZnR3YXJlAEdyZWVuc2hvdF5VCAUAAASiSURBVHhe7Zw/TtxAFIfdRImo6KgogihIQxOJljvQUUTaKyCaVGmh5QJpIqXZggtwBESba+QGybz55/HYu+NFDH5rf59+Wo3fPHul1adnIxaab0+/CVEbEfTL809CFAZBieogKFEdBCWqg6BEdRCUqA6CEtXJBT17vjlsmubqJlZcTm5Pm+b06LFTdPGnBA5u73398fpg2ynDW2R+MVZ8/vUjK5qYotnKilkGBT09OO/YExQs2+Y7e35nQdBFxYj44eOnzNHBYj/Dgh5encZBKMWHy+bqcpNSmW12cF4ed3uyIOjSkuk40k6TYUGPHs2rl+zs+f5IBqqrm3Vz+BCajbjn1yeZoNIvPamFx1cygQU7XNMtK7SnvXIoHtxepxcn+5so5Xg7TTYJKko5XcSVxEI7Tf0d3PVk43BQ0LAVLtJZJG/UK2559iV7F6fmeDtNNgoavMwttAsZrrKwDXErXMFN3E5dtPZ0tqyU7fOAf6/w1vZqnYuTvc6bCuo8e/CupKKYqWaeUN1reoq/QnCub2HfXQRdTpyd5jUusobBbBRU1nbs9S20Al0ehp/0O1uyDrfsUA+Pqk5HW4lbaX/rcVvkFj+PZFKOd3SroDLw/HhL6yZm1MUnUedToO2Jp7inUiFo3XkX8dKRnBseCfghaQYZ1HGko7mgI+PuxVmxRuJYzepkj2IGzaCIpmi2smKW1whqb/H+GbF2ZFS/13sRhdlN0HCzrnvPbR8JBMbnovOaCUrIuwVBieogKFEdBCWqg6BEdRCUqI4X9C+AShAUVIOgoBoEBdUgKKgGQUE1CAqqQVBQDYKCarQL2nz/Q4rxH9Yc2QNB/8FWEHRKELQIgk5JKmjTNH4FCQg6JQhaBEGnBEGLLFzQ9aq5uHvxBxsY02MY2dYBQYsgKIKqBkERVDUImltlSp7VOhQu7tZ3F7bWdr/4SuhD0Cog6Car4pY11i1FylgMJ65XdoWgVUDQnlVWSEvPRXsgA7MdnxYpIWgVELRrlZjnbtlm1Rc0bLdtEQStAoJ2rYoFUTAKGppaL5OiB0GrgKAt1i9x0B6sVskENQe2mozN0ChIFUGrsHBBJwZBiyDolCBoEQSdEgQtgqBTkgoKgyDolCBoEQSdEvPpk2L8hzVHtAsKCwdBQTUICqpBUFANgoJqEBRUg6CgGgQF1RQE/ToO3w3w1pQF9b9Q2wyCQj2qCZp80XmHbym339IHEOoIKnZGz4rSveab9rAQagja/l2Sp1fogqCwkQqCDuhoSk5B62LnXzwkjwLZ3y3JdTzhcnb3zp+B1EugjqC5O9FZq6PblZpbJVK2a+n0XnY6QzXZhxkzxQT1LspBsLYnaPci2zph1lQQtG9oW0ititUh7RAULDUEtfK0eslBUClZD1sb18klCp0wZ+oIahDBPFFVZ1X/Xzz4XjlOtBMvHYNSpmuYLdUEHQarYDfKgo7Bd5dBUNiNgqBvDYLCbryzoAC7gaCgGgQF1SAoqAZBQTUICqpBUFANgoJqEBRUg6CgGgQF1SAoqAZBQTUICqpBUFANgoJqEBRUg6CgGgQF1SAoqAZBQTVeUEKU5un3f/yTFC35jMdxAAAAAElFTkSuQmCC)
&]
[s5; &]
[s5; To understand how this works, let us examine content of .lay 
file first:&]
[s5; &]
[s7; LAYOUT([* DlgLayout], [* 208], [* 64])&]
[s7; -|ITEM([* Label], [* dv`_`_`_0], [* SetLabel(t`_(`"Label`")).LeftPosZ(8, 
36).TopPosZ(8, 19)])&]
[s7; -|ITEM([* EditString], [* text], [* LeftPosZ(48, 92).TopPosZ(8, 19)])&]
[s7; -|ITEM([* Option], [* option], [* SetLabel(t`_(`"Option`")).LeftPosZ(8, 
108).TopPosZ(32, 15)])&]
[s7; END`_LAYOUT&]
[s5; &]
[s5; Header [* CtrlCore/lay.h] includes [* LAYOUTFILE] several times, 
altering definition of LAYOUT, ITEM and END`_LAYOUT to produce 
C`+`+ code which simplified form for this example looks like&]
[s5; &]
[s7; template <class T> struct With[* DlgLayout] `{&]
[s7; -|[* Label] [* dv`_`_`_0];&]
[s7; -|[* EditString] [* text];&]
[s7; -|[* Option] [* option];&]
[s7; `};&]
[s7; &]
[s7; template <class T>&]
[s7; CtrlLayout(With[* DlgLayout]<T>`& dlg, const char `*title)&]
[s7; `{&]
[s7; -|Size sz `= Ctrl`::LayoutZoom([* 208], [* 64])&]
[s7; -|dlg.SetMinSize(sz);&]
[s7; -|dlg.SetRect(sz);&]
[s7; -|dlg.Title(title);&]
[s7; -|[* dv`_`_`_0].[* SetLabel(t`_(`"Label`")).LeftPosZ(8, 36).TopPosZ(8, 
19)];&]
[s7; -|[* text].[* LeftPosZ(48, 92).TopPosZ(8, 19)];&]
[s7; -|[* option].[* SetLabel(t`_(`"Option`")).LeftPosZ(8, 108).TopPosZ(32, 
15)];&]
[s7; `}&]
[s5; &]
[s5; This way, U`+`+ keeps tight coupling between visual design and 
C`+`+ code.&]
[s5; [/ Notes: ][*/ t`_][/  function with string literal argument provides 
internationalization of texts. ][*/ dv`_`_`_0][/  is synthetic member 
variable name used for unnamed layout members (0 is index of 
member).]&]
[s5; &]
[s3;:17: 17. Value of widget&]
[s5; Many widgets have some sort of natural value. E.g. the value 
of [^`:`:EditString^ EditString] is String entered by user, whereas 
the value of [^`:`:Option^ Option] is bool specifying the status 
of the option.&]
[s5; U`+`+ provides unified interface to determine the main value 
of widget via [* GetData] and [* SetData] methods. All types of values 
are passed using polymorphic Value.&]
[s5; &]
[s7; #include <CtrlLib/CtrlLib.h>&]
[s7; &]
[s7; using namespace Upp;&]
[s7; &]
[s7; GUI`_APP`_MAIN&]
[s7; `{&]
[s7; -|TopWindow  app;&]
[s7; -|app.SetRect(0, 0, 200, 20);&]
[s7; -|EditString text;&]
[s7; -|app.Add(text.TopPosZ(0, 20).HSizePos());&]
[s7; &]
[s7; -|text.[* SetData](`"Some text`");&]
[s7; -|app.Run();&]
[s7; -|PromptOK((String)text.[* GetData]());&]
[s7; `}&]
[s5; &]
[s5; Because this feature is used very frequently, U`+`+ provides 
operator overloads for this interface `- [* operator<<`=] for SetData 
and [* operator`~] for GetData.&]
[s5; &]
[s7; #include <CtrlLib/CtrlLib.h>&]
[s7; &]
[s7; using namespace Upp;&]
[s7; &]
[s7; GUI`_APP`_MAIN&]
[s7; `{&]
[s7; -|TopWindow  app;&]
[s7; -|app.SetRect(0, 0, 200, 20);&]
[s7; -|EditString text;&]
[s7; -|app.Add(text.TopPosZ(0, 20).HSizePos());&]
[s7; &]
[s7; -|text [* <<`=] `"Some text `- operator version`";&]
[s7; -|app.Run();&]
[s7; -|PromptOK((String)[* `~]text);&]
[s7; `}&]
[s5; &]
[s3;:18: 18. Accepting and rejecting widgets&]
[s5; Ctrl interface provides&]
[s5; &]
[s7; -|virtual bool   [* Accept]();&]
[s7; -|virtual void   [* Reject]();&]
[s5; &]
[s5; methods. [*/ Accepting] is usually a reaction to pressing OK button 
or similar approve operation and usually involves testing for 
correct content and finishing any pending operations for widget 
(this may involve e.g. updating data to SQL database). Accept 
must return [* true] if widget is accepted.&]
[s5; Default Ctrl implementation calls GetData for the widget. If 
ErrorValue (special Value content) is returned by GetData, displays 
error information contained and returns false, otherwise recursively 
calls Accept for all children, anding the loop and returning 
false when any child returns one. If no false was returned so 
far, Accept returns true.&]
[s5; The opposite method to Accept is [*/ Reject]. This is used when 
Cancel button is pressed or similar rejecting action. It simply 
cancels all pending operations on widget. Default implementation 
calls Reject for all children.&]
[s5; &]
[s7; #include <CtrlLib/CtrlLib.h>&]
[s7; &]
[s7; using namespace Upp;&]
[s7; &]
[s7; GUI`_APP`_MAIN&]
[s7; `{&]
[s7; -|TopWindow  app;&]
[s7; -|app.SetRect(0, 0, 200, 20);&]
[s7; -|EditDate  date;&]
[s7; -|app.Add(date.TopPosZ(0, 20).HSizePos());&]
[s7; -|app.Run();&]
[s7; -|if(app.[* Accept]())&]
[s7; -|-|PromptOK(`"Correct date.`&`[`* `" `+ AsString(`~date));&]
[s7; `}&]
[s5; &]
[s0;= 
@@image:1029&260
(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)
 
@@image:854&629
(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)
&]
[s5;= &]
[s0;= 
@@image:1029&260
(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)
 
@@image:874&629
(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)
&]
[s5;= &]
[s3;:19: 19. Widget edit status flags&]
[s5; Ctrl interface provides several edit status flags:&]
[s5;l160;i150;O0; [*/ Enabled]/[*/ Disabled] `- disabled widgets do not 
receive any input. Disabled status is usually expressed by altered 
visual appearance of widget.&]
[s5;l160;i150;O0; [*/ Editable]/[*/ ReadOnly] `- read only widgets receive 
input messages but no changes to data are allowed. The difference 
from disabled status is that ReadOnly status allows read operations, 
like selecting and copying data to clipboard.&]
[s5;l160;i150;O0; [*/ Modified] `- modify flag is set to true whenever 
data in widget change `- either by user action or by widget`'s 
interface. Flag is cleared by [* ClearModify] method.&]
[s5; Note that with exception of suppressing input events for disabled 
state, implementation of widgets is responsible for correct behaviour 
with respect to listed flags.&]
[s5; &]
[s7; #include <CtrlLib/CtrlLib.h>&]
[s7; &]
[s7; using namespace Upp;&]
[s7; &]
[s7; GUI`_APP`_MAIN&]
[s7; `{&]
[s7; -|TopWindow  app;&]
[s7; -|app.SetRect(0, 0, 200, 60);&]
[s7; -|EditDate  date1, date2, date3;&]
[s7; -|date1 <<`= date2 <<`= date3 <<`= GetSysDate();&]
[s7; -|date1.[* ClearModify]();&]
[s7; -|app.Add(date1.TopPosZ(0, 20).HSizePos());&]
[s7; -|date2.[* Disable]();&]
[s7; -|app.Add(date2.TopPosZ(20, 20).HSizePos());&]
[s7; -|date3.[* SetReadOnly]();&]
[s7; -|app.Add(date3.TopPosZ(40, 20).HSizePos());&]
[s7; -|app.Run();&]
[s7; -|if(date1.[* IsModified]())&]
[s7; -|-|PromptOK(`"Date was modified!`");&]
[s7; `}&]
[s5; &]
[s0;= 
@@image:1029&460
(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)
 
@@image:994&629
(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)
&]
[s5; &]
[s3;:20: 20. Breaking the modal loop&]
[s5; When you invoke [* Run] for your TopWindow,  the new event loop 
is entered. In order to exit it, e.g. by pressing the button, 
you have to call TopWindow`'s [* Break] method. Argument passed 
to Break is then returned from Run.&]
[s5; &]
[s7; #include <CtrlLib/CtrlLib.h>&]
[s7; &]
[s7; using namespace Upp;&]
[s7; &]
[s7; struct MyApp : TopWindow `{&]
[s7; -|Button exit;&]
[s7; &]
[s7; -|void Exit() `{&]
[s7; -|-|[* Break](999);&]
[s7; -|`}&]
[s7; -|&]
[s7; -|typedef MyApp CLASSNAME;&]
[s7; -|&]
[s7; -|MyApp() `{&]
[s7; -|-|SetRect(0, 0, 100, 100);&]
[s7; -|-|Add(exit.SetLabel(`"exit`").LeftPosZ(10, 64).TopPosZ(10, 24));&]
[s7; -|-|exit <<`= THISBACK(Exit);&]
[s7; -|`}&]
[s7; `};&]
[s7; &]
[s7; GUI`_APP`_MAIN&]
[s7; `{&]
[s7; -|MyApp().Run();&]
[s7; `}&]
[s5; &]
[s5; As this is very common situation, TopWindow provides another 
method, [* Breaker], which returns a Callback which, when invoked, 
performs the [* Break].&]
[s5; &]
[s7; #include <CtrlLib/CtrlLib.h>&]
[s7; &]
[s7; using namespace Upp;&]
[s7; &]
[s7; struct MyApp : TopWindow `{&]
[s7; -|Button exit;&]
[s7; &]
[s7; -|typedef MyApp CLASSNAME;&]
[s7; -|&]
[s7; -|MyApp() `{&]
[s7; -|-|SetRect(0, 0, 100, 100);&]
[s7; -|-|Add(exit.SetLabel(`"exit`").LeftPosZ(10, 64).TopPosZ(10, 24));&]
[s7; -|-|exit <<`= [* Breaker](999);&]
[s7; -|`}&]
[s7; `};&]
[s7; &]
[s7; GUI`_APP`_MAIN&]
[s7; `{&]
[s7; -|MyApp().Run();&]
[s7; `}&]
[s5; &]
[s5; Another common situation is handling OK and Cancel buttons. 
OK button has to Accept the dialog before breaking the loop (if 
accept is successful), Cancel has to Reject it. TopWindow therefore 
provides [* Acceptor] and [* Rejector] methods providing Callbacks 
that invoke [* Accept] and [* Reject] as needed before calling the 
[* Break].&]
[s5; &]
[s7; #include <CtrlLib/CtrlLib.h>&]
[s7; &]
[s7; using namespace Upp;&]
[s7; &]
[s7; struct MyApp : TopWindow `{&]
[s7; -|Button ok, cancel;&]
[s7; -|EditDate date;&]
[s7; &]
[s7; -|typedef MyApp CLASSNAME;&]
[s7; -|&]
[s7; -|MyApp() `{&]
[s7; -|-|SetRect(0, 0, 200, 90);&]
[s7; -|-|Add(date.LeftPosZ(10, 80).TopPosZ(10, 20));&]
[s7; -|-|Add(ok.SetLabel(`"OK`").LeftPosZ(10, 64).TopPosZ(40, 24));&]
[s7; -|-|Add(cancel.SetLabel(`"Cancel`").LeftPosZ(100, 64).TopPosZ(40, 
24));&]
[s7; &]
[s7; -|-|ok.[* Ok]() <<`= [* Acceptor]([*@(128.0.255) IDOK]);&]
[s7; -|-|cancel.[* Cancel]() <<`= [* Rejector]([*@(128.0.255) IDCANCEL]);&]
[s7; -|`}&]
[s7; `};&]
[s7; &]
[s7; GUI`_APP`_MAIN&]
[s7; `{&]
[s7; -|MyApp app;&]
[s7; -|switch(app.Run()) `{&]
[s7; -|case [*@(128.0.255) IDOK]:&]
[s7; -|-|PromptOK(String().Cat() << `"OK: `" << `~app.date);&]
[s7; -|-|break;&]
[s7; -|case [*@(128.0.255) IDCANCEL]:&]
[s7; -|-|Exclamation(`"Canceled`");&]
[s7; -|`}&]
[s7; `}&]
[s5; &]
[s5; Calls to [* Ok] and [* Cancel] methods of Button here make Button 
react to Enter and Esc keys.&]
[s5; &]
[s5; To reduce tedious tasks even further, there are CtrlLayoutOK, 
CtrlLayoutCancel, CtrlLayoutOKCancel etc. template functions 
that both setup layout and assign Acceptors and Rejectors.&]
[s5; &]
[s7; #include <CtrlLib/CtrlLib.h>&]
[s7; &]
[s7; using namespace Upp;&]
[s7; &]
[s7; #define LAYOUTFILE <Gui20d/myapp.lay>&]
[s7; #include <CtrlCore/lay.h>&]
[s7; &]
[s7; GUI`_APP`_MAIN&]
[s7; `{&]
[s7; -|WithMyAppLayout<TopWindow> app;&]
[s7; -|[* CtrlLayoutOKCancel](app, `"MyApp`");&]
[s7; -|switch(app.Run()) `{&]
[s7; -|case IDOK:&]
[s7; -|-|PromptOK(String().Cat() << `"OK: `" << `~app.date);&]
[s7; -|-|break;&]
[s7; -|case IDCANCEL:&]
[s7; -|-|Exclamation(`"Canceled`");&]
[s7; -|`}&]
[s7; `}&]
[s5; &]
[s5; Note: IDOK, IDCANCEL are predefined constants.&]
[s3;:21: 21. Creating and using custom widgets&]
[s5; There is really nothing special about creating your own widgets. 
All that is to be done is to derive your own class from Ctrl 
(or some other existing widget, if that fits better) and override 
Ctrl`'s virtual methods to paint the widgets and do something 
useful:&]
[s5; &]
[s7; struct MyCtrl : public Ctrl `{&]
[s7; -|int count;&]
[s7; -|&]
[s7; -|virtual void Paint(Draw`& w) `{&]
[s7; -|-|w.DrawRect(GetSize(), White());&]
[s7; -|-|w.DrawText(2, 2, AsString(count));&]
[s7; -|`}&]
[s7; -|&]
[s7; -|virtual void LeftDown(Point, dword) `{&]
[s7; -|-|count`+`+;&]
[s7; -|-|Refresh();&]
[s7; -|`}&]
[s7; -|&]
[s7; -|MyCtrl() `{ count `= 0; `}&]
[s7; `};&]
[s5; &]
[s5; To put your widget into your layout based dialog, the simple 
way is to add it as `"User class`". In that case you just fill 
in the name of class and layout designer shows the custom widget 
as empty rectangle with class name sticked on it:&]
[s5; &]
[s0;= 
@@image:2374&1454
(A9sBIwEAAAAAAAAAAHic7Z3rdhO5gkbzgvMQ50km6yzmIebH/Jsfs9bp00DTTZo00ECTkJArCZdAgHTn4oTEDjgX0sSGGtnCQpSqZJVcd++9vuVVKcuySrY2Qi6Xm+82mlXOD//334W3gZA8k917nprJiOHlIOOWKsqtijUTQgghzf4/NIQQQgqMEnIAAACFooT8n/9zi5DUE/pfmP6WI4TERYydov9xgLqBkAnxixTys/VFQswct/a63Ut3FTebewi5ivmhxCctVKttf9y7NnXjf73XkBEysUQIWbw9Li7O2u2j4+N94dujo53Dw+2Dgy2R/f23Io3Gm93dl6enx6Lk3t4mQq5iqiW98iTUNmFjkYP9v05PP7hPY0RhVQNCJpZIIQsbX1ycnp+3hXVPTlrtdrOfow8fDt+/f9cX9a7Qsii5tbWGkKuYCkmvVAm1TcyNhY3dVfztv5aDGuxCntCIKxAqGXlvaDvFZFQtkZFCFsoVNj47+zCw8VcVSxu3Wg0l5I2NeYRceCYnJ5I+pELSS5SJiWzfeKG2iT8TzY0TCdnddZHiDfkZIVcxUsjN5t5gbtxTsUzfw3uD7O7vvxUl19cfeAtZvJSR2/aHhBhxfKVYlffzeh+U9LC4DYIJte0nllLFu23CxkOFPBmPR9vkW10gXjX3DRchR4rOFKxZLE7CkSV1aVusbiljn8CTESOFfHi4rS9TiMzPP5AeVpFCXlm5m7OQ9WmGn0hD9hPVDGpyVeKViYkr/ZZ4FxBPcS8GxyNSHjY3PMRSqvi1Tdp4qJMzEnLqM2Q/IVv+tDjTrMpvD0k9mpCPdBvLCA8fHe3IWynkpaXbxQpZ3iYZthNX/nnlyj97t9LGSsv9u77ea69T+jbOukNt3BwIWZTyFnJTc7J+6/jY+gm5qc2QLU6unJD1KaiLISMribs3cgJsnw9b9pDUI4V8cLAlPCydrGwsI1QsI4W8uDg9ipClfNwnusrA2saVUIbWoGyc9F49cU52sXFTmyGbTnafIcs0tbULtSepWEoVS9t0f4q+MnU6VMjpti23JYuhPnScUdvvQshlixSykG1obtxqNXQniym0/FBvFCE3BxNj9zlhaIbcf5NfCf1pd7KaIcfhMkNWCTnZRcWqGZqBg6RClvNhGX2GrPYkFYtDg7/9EyS6yOUhHvPPoW0bKuRBa22LRaKwvFUb8tajbdnNkIfaT98TZ8WkQh66jZBzjhSykO379++UgQenuu2pPX0hv+4L+daIQnafHje/nyErg5p+tjh5QluXsNy6Nyk0QU964IN/koKkvRGaIYvnVXvkjbf0+i25om+H+tPFyVJ3+ksT0qZFgFkLWSFVHHoh7KvQeQr5Wcyqgr5H3VpKOlaldkY2YGiTCndXLTMQ8mthYOlkaWN57rHwsLTxu3d/piLkZpLpcTN+hizfEsFghmyZJ09MmO6NTIJWJbVxTMMSPzZyDbmnvolJeWt57FAhyw6M78bhQg6Zp9m/spk0p9K1R9tG7MzQrFj/06WG3JYsCgleLVukkPf2NluthvSwjDz3WC5WCBsfHGzJ7+iNPEO+0lep03+Bmw4zZF3UcTWE5sNmDS5r0Sp+M+SkGokSS+xZFmqmbHm4i5Ct/9FwEnLcXd5CHlGno78WOc+Qcw5CLluUkIV+hYRV5HeolZD399/u7r5MRcguw18rb5shK4YJOTxDjqlzeHvMNWQPJ6tmN7+tXXxbwbA8UFuvGMyNJ7/1TypCHnGGHLl/FCHrr7LHgkPT+SyLnIUMEIkU8vb2CyFeeYabnBjrc2N5OYudnd7/QL0/1NPHuxrdLudIGKQzQ1bt0bftjRnlLItQk77/UC9QH/M5rpx89bB+Jm56Qjb7wX0NOXLniEKOnB6bz2VvWOpCHnHJAiASKeSTk5aYJDcarwd5o7bFfhFh43b7SJRcW7sfJBdyyMDuQo6sKkh7hiyxN8ayRjGKkJVQkwl5YtJs/yhCth34P13XcyKdHGpkum1zb5VFyPYT55ghQ54IIYvpsWPhV6+W/C6/mbqQTbxnyPo82eYl66JxIidPjP6tPSnk9GbIaUW+FkkfNfpZFt4Z+tUShAx5IoR8enr84sXc4uL0/PzNmZnrDx9eNXJtdvbG6urv5+ftVITcjDq3ynkExZ0mYTvzbZRFD5URP8LT25OOkL+nDEL2S1FCdvnyNUsWkCfv3ze/fOm4R5QPRlhDLnzsN72U7hK/c5JNXGpQp1WEYnkIQo55LYZ8Jhgp5G73MmlUDQgZLOQmZFJsKirkHJJUyKenHy4/nSeNqgEhgwWEPCZByKm0TV6g/uLjh6RRNSBksICQxyQVkl6pktFPOAFEgpDHJBWSXqmS0Y+cAkSCkAnJMwgZLCBkQvIMQgYLKQo56X/iCBmfIGRwIUUhA0AcCBlcYMmCkDyDkMECQiYkzyBksFB7If9Q4lOqOLox7B+EDBYQcqVT76OrZf8gZLCAkCudeh9dLfsHIYOFTIVsv6yZy4XORq8hbkhOxv+AxSjJuVrL0bkztMGRZdyPNK5kRn3l0j8FBiGDhayF7P5GjRNyTGHXpxtPISd9GyR69pDPvRufSl8lulZbFrH8SxdZHiGDhZyFbJnNOgpZv6h4aDB6CNk+jobaRhWw1ONeiaWepEIO1Ta0kY62MffLd9HQSiLLxO13T9LLy2cR1Qny7RTaNssjZLCQv5BFycifxnCfIccNQz8hhzpEjSMlHPtg1IWpV6gL37GS0OgO1RNZiUU4sk5ViaXyocKJdK+jjZuZCdnyT7PLq++O49GFyiNk8CB/IQsbB/1ftxlaOG5nM70lC3PUTEbNnF0GdTAYlcH3w9O9hshRPIqQ1UPsB2sXTtNwr7uv4ko61qBeUP2/VKFX2W/JYtL4tymOoV0U94ZByOBBPkJWo8acIet3DR2S9s/yUhSykobqKLOGQJsARwpZLxBXQ6hMCYUcqVPVLS6+iuyEuP1xr37oVivjL+Rm/ILS5LCJrllVwJIFjExuQh78tu93M2T9P5tDhRz0TW7ejihkk+B7jw0djPZ63CtpGlNHU/iOR6dqVi4derAWL6ljNLvFUenqAF32R776zQyEbOkB1W/uQnbsGYQMFrI/7S34Pt9myOZd9iEZaeNAW/3wO8sisltUscjj0qMKyAfqcyT9LsdK4trjJ2S9NkvlFtW4436ALvvNV9+Q82QokTXkcFogQoYUqdAMOYslC7tGPJJztUOFHKnKof4MPa9kUvvvgLnTUkPI2O4+z22GbKLuQsiQJ1VZQzb2p3YecqQTEinLLh+Pesyq/IQcd2gWB9orUT0WDNOOflDynRY6Fp24SvJZQ4586tC/Pvb+iewNhAweVPEsi3RPe4s0hvtEV8lqUltyVNse9TSjPOYh5MgpqMu8NK6vAk01OpYDjBSU+RCLkJWEI5cvmiMLuTlsOcVRyGbHImTwgC+GBN8bYzKKuBpMNcVV4liDOZbNdrocnVLKpDYdtey0C8c8BMdKRhSyPbmdh2xvm35cqrzlJUPIYOG4tdftXrqXbzb3ghp9dTrOGLptvh54lO4CY7HR1PLQGkL1RLbKT8jNGNe5CzDun5VIS9traGpzzqTSi3/PeH5Tz/0NH/faRXamegUtnYyQwYIQsri9uDhrt4+Oj/eFb4+Odg4Ptw8OtkT299+KNBpvdndfnp4ei5J7e5tBvS4uZBojqbJkT8bJx6Mes6qihNyMmgzHWdpSg35ozYQne9hT5mtZRB4UQgYLUsjCxhcXp+fnbWHdk5NWu93s5+jDh8P379/1Rb0rtCxKbm2tBbW4/KY+XlRv6AXcj0gvGfKqdz2hVhUo5MjygcOShcVUJjm/+unGMr7MwggZLEghC+UKG5+dfRjY+KuKpY1brYYS8sbGfFALIcvDz2h45lati3AiH5i0kR6VJH0rZtFpXH4TqoUUcrO5N5gb91Qs0/fw3iC7+/tvRcn19QdBLYRcj9T76GrZPwgZLEghHx5u68sUMtLDKlLIKyt3A4RcmtT76GrZPwgZLGhCPhKZn38QsrHYI26PjnakkJeWbgcIuTSp99HVsn8QMliQQj442BISFu6VabUaIkLCao8S8uLidFApIRNSqiBksCCFLGQrJ8a6k3Ubiym0/FAPIRMyShAyWJBCFrKV51SIKA8rGw+E/DroCbn3djKFTAixBCGDCwMhvz4+3jedLDws8+7dn3YhJ/0GB8BYgZDBBSnkvb3NVqshnKyiPsuTNj442JLf0bMIueAjKYLJ/qV4i24FVACEDC4oIQv9ys/yZOR3qJWQ9/ff7u6+DBDy9yBkcAQhgwtSyNvbL4R4hX7lqW66iuUVLRqNNzs7ve9exX2oh5ABLCBkcEEK+eSkJSbJjcbrQd6obbFfRNi43T4SJdfW7gcIeQBCBkcQMrgghCymx46FX71airv8JkIGsICQwQUh5NPT4xcv5hYXp+fnb87MXH/48KqRa7OzN1ZXfz8/byNkHYQMjiBkyA6ELEHI4IguZEJSj6OQ8zzVM38m+4FiyVmtfhT+DUEyPrEL+V59mewLuehWjDUImZBQEDIUBUImJBSEDEWBkAkJBSFDUVROyIV/+kNqGYR8DyGXgCoKuei2QN1AyBKEXDgVFfLR4SYhZo5be93uZYL3VcIvhiBkyBSETOoUeS2Li4uzdvvo+HhfXuTt8HD74GBLXlZIXllod/fl6elx0L8uXICQByDkwkHIpE6RQhY2vrg4PT9vC+uenLT0X6B+//5dX9S78iectrbWAoQ8ACEXDkImkXk081MW/Szeb+afoZ2RexzbLIUslCtsfHb2YWDjryqWNu5fHvmrkDc25gOEPAAhF05thBz6+mHhQqt64oSs961HP+cj5GZzbzA3PpK/dioiL1M/yK781en19QcBQh6AkAunNkIeZSCTSLlF9nMlhHx4uK0vU8ifn5YeVpFCXlm5GyDkAQi5cGosZHM7cgrNpDpObpH9HNnDoT5012zc65KGkI90G8vIXw+Rt1LIS0u3A4Q8ACEXzrgJeegeouQW189xvj36XrD2V8f9dUnUZinkg4Mt4WHpZGVjGflzTkrISX/CCSFDptRYyObots+ZEXJIbnH9HGlRvQ/jejI3IQvZhubGrVZDd7KYQssP9RCyDkIuHIRcuPrKGXchu/dqbkIWsn3//p0y8OBUtz21py/k10HyX51GyJAp9RZy5GC3q4AouTn2cymF/FoYWDpZ2lieeyw8LG387t2fCNkEIRfOuAnZXJ1gvSJObu797LJkYdlpvi4jCnlvb7PVakgPy8hzj+VihbDxwcGW/I4eQtZByIVTMyEP9UbhoqtKUv9iSA6drwtZ6FdIWEV+h1oJeX//7e7uywAhfw9CLhyETPJJPp0vhby9/UKIV57hJifG+txYXs5iZ2cj4EO970HIhVNRIW+/XSLEjBTyyUlLTJIbjdeDvFHbYr+IsHG7fSRKrq3dDxDyAIRcOBUV8vO1B4SYEUIW02PHN9WrV0tcflMHIRdORYW88OhXQswIIZ+eHr94Mbe4OD0/f3Nm5vrDh1eNXJudvbG6+vv5eRsh6yDkwqmokPXhQ7KIkFLhbfBo8/v3zS9fOu4R5QOEPAAhFw5CJnFyK7wNHm1GyKOAkAsHIbtE9FLhtslfbpXrXoQ8Igi5cGomZPnlgrg/48qrYnGFEXIqybp7EfKIIOTCGWchm3chZF1KqdeJkEsOQi6c+gnZcmuWMR8emi3bZ841jkXIoV5SnWN2cmTh7LoXIY8IQi4chGw+XDeJuX9MYhdy5MbQTs66exHyiCDkwqmlkF2k4SLkyO0xiYeQh3Zy1t1bVyGLtoSS0RNlIeTcGp8RObcfIedpjAoFIUe+DxFyUhBywqerp5BdBr57YYQc2Uv21WN7hyPkJIMUIRcGQo5EDZYUhdw0TntTezIyRoWSipD1Hs6he8dHyBOTk1lECjnlavNqfFZByFGoweL9xZAxlOqIcqtcJyNkhIyQ80ENFoScm9wq18kIGSEj5HxQg0UKWQwZQszUUsjfRuvAEoX38/hE9XlOL3E1hQwQyfgIucBmjA8IOQ6EDC4gZEgRhBwHQgYXEDKkCEKOAyGDCwgZUgQhx4GQwQWEDCmCkONAyOBCikKeLHEQcj4g5DgQMriAkCFFEHIcCBlcYMkCUgQhx4GQwQWEDCmCkONAyOACQoYUQchxIGRwoZZCNi+ngJDzof9OyPlaFuGnKycIGVxAyJAiCDkOhAwuIGRIEYQcB0IGFxDyeJLh1d4QchQIGVxAyOMJQs4ZhAwuIOTxJDsh606W2+oZ9WdPazv0XPJtKLbVO7Ak2wgZXKilkBWc9hZHYPxohbkndK/EUljtVKe9ZSRhfVu98Uoi3rhthAwuIOTxRL46Id9abBzajiwcIGSEDKOBkMcT+eqYQg4c3Kte3FCZACEjZBgNhDyeBDE6DRJOhuWrzAx56DZCBhcQ8ngSxKs48k+LkM2dCNncRsjgAkIeTwKEjJChfCDk8SQwjBpEqTXuLvujELK5jZDBBYQ8ngRJhBxyi/oTIbtvI2RwASGPJyHfmvq1F7AHIZvbCBlcQMjjSdY25nrIIRAyuDA+Qib5BCFHgpDBhVoK2byWhbJEBZJN4x0tmkX7M36tETLUB4RculS68Qg5BoQMLiDk0qXSjUfIMSBkcGFMhJx/G7ypdOPv5d5+hAx1AiGXjYwab19DTuUpJAg5EoQMLiDkslHpxt9DyDEgZHChlkKG8QEhQ51AyFBpEDLUCYQ8JuS2hpwzCBnqBEKGSoOQoU4gZKg0CBnqBEKGSoOQoU4g5DGBNeRiQcjgAkKGSoOQoU4gZKg0CBnqBEKGSoOQoU4g5DGBNeRiQcjgAkKGSoOQoU4gZKg0CBnqBEKGSoOQoU4g5DGBNeRiQcjgAkKGSoOQoU4gZKg0CBnqBEKGSoOQoU4g5DGBNeRiQcjgAkKGSoOQoU4gZKg0CBnqBEKGSoOQoU4g5DGBNeRiQcjgAkKGSoOQoU4ct/a63Uv38s3mXoCQoTQgZKgTQsji9uLirN0+Oj7eF749Oto5PNw+ONgS2d9/K9JovNndfXl6eixK7u1tBggZSgNChjohhSxsfHFxen7eFtY9OWm1281+jj58OHz//l1f1LtCy6Lk1tZagJArCGvIxYKQwQUpZKFcYeOzsw8DG39VsbRxq9VQQt7YmA8QMpQGhAx1Qgq52dwbzI17Kpbpe3hvkN39/bei5Pr6gwAhQ2lAyFAnpJAPD7f1ZQoZ6WEVKeSVlbsBQobSgJChTmhCPhKZn38QsrHYI26PjnakkJeWbgcJhQxuBEbSxL6GnO5z5Uu438oJQgYXpJAPDraEhIV7ZVqthoiQsNqjhLy4OB0kETI4UhWxlI2q9BtCBhekkIVs5cRYd7JuYzGFlh/qIeSMqIpYykZV+g0hgwtSyEK28pwKEeVhZeOBkF8HPSH33k4IOXWqIpayUZV+Q8jgwkDIr4+P900nCw/LvHv3J0LOlKzFYl9DTvnJcgQhQ52QQt7b22y1GsLJKuqzPGnjg4Mt+R09hJwRVRFL2ahKvyFkcEEJWehXfpYnI79DrYS8v/92d/dlgJABvEDI4IIU8vb2CyFeoV95qpuuYnlFi0bjzc7ORsCHegBeIGRwQQr55KQlJsmNxutB3qhtsV9E2LjdPhIl19buBwi5gtR1DbkqIGRwQQhZTI8dC796tZT08psAECBkcEMI+fT0+MWLucXF6fn5mzMz1x8+vGrk2uzsjdXV38/P2wgZwAOEDNmBkAESoQuZkNSDkKsFa8jFoo8XQjINQgawU/ggJeMThAxgp/BBSsYnCBnATuGDlIxPEHL5YQ25WEJDpvDPgEoe+sqvrxAygAumkItuUXkxhVx0i8oLQgbwYJyF3DjuPvnz88Kry9lnF/efXNxdubi99HF68ezXhfOpx+e/zH38+dHH67NnV2fOXjc+BQg5CQgZwINxFrKw8V+HXzb3vzzf6a792V3d6q687i5vfn788vPcRmf2eeePp917Tzq3ly9vzZ8GCDkJCLmisIZcLOMs5IWXnzYbX17udp8KG7/pLm12H7/szm90Z593Z552/ljv3F/r3l3pC3kBIScDIQN4kLOQSzUeZ55ePNvurv/VXXnTXXzVU/H8i+7cM+Hhzt2V7p2V7u3l7m/L4vbyt8VchVyqXvIDIQN4ECfkr7+cPSD0p8l3v7cdr5RSjcd7qxdP3nZX3naXXncXenPjztzzzuyzzgMh5NW+jZe60710bmcj5Er0kh8IGcCDVIRs3lUJ1dxZvlje7K1UiOnxf/zjvx5vdOZfdB4968ysdx486Yg9vy11bvWDkJOCkCsKa8jFYhGy5dYsE8KcLdtnzoUwvfjx8cveurFwr4wQcm+S/LSj9vzaF/K0Vcihg1XHaPZVZOGS95IfCBnAg+yErG9HOqpwph6fzwkDv+hNjJWBHz3/tj213Lm51JkSTrZ+qGcenWNfVaKX/EDIAB7YhWzZsNsjcnIYV7gofpk/n33WUVEelrm12rm53Pll6VJk6rGPkINhfVWJXvIDIQN4MM5CvvHo48On3YfPujP9PNScPL3WubnS+Xm58/PS5Y3Fy5/nEHIyEHJFYQ25WIYKWWExhnvhUo3HqzMf7611/+g7WeSPZ90HT3vryb897fzypPPTSue6yNLltYXLn+bOAi8hW7bdi1URhAzgQSpCDozT3tSeoQ8skH//8fHOSvfek+79tc799c79p937T8VtZ3q9M7Xe+flJT8g/Ll7++PjT9UeeM+QgSsLV6iU/EDKAB3FCtlCbMfXDg/Nbi53bK53fV3u5s9K5s9q5vdaZWuvcfNK5sXJ5benyx4XLf8/9fW3mJPA67a02fZUUhAzgwTgL+V/3z6YWPv26dDm9fHm7n9+WL2+t9M6suLHUub5wefXxJ2HjH+cuEHJSEHJFYQ25WDyEXBs2d/6emm1PzbV/nT+5NX8qIjZEbsyd3Zg7/2nu7PqjU6FikZc7HwOuZZEEhAzgwTgLOSkI2R2EDOCBKWRiCX3l11cIGcAFc9QQklEQcvlhDblYCh+kZHyCkAHsFD5IyfgEIQPYKXyQkvEJQgawow8WQtJN8P2/+D8g5NIz9AWFTNEHy/nZESEpJkDIAElAyCS7BAgZIAkI2S+Fn+Vb8iBkAA8QsreQi37pygtCri6sIRcLQkbIqYOQAfxAyPkLOTspedScRWMQMoAfCHl0IZsX5w+solNXpI98oCP2XxCwtMGx2CggZAA/EPKIQo77VSYXIY/ywg39SRfT83HyR8igYA25WCKFrM/c4oyk7grN9ByF5l6ynIkTstoZ+VNN+k73BwaGS+OKmbWNstMbhAzghynkkCrjzKkL2UNo9RZyYMxXzbuGzlR1FZtl4mbmKe70BiED+DFUyLpC1Rw4tG0vfG5MuZNOp0uYRGvIFtNa5syWnZb9Ke70BiED+GFZsggJNrQdJ1t74cg9VUzcWRaRwhxxhjy0/sjaRt/pDUKuLqwhF4vlQ724Ka4pZPOBCBkhI2SApAw9yyLOnwhZdqCLMEPbCBkAInH8UM++ZDHOQg5i1pADzb16mcB62ptZlUW8oWc07zKrimxq6pJEyAB+uJ/2FtqjtiPVahY2hVxpJ5fwq9PerkPIoGANuVj4YkhthBzw1WmAioOQ6yTkkoCQAfxAyAg5dRAygB8IGSGnDkKuLqwhFwtC9hYysQQhA3iAkEl2CRAyQBIQMskuAUIGSEJosACkSICQqwZryMXCDJlklwAhAyQBIZPsEiBkgCQgZL8UfhpDyYOQATxAyN5CLvqlKy8IubqwhlwsCHkUISf9hGtMQMgAfiBkhJw6CBnAD4SMkFMHIQP4gZDLIGRHTVXFZgi5urCGXCzuF6gPZSL+F0Ps++uRUYRs7kTIABA4/4QTQk5XyKFthAwAgYOQdcGqOXNo+zxqUj3U2JVORkKOLKz2TCScURcFQgbww7JkEbJxaDvk27gCtbTx6EIO7TQ1NRE1c47cWUIQcnVhDblYLB/q6VoOucVRyHW18ehCDm1PGDPkOCFXQmgIGcCPoWdZmL7V99uFHPnAeiQLIVtEbdlZQhAygB+OH+rF+RYh5y9kc3/ZQMgAfrif9hbao7YdjV2zZLSGHHmX+jPO6mUDIVcX1pCLhS+G5C/k2oOQAfxAyAg5dRAygB8IGSGnDkIG8AMhjyJkiAQhVxfWkIsFIXsLmViCkAE8QMgkuwQIGSAJCJlklwAhAyQhNFgAUiRAyFWDNeRiYYZMskuAkAGSgJBJdgkQMkASELJfCj+NoeRByAAeIGRvIRf90pUXhFxdWEMuFoSMkIfSOO4++fPz441PD9cvfl/9W+TO8sX04tmvCx+nHp+L/DJ3cePR+dWZs9eNTwFCBvAFISPkoQgb/3X45VXjy9O/emYWWX3TXd78/Pjl57mNjsjM8+6D9e7t5ctb86cBQgbwBSEj5KGIubGw8cZO98nbz8LDUsXzG92ZZ92Z9V6Eje+u9oQsps0BQgbwBSHnJuSJHH/vI93nerh+IefGS5td4WGZuWcdIeHflj+rCCHfXmSGXG1YQy4W9wvUhzLx/ZXqh5avWXQhqy9BqD8ju1qXpPkFihRxaUwifl/9u7dG8aa/RvG8oyIkPL3UFbm11JEbCBlgFEwhT0T9hJNdyIXrsYpCzu41TV3Id5YvxNxYTo//4x//JWfIwsbCwyJiz1TfySIIGWAUhgpZN7CaA4e2I11tTqFD95qT6gpNs0NCDowfvDOtaBeyWYnuef1P0/+hkpE1j8KvCx+FgR9vfBbulbm/3hG5udxRe6STWUMGGAXLkoXpWLtvJ4yf24t7oFlDZMkyZ3Qh6wSGZu2VD30Ws4ZRUEIOOVltCzMj5HrAGnKxWD7UMx2rizdSuZF7hj5wwpgzV1HIQfwcOFLIoRcitMfUddxzxZWMq9mDqcfnat1Y97Cy8dcsdW4tsGQB4M/QsyzM6WukTuOEbG5bhFy4ZksiZMu81zJDNh8btycpP8997J3hpkXZ+M565876VyH/snT5C+chA4yA44d6Ll61C9llhhxZQzkTKeRAW3nIX8jZzZCvP/r4YL078/xb/njWW7uYftr9aaWjcn3h8sbceYCQAXxxP+0ttMcUbJxOQyXjhGw+RZkzVMhqO6RoR21GPjZuQ39Ssz0jvDu+8u8/Pt5d7X37o5dn3yKEPLXey40n3atLnasLlz/NsYZcbVhDLha+GDK6kMtGFkKeXup9F+/+Wu/LIDJ31jtCxTefdETE9FgI+d/zn67PsmQB4A9Crp+Qg7TPdv7X/bOphU+3lju97+INcmul9yneT/1cX7gUNv5x7uLazEmAkAF8Qci1FHK6bO78PTXb/nX+5Nb8qYr488bcucxPc2dibixs/HLnY4CQAXxByAg5dRBydWENuVgQsreQiSUIGcADhEyyS4CQAZKAkEl2CRAyQBJCgwUgRQKEXDVYQy4WfbDoY4eQ0RMgZIAk6IOl8PFLapYAIQMkQR8shY9fUrMECBkgCfpgKXz8kpolQMhVgzXkYtEHS+Hjl9QsAUIGSII+WAofv6RmCRAyQBL0wVL4+CU1S4CQAZKgD5bCxy+pWQKEXDVYQy4WfbAUPn5JzRIgZIAk/D/4wBKd)
&]
[s5; &]
[s5; Note that layout file has to be included [* after] declaration 
of custom widget (so that the class is defined at that point).&]
[s5; While empty rectangle in layout designer is usually enough for 
seldom used widgets, you can also teach TheIDE to show something 
better using .usc script file:&]
[s5; &]
[s7; ctrl MyCtrl `{&]
[s7; -|group `"Example`";&]
[s7; &]
[s7; -|GetMinSize() `{ sz `= GetTextSize(`"X`"); sz.cy `+`= 2; return 
sz; `}&]
[s7; -|GetStdSize() `{ sz `= GetMinSize(); sz.cx `*`= 7; return sz; 
`}&]
[s7; &]
[s7; -|Paint(w) `{&]
[s7; -|-|r `= GetRect();&]
[s7; -|-|w.DrawRect(r, :White);&]
[s7; -|-|w.DrawText(2, 2, `"0`", StdFont(), :Black);&]
[s7; -|`}&]
[s7; `};&]
[s5; &]
[s5; [/ Note: This is not the C`+`+, but a piece of script in `"Esc`" 
scripting language, interpreted by layout designer.]&]
[s5;/ &]
[s0;= 
@@image:1120&600
(A+AAeAAAAAAAAAAAAHic7d0xTsMAEEXB3P9U3CykQUIRBWvLy8OaUQ4Q73+VGz+fAAAA/OwBFzvZ5wdcRp+U6ZMyfVKmT8r0SZk+KdMnZfqkTJ+U6ZMyfVKmT8r0SZk+KdMnZfqkTJ+U6ZMyfVKmT8r0SZk+KdMnZfqkTJ+U6ZMyfVKmT8r0SZk+KdMnZfqkTJ+U6ZMyfVJ2jz7PPAIjy8vqk5HlZfXJyPKy+mRkeVl9MrK87M36fHw5vQM/W172Tn1+fxaJXmR5WX0ysrysPhlZXlafjCwvq09GlpfVJyPLy75mfPuNpPp8er90veVlb9YnV1teVp+MLC+rT0aWl9UnI8vL6pOR5WXv9H6JBcvL6pOR5WX1ycjysvpkZHlZfTKyvKw+GVleVp+MLC+rT0aWl9UnI8vL6pOR5WXv0Sd3pU/K9EmZPinTJ2X6pEyflOmTMn1Spk/K9EmZPinTJ2X6pEyflOmTMn1Spk/K9EmZPinTJ2X6pEyflOmTMn1Spk/K9EmZPinTJ2X6pEyflOmTMn1Spk/K9EmZPik73ye/8/4d87/+P//Fqe+/80vufIy77XDnY9xthzsf42473PkYd9vhzse4GwAAAADAyydQulkb)
&]
[s5; &]
[s3;:22: 22. Non`-modal dialogs&]
[s5; To have non`-modal dialog, just open [* Open] it passing its owner 
window as parameter. Usually the best arrangement is to have 
non`-modal dialog as member variable of its owner window. Non`-modal 
dialog is dismissed using the [* Close] method just like any other 
window.&]
[s5; &]
[s7; #include <CtrlLib/CtrlLib.h>&]
[s7; &]
[s7; using namespace Upp;&]
[s7; &]
[s7; struct NonModalDialog : public TopWindow `{&]
[s7; -|Button b;&]
[s7; -|&]
[s7; -|void DoClose() `{&]
[s7; -|-|[* Close]();&]
[s7; -|`}&]
[s7; -|&]
[s7; -|typedef NonModalDialog CLASSNAME;&]
[s7; -|&]
[s7; -|NonModalDialog() `{&]
[s7; -|-|SetRect(0, 0, 200, 50);&]
[s7; -|-|Add(b.SetLabel(`"Close non`-modal dialog`").SizePos());&]
[s7; -|-|b <<`= THISBACK(DoClose);&]
[s7; -|`}&]
[s7; `};&]
[s7; &]
[s7; struct MainWindow : public TopWindow `{&]
[s7; -|[* NonModalDialog dlg];&]
[s7; -|Button b;&]
[s7; -|&]
[s7; -|void DoOpen() `{&]
[s7; -|-|if(dlg.IsOpen())&]
[s7; -|-|-|[* dlg.Close();]&]
[s7; -|-|else&]
[s7; -|-|-|[* dlg.Open(this);]&]
[s7; -|`}&]
[s7; -|&]
[s7; -|typedef MainWindow CLASSNAME;&]
[s7; -|&]
[s7; -|MainWindow() `{&]
[s7; -|-|SetRect(0, 0, 400, 100);&]
[s7; -|-|Add(b.SetLabel(`"Open/close non`-modal dialog`").SizePos());&]
[s7; -|-|b <<`= THISBACK(DoOpen);&]
[s7; -|`}&]
[s7; `};&]
[s7; &]
[s7; GUI`_APP`_MAIN&]
[s7; `{&]
[s7; -|MainWindow win;&]
[s7; -|win.Run();&]
[s7; `}&]
[s5;/ &]
[s0;= 
@@image:2084&940
(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)
&]
[s5;/ &]
[s3; Recommended tutorials:&]
[s5; If you want to learn more, we have several tutorials that you 
can find useful:&]
[s5;l192;i150;O0; [^topic`:`/`/Draw`/srcdoc`/DrawTutorial`$en`-us^ Draw 
tutorial ]`- in this tutorial we show more advance techniques 
of drawing inside window. This is the natural continue of things 
mention on this page.&]
[s5;l192;i150;O0; [^topic`:`/`/Draw`/srcdoc`/ImgTutorial`$en`-us^ Image 
tutorial] `- here we move things related to images. We show how 
to create, use and embed icons directly in application.&]
[s5;l192;i150;O0; [^topic`:`/`/Core`/srcdoc`/CoreTutorial`$en`-us^ Core 
value types tutorial] `- learn basics about non user U`+`+ related 
code.]]