/* Html.c generated by valac 0.52.4, the Vala compiler
 * generated from Html.vala, do not modify */

#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <glib/gi18n-lib.h>
#include <libsoup/soup.h>
#include <gobject/gvaluecollector.h>

#define TOOTLE_TYPE_HTML_UTILS (tootle_html_utils_get_type ())
#define TOOTLE_HTML_UTILS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TOOTLE_TYPE_HTML_UTILS, TootleHtmlUtils))
#define TOOTLE_HTML_UTILS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TOOTLE_TYPE_HTML_UTILS, TootleHtmlUtilsClass))
#define TOOTLE_IS_HTML_UTILS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TOOTLE_TYPE_HTML_UTILS))
#define TOOTLE_IS_HTML_UTILS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TOOTLE_TYPE_HTML_UTILS))
#define TOOTLE_HTML_UTILS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TOOTLE_TYPE_HTML_UTILS, TootleHtmlUtilsClass))

typedef struct _TootleHtmlUtils TootleHtmlUtils;
typedef struct _TootleHtmlUtilsClass TootleHtmlUtilsClass;
typedef struct _TootleHtmlUtilsPrivate TootleHtmlUtilsPrivate;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _TootleParamSpecHtmlUtils TootleParamSpecHtmlUtils;

struct _TootleHtmlUtils {
	GTypeInstance parent_instance;
	volatile int ref_count;
	TootleHtmlUtilsPrivate * priv;
};

struct _TootleHtmlUtilsClass {
	GTypeClass parent_class;
	void (*finalize) (TootleHtmlUtils *self);
};

struct _TootleParamSpecHtmlUtils {
	GParamSpec parent_instance;
};

static gpointer tootle_html_utils_parent_class = NULL;

gpointer tootle_html_utils_ref (gpointer instance);
void tootle_html_utils_unref (gpointer instance);
GParamSpec* tootle_param_spec_html_utils (const gchar* name,
                                          const gchar* nick,
                                          const gchar* blurb,
                                          GType object_type,
                                          GParamFlags flags);
void tootle_value_set_html_utils (GValue* value,
                                  gpointer v_object);
void tootle_value_take_html_utils (GValue* value,
                                   gpointer v_object);
gpointer tootle_value_get_html_utils (const GValue* value);
GType tootle_html_utils_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (TootleHtmlUtils, tootle_html_utils_unref)
#define TOOTLE_HTML_UTILS_FALLBACK_TEXT _ ("[ There was an error parsing this text :c ]")
gchar* tootle_html_utils_remove_tags (const gchar* content);
gchar* tootle_html_utils_simplify (const gchar* str);
gchar* tootle_widgets_rich_label_restore_entities (const gchar* content);
gchar* tootle_html_utils_uri_encode (const gchar* str);
TootleHtmlUtils* tootle_html_utils_new (void);
TootleHtmlUtils* tootle_html_utils_construct (GType object_type);
static void tootle_html_utils_finalize (TootleHtmlUtils * obj);
static GType tootle_html_utils_get_type_once (void);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

gchar*
tootle_html_utils_remove_tags (const gchar* content)
{
	GError* _inner_error0_ = NULL;
	gchar* result = NULL;
	g_return_val_if_fail (content != NULL, NULL);
	{
		gchar* fixed_paragraphs = NULL;
		gchar* _tmp0_;
		GRegex* all_tags = NULL;
		GRegex* _tmp1_;
		gchar* _tmp2_ = NULL;
		GRegex* _tmp3_;
		const gchar* _tmp4_;
		gchar* _tmp5_;
		gchar* _tmp6_;
		_tmp0_ = tootle_html_utils_simplify (content);
		fixed_paragraphs = _tmp0_;
		_tmp1_ = g_regex_new ("<(.|\n)*?>", G_REGEX_CASELESS, 0, &_inner_error0_);
		all_tags = _tmp1_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_free0 (fixed_paragraphs);
			goto __catch0_g_error;
		}
		_tmp3_ = all_tags;
		_tmp4_ = fixed_paragraphs;
		_tmp5_ = g_regex_replace (_tmp3_, _tmp4_, (gssize) -1, 0, "", 0, &_inner_error0_);
		_tmp2_ = _tmp5_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_regex_unref0 (all_tags);
			_g_free0 (fixed_paragraphs);
			goto __catch0_g_error;
		}
		_tmp6_ = tootle_widgets_rich_label_restore_entities (_tmp2_);
		result = _tmp6_;
		_g_free0 (_tmp2_);
		_g_regex_unref0 (all_tags);
		_g_free0 (fixed_paragraphs);
		return result;
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp7_;
		const gchar* _tmp8_;
		gchar* _tmp9_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp7_ = e;
		_tmp8_ = _tmp7_->message;
		g_warning ("Html.vala:14: %s", _tmp8_);
		_tmp9_ = g_strdup (TOOTLE_HTML_UTILS_FALLBACK_TEXT);
		result = _tmp9_;
		_g_error_free0 (e);
		return result;
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return NULL;
}

static gchar*
string_replace (const gchar* self,
                const gchar* old,
                const gchar* replacement)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError* _inner_error0_ = NULL;
	gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	if ((*((gchar*) self)) == '\0') {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = (*((gchar*) old)) == '\0';
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = g_strcmp0 (old, replacement) == 0;
	}
	if (_tmp0_) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup (self);
		result = _tmp2_;
		return result;
	}
	{
		GRegex* regex = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GRegex* _tmp5_;
		GRegex* _tmp6_;
		gchar* _tmp7_ = NULL;
		GRegex* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp3_ = g_regex_escape_string (old, -1);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_regex_new (_tmp4_, 0, 0, &_inner_error0_);
		_tmp6_ = _tmp5_;
		_g_free0 (_tmp4_);
		regex = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp8_ = regex;
		_tmp9_ = g_regex_replace_literal (_tmp8_, self, (gssize) -1, 0, replacement, 0, &_inner_error0_);
		_tmp7_ = _tmp9_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_regex_unref0 (regex);
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp10_ = _tmp7_;
		_tmp7_ = NULL;
		result = _tmp10_;
		_g_free0 (_tmp7_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally0;
	__catch0_g_regex_error:
	{
		g_clear_error (&_inner_error0_);
		g_assert_not_reached ();
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return NULL;
}

static gchar*
string_slice (const gchar* self,
              glong start,
              glong end)
{
	glong string_length = 0L;
	gint _tmp0_;
	gint _tmp1_;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gchar* _tmp4_;
	gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	string_length = (glong) _tmp1_;
	if (start < ((glong) 0)) {
		start = string_length + start;
	}
	if (end < ((glong) 0)) {
		end = string_length + end;
	}
	if (start >= ((glong) 0)) {
		_tmp2_ = start <= string_length;
	} else {
		_tmp2_ = FALSE;
	}
	g_return_val_if_fail (_tmp2_, NULL);
	if (end >= ((glong) 0)) {
		_tmp3_ = end <= string_length;
	} else {
		_tmp3_ = FALSE;
	}
	g_return_val_if_fail (_tmp3_, NULL);
	g_return_val_if_fail (start <= end, NULL);
	_tmp4_ = g_strndup (((gchar*) self) + start, (gsize) (end - start));
	result = _tmp4_;
	return result;
}

static gint
string_last_index_of (const gchar* self,
                      const gchar* needle,
                      gint start_index)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gint result = 0;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (needle != NULL, 0);
	_tmp0_ = g_strrstr (((gchar*) self) + start_index, (gchar*) needle);
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	if (_tmp1_ != NULL) {
		gchar* _tmp2_;
		_tmp2_ = _result_;
		result = (gint) (_tmp2_ - ((gchar*) self));
		return result;
	} else {
		result = -1;
		return result;
	}
}

static const gchar*
string_to_string (const gchar* self)
{
	const gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	result = self;
	return result;
}

gchar*
tootle_html_utils_simplify (const gchar* str)
{
	GError* _inner_error0_ = NULL;
	gchar* result = NULL;
	g_return_val_if_fail (str != NULL, NULL);
	{
		gchar* divided = NULL;
		gchar* _tmp0_;
		gchar* _tmp1_;
		gchar* _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp4_;
		gchar* _tmp5_;
		gchar* _tmp6_;
		gchar* _tmp7_;
		gchar* _tmp8_;
		gchar* _tmp9_;
		GRegex* html_params = NULL;
		GRegex* _tmp10_;
		gchar* simplified = NULL;
		GRegex* _tmp11_;
		const gchar* _tmp12_;
		gchar* _tmp13_;
		_tmp0_ = string_replace (str, "<br>", "\n");
		_tmp1_ = _tmp0_;
		_tmp2_ = string_replace (_tmp1_, "</br>", "");
		_tmp3_ = _tmp2_;
		_tmp4_ = string_replace (_tmp3_, "<br />", "\n");
		_tmp5_ = _tmp4_;
		_tmp6_ = string_replace (_tmp5_, "<p>", "");
		_tmp7_ = _tmp6_;
		_tmp8_ = string_replace (_tmp7_, "</p>", "\n\n");
		_tmp9_ = _tmp8_;
		_g_free0 (_tmp7_);
		_g_free0 (_tmp5_);
		_g_free0 (_tmp3_);
		_g_free0 (_tmp1_);
		divided = _tmp9_;
		_tmp10_ = g_regex_new ("(class|target|rel)=\"(.|\n)*?\"", G_REGEX_CASELESS, 0, &_inner_error0_);
		html_params = _tmp10_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_free0 (divided);
			goto __catch0_g_error;
		}
		_tmp11_ = html_params;
		_tmp12_ = divided;
		_tmp13_ = g_regex_replace (_tmp11_, _tmp12_, (gssize) -1, 0, "", 0, &_inner_error0_);
		simplified = _tmp13_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_regex_unref0 (html_params);
			_g_free0 (divided);
			goto __catch0_g_error;
		}
		while (TRUE) {
			const gchar* _tmp14_;
			const gchar* _tmp15_;
			const gchar* _tmp16_;
			gchar* _tmp17_;
			_tmp14_ = simplified;
			if (!g_str_has_suffix (_tmp14_, "\n")) {
				break;
			}
			_tmp15_ = simplified;
			_tmp16_ = simplified;
			_tmp17_ = string_slice (_tmp15_, (glong) 0, (glong) string_last_index_of (_tmp16_, "\n", 0));
			_g_free0 (simplified);
			simplified = _tmp17_;
		}
		result = simplified;
		_g_regex_unref0 (html_params);
		_g_free0 (divided);
		return result;
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp18_;
		GError* _tmp19_;
		const gchar* _tmp20_;
		const gchar* _tmp21_;
		gchar* _tmp22_;
		gchar* _tmp23_;
		gchar* _tmp24_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp18_ = string_to_string (str);
		_tmp19_ = e;
		_tmp20_ = _tmp19_->message;
		_tmp21_ = string_to_string (_tmp20_);
		_tmp22_ = g_strconcat ("Can't simplify string \"", _tmp18_, "\":\n", _tmp21_, NULL);
		_tmp23_ = _tmp22_;
		g_warning ("Html.vala:39: %s", _tmp23_);
		_g_free0 (_tmp23_);
		_tmp24_ = tootle_html_utils_remove_tags (str);
		result = _tmp24_;
		_g_error_free0 (e);
		return result;
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return NULL;
}

gchar*
tootle_html_utils_uri_encode (const gchar* str)
{
	gchar* restored = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* result = NULL;
	g_return_val_if_fail (str != NULL, NULL);
	_tmp0_ = tootle_widgets_rich_label_restore_entities (str);
	restored = _tmp0_;
	_tmp1_ = soup_uri_encode (restored, ";&+");
	result = _tmp1_;
	_g_free0 (restored);
	return result;
}

TootleHtmlUtils*
tootle_html_utils_construct (GType object_type)
{
	TootleHtmlUtils* self = NULL;
	self = (TootleHtmlUtils*) g_type_create_instance (object_type);
	return self;
}

TootleHtmlUtils*
tootle_html_utils_new (void)
{
	return tootle_html_utils_construct (TOOTLE_TYPE_HTML_UTILS);
}

static void
tootle_value_html_utils_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
tootle_value_html_utils_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		tootle_html_utils_unref (value->data[0].v_pointer);
	}
}

static void
tootle_value_html_utils_copy_value (const GValue* src_value,
                                    GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = tootle_html_utils_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
tootle_value_html_utils_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
tootle_value_html_utils_collect_value (GValue* value,
                                       guint n_collect_values,
                                       GTypeCValue* collect_values,
                                       guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		TootleHtmlUtils * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = tootle_html_utils_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
tootle_value_html_utils_lcopy_value (const GValue* value,
                                     guint n_collect_values,
                                     GTypeCValue* collect_values,
                                     guint collect_flags)
{
	TootleHtmlUtils ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = tootle_html_utils_ref (value->data[0].v_pointer);
	}
	return NULL;
}

GParamSpec*
tootle_param_spec_html_utils (const gchar* name,
                              const gchar* nick,
                              const gchar* blurb,
                              GType object_type,
                              GParamFlags flags)
{
	TootleParamSpecHtmlUtils* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TOOTLE_TYPE_HTML_UTILS), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

gpointer
tootle_value_get_html_utils (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TOOTLE_TYPE_HTML_UTILS), NULL);
	return value->data[0].v_pointer;
}

void
tootle_value_set_html_utils (GValue* value,
                             gpointer v_object)
{
	TootleHtmlUtils * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TOOTLE_TYPE_HTML_UTILS));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TOOTLE_TYPE_HTML_UTILS));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		tootle_html_utils_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		tootle_html_utils_unref (old);
	}
}

void
tootle_value_take_html_utils (GValue* value,
                              gpointer v_object)
{
	TootleHtmlUtils * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TOOTLE_TYPE_HTML_UTILS));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TOOTLE_TYPE_HTML_UTILS));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		tootle_html_utils_unref (old);
	}
}

static void
tootle_html_utils_class_init (TootleHtmlUtilsClass * klass,
                              gpointer klass_data)
{
	tootle_html_utils_parent_class = g_type_class_peek_parent (klass);
	((TootleHtmlUtilsClass *) klass)->finalize = tootle_html_utils_finalize;
}

static void
tootle_html_utils_instance_init (TootleHtmlUtils * self,
                                 gpointer klass)
{
	self->ref_count = 1;
}

static void
tootle_html_utils_finalize (TootleHtmlUtils * obj)
{
	TootleHtmlUtils * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TOOTLE_TYPE_HTML_UTILS, TootleHtmlUtils);
	g_signal_handlers_destroy (self);
}

static GType
tootle_html_utils_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { tootle_value_html_utils_init, tootle_value_html_utils_free_value, tootle_value_html_utils_copy_value, tootle_value_html_utils_peek_pointer, "p", tootle_value_html_utils_collect_value, "p", tootle_value_html_utils_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (TootleHtmlUtilsClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) tootle_html_utils_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TootleHtmlUtils), 0, (GInstanceInitFunc) tootle_html_utils_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType tootle_html_utils_type_id;
	tootle_html_utils_type_id = g_type_register_fundamental (g_type_fundamental_next (), "TootleHtmlUtils", &g_define_type_info, &g_define_type_fundamental_info, 0);
	return tootle_html_utils_type_id;
}

GType
tootle_html_utils_get_type (void)
{
	static volatile gsize tootle_html_utils_type_id__volatile = 0;
	if (g_once_init_enter (&tootle_html_utils_type_id__volatile)) {
		GType tootle_html_utils_type_id;
		tootle_html_utils_type_id = tootle_html_utils_get_type_once ();
		g_once_init_leave (&tootle_html_utils_type_id__volatile, tootle_html_utils_type_id);
	}
	return tootle_html_utils_type_id__volatile;
}

gpointer
tootle_html_utils_ref (gpointer instance)
{
	TootleHtmlUtils * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

void
tootle_html_utils_unref (gpointer instance)
{
	TootleHtmlUtils * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		TOOTLE_HTML_UTILS_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

