/*
 * Decompiled with CFR 0.152.
 */
package com.icl.saxon.style;

import com.icl.saxon.Context;
import com.icl.saxon.expr.Expression;
import com.icl.saxon.expr.LastPositionFinder;
import com.icl.saxon.expr.LookaheadEnumerator;
import com.icl.saxon.om.NodeEnumeration;
import com.icl.saxon.style.GroupActivation;
import com.icl.saxon.style.SAXONItem;
import com.icl.saxon.style.StandardNames;
import com.icl.saxon.style.XSLForEach;
import com.icl.saxon.tree.AttributeCollection;
import com.icl.saxon.tree.NodeImpl;
import java.util.Stack;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;

public class SAXONGroup
extends XSLForEach {
    Expression groupBy = null;

    @Override
    public boolean isInstruction() {
        return true;
    }

    @Override
    public void prepareAttributes() throws TransformerConfigurationException {
        StandardNames standardNames = this.getStandardNames();
        AttributeCollection attributeCollection = this.getAttributeList();
        String string = null;
        String string2 = null;
        for (int i = 0; i < attributeCollection.getLength(); ++i) {
            int n = attributeCollection.getNameCode(i);
            int n2 = n & 0xFFFFF;
            if (n2 == standardNames.SELECT) {
                string = attributeCollection.getValue(i);
                continue;
            }
            if (n2 == standardNames.GROUP_BY) {
                string2 = attributeCollection.getValue(i);
                continue;
            }
            this.checkUnknownAttribute(n);
        }
        if (string == null) {
            this.reportAbsence("select");
        } else {
            this.select = this.makeExpression(string);
        }
        if (string2 == null) {
            this.reportAbsence("group-by");
        } else {
            this.groupBy = this.makeExpression(string2);
        }
    }

    @Override
    public void validate() throws TransformerConfigurationException {
        this.checkWithinTemplate();
        this.select = this.handleSortKeys(this.select);
        SAXONItem sAXONItem = null;
        for (NodeImpl nodeImpl = this; nodeImpl != null; nodeImpl = nodeImpl.getNextInDocument(this)) {
            if (!(nodeImpl instanceof SAXONItem)) continue;
            sAXONItem = (SAXONItem)nodeImpl;
            break;
        }
        if (sAXONItem == null) {
            this.compileError("saxon:group must have a nested saxon:item element");
        }
    }

    @Override
    public void process(Context context) throws TransformerException {
        NodeEnumeration nodeEnumeration = this.select.enumerate(context, false);
        if (!(nodeEnumeration instanceof LastPositionFinder)) {
            nodeEnumeration = new LookaheadEnumerator(nodeEnumeration);
        }
        Context context2 = context.newContext();
        context2.setLastPositionFinder((LastPositionFinder)((Object)nodeEnumeration));
        GroupActivation groupActivation = new GroupActivation(this, this.groupBy, nodeEnumeration, context2);
        Stack stack = context2.getGroupActivationStack();
        stack.push(groupActivation);
        while (groupActivation.hasMoreElements()) {
            groupActivation.nextElement();
            this.processChildren(context2);
            context.setReturnValue(context2.getReturnValue());
        }
        stack.pop();
    }
}

