/*
 * Decompiled with CFR 0.152.
 */
package com.icl.saxon.functions;

import com.icl.saxon.Context;
import com.icl.saxon.expr.Expression;
import com.icl.saxon.expr.Function;
import com.icl.saxon.expr.StringValue;
import com.icl.saxon.expr.Value;
import com.icl.saxon.expr.XPathException;

public class Concat
extends Function {
    @Override
    public String getName() {
        return "concat";
    }

    @Override
    public int getDataType() {
        return 3;
    }

    @Override
    public Expression simplify() throws XPathException {
        int n = this.checkArgumentCount(2, Integer.MAX_VALUE);
        boolean bl = true;
        for (int i = 0; i < n; ++i) {
            this.argument[i] = this.argument[i].simplify();
            if (this.argument[i] instanceof Value) continue;
            bl = false;
        }
        if (bl) {
            return this.evaluate(null);
        }
        return this;
    }

    @Override
    public String evaluateAsString(Context context) throws XPathException {
        int n = this.getNumberOfArguments();
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < n; ++i) {
            stringBuffer.append(this.argument[i].evaluateAsString(context));
        }
        return stringBuffer.toString();
    }

    @Override
    public Value evaluate(Context context) throws XPathException {
        return new StringValue(this.evaluateAsString(context));
    }

    @Override
    public int getDependencies() {
        int n = this.getNumberOfArguments();
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            n2 |= this.argument[i].getDependencies();
        }
        return n2;
    }

    @Override
    public Expression reduce(int n, Context context) throws XPathException {
        Concat concat = new Concat();
        int n2 = this.getNumberOfArguments();
        for (int i = 0; i < n2; ++i) {
            concat.addArgument(this.argument[i].reduce(n, context));
        }
        concat.setStaticContext(this.getStaticContext());
        return concat.simplify();
    }
}

