/*
 * Decompiled with CFR 0.152.
 */
package com.icl.saxon.expr;

import com.icl.saxon.Context;
import com.icl.saxon.expr.Expression;
import com.icl.saxon.expr.NodeSetExpression;
import com.icl.saxon.expr.SortKeyEnumeration;
import com.icl.saxon.expr.XPathException;
import com.icl.saxon.om.NodeEnumeration;
import com.icl.saxon.sort.SortKeyDefinition;

public class SortedSelection
extends NodeSetExpression {
    private Expression selection;
    private SortKeyDefinition[] sortkeys;
    private int numberOfSortKeys;

    public SortedSelection(Expression expression, int n) {
        this.selection = expression;
        this.sortkeys = new SortKeyDefinition[n];
        this.numberOfSortKeys = n;
    }

    public void setSortKey(SortKeyDefinition sortKeyDefinition, int n) {
        this.sortkeys[n] = sortKeyDefinition;
    }

    @Override
    public Expression simplify() throws XPathException {
        this.selection = this.selection.simplify();
        for (int i = 0; i < this.numberOfSortKeys; ++i) {
            SortKeyDefinition sortKeyDefinition = this.sortkeys[i];
            sortKeyDefinition.setSortKey(sortKeyDefinition.getSortKey().simplify());
            sortKeyDefinition.setOrder(sortKeyDefinition.getOrder().simplify());
            sortKeyDefinition.setDataType(sortKeyDefinition.getDataType().simplify());
            sortKeyDefinition.setCaseOrder(sortKeyDefinition.getCaseOrder().simplify());
            sortKeyDefinition.setLanguage(sortKeyDefinition.getLanguage().simplify());
        }
        return this;
    }

    @Override
    public int getDependencies() {
        int n = this.selection.getDependencies();
        for (int i = 0; i < this.sortkeys.length; ++i) {
            SortKeyDefinition sortKeyDefinition = this.sortkeys[i];
            n |= sortKeyDefinition.getSortKey().getDependencies() & 0x41;
            n |= sortKeyDefinition.getOrder().getDependencies();
            n |= sortKeyDefinition.getDataType().getDependencies();
            n |= sortKeyDefinition.getCaseOrder().getDependencies();
            n |= sortKeyDefinition.getLanguage().getDependencies();
        }
        return n;
    }

    @Override
    public Expression reduce(int n, Context context) throws XPathException {
        if ((n & this.getDependencies()) != 0) {
            Expression expression = this.selection.reduce(n, context);
            SortedSelection sortedSelection = new SortedSelection(expression, this.numberOfSortKeys);
            sortedSelection.setStaticContext(this.getStaticContext());
            for (int i = 0; i < this.numberOfSortKeys; ++i) {
                SortKeyDefinition sortKeyDefinition = this.sortkeys[i];
                SortKeyDefinition sortKeyDefinition2 = new SortKeyDefinition();
                sortKeyDefinition2.setStaticContext(this.getStaticContext());
                sortKeyDefinition2.setSortKey(sortKeyDefinition.getSortKey().reduce(n & 0x41, context));
                sortKeyDefinition2.setOrder(sortKeyDefinition.getOrder().reduce(n, context));
                sortKeyDefinition2.setDataType(sortKeyDefinition.getDataType().reduce(n, context));
                sortKeyDefinition2.setCaseOrder(sortKeyDefinition.getCaseOrder().reduce(n, context));
                sortKeyDefinition2.setLanguage(sortKeyDefinition.getLanguage().reduce(n, context));
                sortedSelection.setSortKey(sortKeyDefinition2, i);
            }
            return sortedSelection.simplify();
        }
        return this;
    }

    @Override
    public NodeEnumeration enumerate(Context context, boolean bl) throws XPathException {
        if (bl) {
            throw new XPathException("SortedSelection doesn't provide nodes in document order");
        }
        NodeEnumeration nodeEnumeration = this.selection.enumerate(context, true);
        return new SortKeyEnumeration(context, nodeEnumeration, this.sortkeys);
    }

    @Override
    public void display(int n) {
        System.err.println(SortedSelection.indent(n) + "sorted");
        this.selection.display(n + 1);
    }
}

