/*
 * Decompiled with CFR 0.152.
 */
package com.icl.saxon.expr;

import com.icl.saxon.Context;
import com.icl.saxon.expr.BooleanValue;
import com.icl.saxon.expr.Expression;
import com.icl.saxon.expr.NodeSetExpression;
import com.icl.saxon.expr.NodeSetValue;
import com.icl.saxon.expr.SingletonComparison;
import com.icl.saxon.expr.SingletonExpression;
import com.icl.saxon.expr.Tokenizer;
import com.icl.saxon.expr.Value;
import com.icl.saxon.expr.XPathException;
import com.icl.saxon.om.NodeEnumeration;
import com.icl.saxon.om.NodeInfo;

public class NodeSetComparison
extends Expression {
    NodeSetExpression nodeset;
    int operator;
    Value value;

    public NodeSetComparison(NodeSetExpression nodeSetExpression, int n, Value value) {
        this.nodeset = nodeSetExpression;
        this.operator = n;
        this.value = value;
    }

    @Override
    public Expression simplify() {
        return this;
    }

    @Override
    public Value evaluate(Context context) throws XPathException {
        return new BooleanValue(this.evaluateAsBoolean(context));
    }

    @Override
    public boolean evaluateAsBoolean(Context context) throws XPathException {
        NodeEnumeration nodeEnumeration = this.nodeset.enumerate(context, false);
        switch (this.operator) {
            case 11: {
                if (this.value.getDataType() == 2) {
                    double d = this.value.asNumber();
                    while (nodeEnumeration.hasMoreElements()) {
                        NodeInfo nodeInfo = nodeEnumeration.nextElement();
                        if (Value.stringToNumber(nodeInfo.getStringValue()) != d) continue;
                        return true;
                    }
                    return false;
                }
                String string = this.value.asString();
                while (nodeEnumeration.hasMoreElements()) {
                    NodeInfo nodeInfo = nodeEnumeration.nextElement();
                    if (!nodeInfo.getStringValue().equals(string)) continue;
                    return true;
                }
                return false;
            }
            case 34: {
                if (this.value.getDataType() == 2) {
                    double d = this.value.asNumber();
                    while (nodeEnumeration.hasMoreElements()) {
                        NodeInfo nodeInfo = nodeEnumeration.nextElement();
                        if (Value.stringToNumber(nodeInfo.getStringValue()) == d) continue;
                        return true;
                    }
                    return false;
                }
                String string = this.value.asString();
                while (nodeEnumeration.hasMoreElements()) {
                    NodeInfo nodeInfo = nodeEnumeration.nextElement();
                    if (nodeInfo.getStringValue().equals(string)) continue;
                    return true;
                }
                return false;
            }
            case 24: {
                double d = this.value.asNumber();
                while (nodeEnumeration.hasMoreElements()) {
                    NodeInfo nodeInfo = nodeEnumeration.nextElement();
                    if (!(Value.stringToNumber(nodeInfo.getStringValue()) <= d)) continue;
                    return true;
                }
                return false;
            }
            case 22: {
                double d = this.value.asNumber();
                while (nodeEnumeration.hasMoreElements()) {
                    NodeInfo nodeInfo = nodeEnumeration.nextElement();
                    if (!(Value.stringToNumber(nodeInfo.getStringValue()) < d)) continue;
                    return true;
                }
                return false;
            }
            case 23: {
                double d = this.value.asNumber();
                while (nodeEnumeration.hasMoreElements()) {
                    NodeInfo nodeInfo = nodeEnumeration.nextElement();
                    if (!(Value.stringToNumber(nodeInfo.getStringValue()) >= d)) continue;
                    return true;
                }
                return false;
            }
            case 21: {
                double d = this.value.asNumber();
                while (nodeEnumeration.hasMoreElements()) {
                    NodeInfo nodeInfo = nodeEnumeration.nextElement();
                    if (!(Value.stringToNumber(nodeInfo.getStringValue()) > d)) continue;
                    return true;
                }
                return false;
            }
        }
        return false;
    }

    @Override
    public int getDataType() {
        return 1;
    }

    @Override
    public int getDependencies() {
        return this.nodeset.getDependencies();
    }

    @Override
    public Expression reduce(int n, Context context) throws XPathException {
        if ((this.nodeset.getDependencies() & n) != 0) {
            Expression expression = this.nodeset.reduce(n, context);
            if (expression instanceof SingletonExpression) {
                expression = new SingletonComparison((SingletonExpression)expression, this.operator, this.value);
                expression.setStaticContext(this.getStaticContext());
                return expression.simplify();
            }
            if (expression instanceof NodeSetExpression) {
                expression = new NodeSetComparison((NodeSetExpression)expression, this.operator, this.value);
                expression.setStaticContext(this.getStaticContext());
                return expression.simplify();
            }
            if (expression instanceof NodeSetValue) {
                return new BooleanValue(((NodeSetValue)expression).compare(this.operator, this.value));
            }
            throw new XPathException("Failed to reduce NodeSetComparison: returned " + expression.getClass());
        }
        return this;
    }

    @Override
    public void display(int n) {
        System.err.println(NodeSetComparison.indent(n) + Tokenizer.tokens[this.operator]);
        this.nodeset.display(n + 1);
        this.value.display(n + 1);
    }
}

