/*
 * Decompiled with CFR 0.152.
 */
package com.icl.saxon;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import org.w3c.dom.Attr;
import org.w3c.dom.CharacterData;
import org.w3c.dom.Comment;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ProcessingInstruction;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.DocumentHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.AttributesImpl;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.NamespaceSupport;

public class DOMDriver
implements Locator,
XMLReader {
    protected ContentHandler contentHandler = new DefaultHandler();
    private LexicalHandler lexicalHandler = null;
    private NamespaceSupport nsSupport = new NamespaceSupport();
    private AttributesImpl attlist = new AttributesImpl();
    private String[] parts = new String[3];
    private String[] elparts = new String[3];
    private Hashtable nsDeclarations = new Hashtable();
    protected Node root = null;
    protected String systemId;
    static final String FEATURE = "http://xml.org/sax/features/";
    static final String HANDLER = "http://xml.org/sax/properties/";

    @Override
    public void setContentHandler(ContentHandler contentHandler) {
        this.contentHandler = contentHandler;
        if (contentHandler instanceof LexicalHandler) {
            this.lexicalHandler = (LexicalHandler)((Object)contentHandler);
        }
    }

    @Override
    public ContentHandler getContentHandler() {
        return this.contentHandler;
    }

    public void setLocale(Locale locale) throws SAXException {
    }

    @Override
    public EntityResolver getEntityResolver() {
        return null;
    }

    @Override
    public void setEntityResolver(EntityResolver entityResolver) {
    }

    @Override
    public DTDHandler getDTDHandler() {
        return null;
    }

    @Override
    public void setDTDHandler(DTDHandler dTDHandler) {
    }

    public void setDocumentHandler(DocumentHandler documentHandler) {
    }

    @Override
    public void setErrorHandler(ErrorHandler errorHandler) {
    }

    @Override
    public ErrorHandler getErrorHandler() {
        return null;
    }

    public void setStartNode(Node node) {
        this.root = node;
    }

    @Override
    public void parse(InputSource inputSource) throws SAXException {
        this.parse();
    }

    @Override
    public void parse(String string) throws SAXException {
        this.parse();
    }

    public void parse() throws SAXException {
        if (this.root == null) {
            throw new SAXException("DOMDriver: no start node defined");
        }
        if (this.contentHandler == null) {
            throw new SAXException("DOMDriver: no content handler defined");
        }
        this.contentHandler.setDocumentLocator(this);
        this.contentHandler.startDocument();
        if (this.root.getNodeType() == 1) {
            this.sendElement((Element)this.root);
        } else {
            this.walkNode(this.root);
        }
        this.contentHandler.endDocument();
    }

    private void sendElement(Element element) throws SAXException {
        Element element2 = element;
        NamedNodeMap namedNodeMap = this.gatherNamespaces(element2, false);
        while (true) {
            this.gatherNamespaces(element2, true);
            Node node = element2.getParentNode();
            if (node.getNodeType() != 1) break;
            element2 = (Element)node;
        }
        this.outputElement(element, namedNodeMap);
    }

    private void walkNode(Node node) throws SAXException {
        if (node.hasChildNodes()) {
            NodeList nodeList = node.getChildNodes();
            block13: for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node2 = nodeList.item(i);
                switch (node2.getNodeType()) {
                    case 9: {
                        continue block13;
                    }
                    case 1: {
                        String string;
                        Object object;
                        Object object2;
                        String string2;
                        Object object3;
                        int n;
                        String[] stringArray;
                        Object object4;
                        Element element = (Element)node2;
                        this.nsSupport.pushContext();
                        this.attlist.clear();
                        this.nsDeclarations.clear();
                        try {
                            object4 = element.getPrefix();
                            stringArray = element.getNamespaceURI();
                            if (this.nsDeclarations.get(object4) == null) {
                                this.nsSupport.declarePrefix((String)object4, (String)stringArray);
                                this.contentHandler.startPrefixMapping((String)object4, (String)stringArray);
                                this.nsDeclarations.put(object4, stringArray);
                            }
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                        object4 = element.getAttributes();
                        for (n = 0; n < object4.getLength(); ++n) {
                            object3 = (Attr)object4.item(n);
                            string2 = object3.getName();
                            if (string2.equals("xmlns")) {
                                if (this.nsDeclarations.get("") != null) continue;
                                object2 = object3.getValue();
                                this.nsSupport.declarePrefix("", (String)object2);
                                this.contentHandler.startPrefixMapping("", (String)object2);
                                this.nsDeclarations.put("", object2);
                                continue;
                            }
                            if (string2.startsWith("xmlns:")) {
                                object2 = string2.substring(6);
                                if (this.nsDeclarations.get(object2) != null) continue;
                                object = object3.getValue();
                                this.nsSupport.declarePrefix((String)object2, (String)object);
                                this.contentHandler.startPrefixMapping((String)object2, (String)object);
                                this.nsDeclarations.put(object2, object);
                                continue;
                            }
                            if (string2.indexOf(58) < 0) continue;
                            try {
                                object2 = object3.getPrefix();
                                object = object3.getNamespaceURI();
                                if (this.nsDeclarations.get(object2) != null) continue;
                                this.nsSupport.declarePrefix((String)object2, (String)object);
                                this.contentHandler.startPrefixMapping((String)object2, (String)object);
                                this.nsDeclarations.put(object2, object);
                                continue;
                            }
                            catch (Throwable throwable) {
                                // empty catch block
                            }
                        }
                        for (n = 0; n < object4.getLength(); ++n) {
                            object3 = (Attr)object4.item(n);
                            string2 = object3.getName();
                            if (string2.equals("xmlns") || string2.startsWith("xmlns:")) continue;
                            object2 = this.nsSupport.processName(string2, this.parts, true);
                            if (object2 == null) {
                                throw new SAXException("Undeclared namespace in " + string2);
                            }
                            this.attlist.addAttribute(object2[0], object2[1], object2[2], "CDATA", object3.getValue());
                        }
                        stringArray = this.nsSupport.processName(element.getTagName(), this.elparts, false);
                        if (stringArray == null) {
                            throw new SAXException("Undeclared namespace in " + element.getTagName());
                        }
                        object3 = stringArray[0];
                        string2 = stringArray[1];
                        object2 = stringArray[2];
                        this.contentHandler.startElement((String)object3, string2, (String)object2, this.attlist);
                        this.walkNode(element);
                        this.contentHandler.endElement((String)object3, string2, (String)object2);
                        object = this.nsSupport.getDeclaredPrefixes();
                        while (object.hasMoreElements()) {
                            string = (String)object.nextElement();
                            this.contentHandler.endPrefixMapping(string);
                        }
                        this.nsSupport.popContext();
                        continue block13;
                    }
                    case 2: {
                        continue block13;
                    }
                    case 7: {
                        this.contentHandler.processingInstruction(((ProcessingInstruction)node2).getTarget(), ((ProcessingInstruction)node2).getData());
                        continue block13;
                    }
                    case 8: {
                        String string;
                        if (this.lexicalHandler == null || (string = ((Comment)node2).getData()) == null) continue block13;
                        this.lexicalHandler.comment(string.toCharArray(), 0, string.length());
                        continue block13;
                    }
                    case 3: 
                    case 4: {
                        String string = ((CharacterData)node2).getData();
                        if (string == null) continue block13;
                        this.contentHandler.characters(string.toCharArray(), 0, string.length());
                        continue block13;
                    }
                    case 5: {
                        this.walkNode(node2);
                        continue block13;
                    }
                }
            }
        }
    }

    private void outputElement(Element element, NamedNodeMap namedNodeMap) throws SAXException {
        Object object;
        String[] stringArray = this.nsSupport.processName(element.getTagName(), this.elparts, false);
        if (stringArray == null) {
            throw new SAXException("Undeclared namespace in " + element.getTagName());
        }
        String string = stringArray[0];
        String string2 = stringArray[1];
        String string3 = stringArray[2];
        for (int i = 0; i < namedNodeMap.getLength(); ++i) {
            object = (Attr)namedNodeMap.item(i);
            String string4 = object.getName();
            if (string4.equals("xmlns") || string4.startsWith("xmlns:")) continue;
            String[] stringArray2 = this.nsSupport.processName(string4, this.parts, true);
            if (stringArray2 == null) {
                throw new SAXException("Undeclared namespace in " + string4);
            }
            this.attlist.addAttribute(stringArray2[0], stringArray2[1], stringArray2[2], "CDATA", object.getValue());
        }
        this.contentHandler.startElement(string, string2, string3, this.attlist);
        this.walkNode(element);
        this.contentHandler.endElement(string, string2, string3);
        Enumeration<String> enumeration = this.nsSupport.getDeclaredPrefixes();
        while (enumeration.hasMoreElements()) {
            object = enumeration.nextElement();
            this.contentHandler.endPrefixMapping((String)object);
        }
    }

    private NamedNodeMap gatherNamespaces(Element element, boolean bl) {
        Object object;
        if (!bl) {
            this.nsSupport.pushContext();
            this.attlist.clear();
            this.nsDeclarations.clear();
        }
        try {
            object = element.getPrefix();
            String string = element.getNamespaceURI();
            if (object == null) {
                object = "";
            }
            if (string == null) {
                string = "";
            }
            if (this.nsDeclarations.get(object) == null) {
                this.nsSupport.declarePrefix((String)object, string);
                this.nsDeclarations.put(object, string);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        object = element.getAttributes();
        for (int i = 0; i < object.getLength(); ++i) {
            String string;
            String string2;
            Attr attr = (Attr)object.item(i);
            String string3 = attr.getName();
            if (string3.equals("xmlns")) {
                if (this.nsDeclarations.get("") != null) continue;
                string2 = attr.getValue();
                this.nsSupport.declarePrefix("", string2);
                this.nsDeclarations.put("", string2);
                continue;
            }
            if (string3.startsWith("xmlns:")) {
                string2 = string3.substring(6);
                if (this.nsDeclarations.get(string2) != null) continue;
                string = attr.getValue();
                this.nsSupport.declarePrefix(string2, string);
                this.nsDeclarations.put(string2, string);
                continue;
            }
            if (string3.indexOf(58) < 0) continue;
            try {
                string2 = attr.getPrefix();
                string = attr.getNamespaceURI();
                if (this.nsDeclarations.get(string2) != null) continue;
                this.nsSupport.declarePrefix(string2, string);
                this.nsDeclarations.put(string2, string);
                continue;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return object;
    }

    public void setSystemId(String string) {
        this.systemId = string;
    }

    @Override
    public String getPublicId() {
        return null;
    }

    @Override
    public String getSystemId() {
        return this.systemId;
    }

    @Override
    public int getLineNumber() {
        return -1;
    }

    @Override
    public int getColumnNumber() {
        return -1;
    }

    @Override
    public boolean getFeature(String string) throws SAXNotRecognizedException {
        if ("http://xml.org/sax/features/validation".equals(string)) {
            return false;
        }
        if ("http://xml.org/sax/features/external-general-entities".equals(string) || "http://xml.org/sax/features/external-parameter-entities".equals(string)) {
            return false;
        }
        if ("http://xml.org/sax/features/namespace-prefixes".equals(string)) {
            return false;
        }
        if ("http://xml.org/sax/features/namespaces".equals(string)) {
            return true;
        }
        if ("http://xml.org/sax/features/string-interning".equals(string)) {
            return false;
        }
        throw new SAXNotRecognizedException(string);
    }

    @Override
    public Object getProperty(String string) throws SAXNotRecognizedException {
        if (string.equals("http://xml.org/sax/properties/lexical-handler")) {
            return this.lexicalHandler;
        }
        throw new SAXNotRecognizedException(string);
    }

    @Override
    public void setFeature(String string, boolean bl) throws SAXNotRecognizedException, SAXNotSupportedException {
        if ("http://xml.org/sax/features/validation".equals(string)) {
            if (bl) {
                throw new SAXNotSupportedException(string + " feature cannot be switched on");
            }
            return;
        }
        if ("http://xml.org/sax/features/external-general-entities".equals(string) || "http://xml.org/sax/features/external-parameter-entities".equals(string)) {
            if (bl) {
                throw new SAXNotSupportedException(string + " feature cannot be switched on");
            }
            return;
        }
        if ("http://xml.org/sax/features/namespace-prefixes".equals(string)) {
            if (bl) {
                throw new SAXNotSupportedException(string + " feature cannot be switched on");
            }
            return;
        }
        if ("http://xml.org/sax/features/namespaces".equals(string)) {
            if (!bl) {
                throw new SAXNotSupportedException(string + " feature cannot be switched off");
            }
            return;
        }
        if ("http://xml.org/sax/features/string-interning".equals(string)) {
            if (bl) {
                throw new SAXNotSupportedException(string + " feature cannot be switched on");
            }
            return;
        }
        throw new SAXNotRecognizedException("Feature not recognized: " + string);
    }

    @Override
    public void setProperty(String string, Object object) throws SAXNotRecognizedException, SAXNotSupportedException {
        if (string.equals("http://xml.org/sax/properties/lexical-handler")) {
            if (!(object instanceof LexicalHandler)) {
                throw new SAXNotSupportedException("Lexical Handler must be instance of org.xml.sax.ext.LexicalHandler");
            }
        } else {
            throw new SAXNotRecognizedException(string);
        }
        this.lexicalHandler = (LexicalHandler)object;
    }
}

