/*
 * Decompiled with CFR 0.152.
 */
package com.icl.saxon;

import com.icl.saxon.Bindery;
import com.icl.saxon.Context;
import com.icl.saxon.DecimalFormatManager;
import com.icl.saxon.KeyManager;
import com.icl.saxon.Loader;
import com.icl.saxon.Mode;
import com.icl.saxon.NodeHandler;
import com.icl.saxon.ParameterSet;
import com.icl.saxon.PreparedStyleSheet;
import com.icl.saxon.PreviewManager;
import com.icl.saxon.RuleManager;
import com.icl.saxon.StandardErrorListener;
import com.icl.saxon.StandardURIResolver;
import com.icl.saxon.TransformerFactoryImpl;
import com.icl.saxon.expr.Expression;
import com.icl.saxon.expr.FunctionProxy;
import com.icl.saxon.expr.LastPositionFinder;
import com.icl.saxon.expr.LookaheadEnumerator;
import com.icl.saxon.expr.SingletonNodeSet;
import com.icl.saxon.expr.StandaloneContext;
import com.icl.saxon.expr.StringValue;
import com.icl.saxon.expr.Value;
import com.icl.saxon.om.Builder;
import com.icl.saxon.om.DocumentInfo;
import com.icl.saxon.om.DocumentPool;
import com.icl.saxon.om.NamePool;
import com.icl.saxon.om.NodeEnumeration;
import com.icl.saxon.om.NodeInfo;
import com.icl.saxon.om.Stripper;
import com.icl.saxon.output.ContentHandlerProxy;
import com.icl.saxon.output.Emitter;
import com.icl.saxon.output.GeneralOutputter;
import com.icl.saxon.output.Outputter;
import com.icl.saxon.output.SaxonOutputKeys;
import com.icl.saxon.output.StringOutputter;
import com.icl.saxon.pattern.AnyNodeTest;
import com.icl.saxon.sort.NodeOrderComparer;
import com.icl.saxon.style.TerminationException;
import com.icl.saxon.style.XSLStyleSheet;
import com.icl.saxon.tinytree.TinyBuilder;
import com.icl.saxon.trace.SaxonEventMulticaster;
import com.icl.saxon.trace.TraceListener;
import com.icl.saxon.tree.TreeBuilder;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.SourceLocator;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.URIResolver;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.sax.TransformerHandler;
import org.w3c.dom.Node;
import org.xml.sax.SAXParseException;

public class Controller
extends Transformer
implements NodeOrderComparer {
    public static final int RECOVER_SILENTLY = 0;
    public static final int RECOVER_WITH_WARNINGS = 1;
    public static final int DO_NOT_RECOVER = 2;
    private TransformerFactoryImpl factory;
    private Bindery bindery;
    private NamePool namePool;
    private DecimalFormatManager decimalFormatManager;
    private Emitter messageEmitter;
    private RuleManager ruleManager;
    private Properties outputProperties;
    private Outputter currentOutputter;
    private ParameterSet parameters;
    private PreparedStyleSheet preparedStyleSheet;
    private TraceListener traceListener;
    private boolean tracingIsSuspended = false;
    private URIResolver standardURIResolver;
    private URIResolver userURIResolver;
    private ErrorListener errorListener;
    private XSLStyleSheet styleSheetElement;
    private int recoveryPolicy = 1;
    private int treeModel = 1;
    private boolean disableStripping = false;
    private DocumentPool sourceDocumentPool;
    private Hashtable userDataTable;
    private boolean lineNumbering;
    private boolean preview;
    private String diagnosticName = null;

    public Controller() {
        this(new TransformerFactoryImpl());
        this.bindery = new Bindery();
    }

    protected Controller(TransformerFactoryImpl transformerFactoryImpl) {
        Integer n;
        Boolean bl;
        this.factory = transformerFactoryImpl;
        this.namePool = NamePool.getDefaultNamePool();
        this.standardURIResolver = new StandardURIResolver(transformerFactoryImpl);
        this.userURIResolver = transformerFactoryImpl.getURIResolver();
        this.errorListener = transformerFactoryImpl.getErrorListener();
        if (this.errorListener instanceof StandardErrorListener) {
            ((StandardErrorListener)this.errorListener).setRecoveryPolicy((Integer)transformerFactoryImpl.getAttribute("http://icl.com/saxon/feature/recoveryPolicy"));
        }
        this.sourceDocumentPool = new DocumentPool();
        this.userDataTable = new Hashtable();
        TraceListener traceListener = (TraceListener)transformerFactoryImpl.getAttribute("http://icl.com/saxon/feature/traceListener");
        if (traceListener != null) {
            this.addTraceListener(traceListener);
        }
        if ((bl = (Boolean)transformerFactoryImpl.getAttribute("http://icl.com/saxon/feature/linenumbering")) != null && bl.booleanValue()) {
            this.setLineNumbering(true);
        }
        if ((n = (Integer)transformerFactoryImpl.getAttribute("http://icl.com/saxon/feature/treeModel")) != null) {
            this.setTreeModel(n);
        }
    }

    @Override
    public void reset() {
        Integer n;
        Boolean bl;
        this.clearParameters();
        this.namePool = NamePool.getDefaultNamePool();
        this.standardURIResolver = new StandardURIResolver(this.factory);
        this.userURIResolver = this.factory.getURIResolver();
        this.currentOutputter = null;
        this.messageEmitter = null;
        this.outputProperties = null;
        this.errorListener = this.factory.getErrorListener();
        if (this.errorListener instanceof StandardErrorListener) {
            ((StandardErrorListener)this.errorListener).setRecoveryPolicy((Integer)this.factory.getAttribute("http://icl.com/saxon/feature/recoveryPolicy"));
        }
        this.userDataTable = new Hashtable();
        TraceListener traceListener = (TraceListener)this.factory.getAttribute("http://icl.com/saxon/feature/traceListener");
        if (traceListener != null) {
            this.addTraceListener(traceListener);
        }
        if ((bl = (Boolean)this.factory.getAttribute("http://icl.com/saxon/feature/linenumbering")) != null && bl.booleanValue()) {
            this.setLineNumbering(true);
        }
        if ((n = (Integer)this.factory.getAttribute("http://icl.com/saxon/feature/treeModel")) != null) {
            this.setTreeModel(n);
        }
    }

    public TransformerFactoryImpl getTransformerFactory() {
        return this.factory;
    }

    public void setDiagnosticName(String string) {
        this.diagnosticName = string;
    }

    public String toString() {
        if (this.diagnosticName == null) {
            return super.toString();
        }
        return this.diagnosticName;
    }

    public void run(NodeInfo nodeInfo) throws TransformerException {
        Context context = this.makeContext(nodeInfo);
        this.applyTemplates(context, new SingletonNodeSet(nodeInfo), this.getRuleManager().getMode(-1), null);
    }

    public void applyTemplates(Context context, Expression expression, Mode mode, ParameterSet parameterSet) throws TransformerException {
        NodeEnumeration nodeEnumeration = expression == null ? context.getCurrentNodeInfo().getEnumeration((byte)3, AnyNodeTest.getInstance()) : expression.enumerate(context, false);
        if (!(nodeEnumeration instanceof LastPositionFinder)) {
            nodeEnumeration = new LookaheadEnumerator(nodeEnumeration);
        }
        int n = 1;
        Context context2 = context.newContext();
        context2.setLastPositionFinder((LastPositionFinder)((Object)nodeEnumeration));
        context2.setMode(mode);
        while (nodeEnumeration.hasMoreElements()) {
            NodeInfo nodeInfo = nodeEnumeration.nextElement();
            context2.setCurrentNode(nodeInfo);
            context2.setContextNode(nodeInfo);
            context2.setPosition(n++);
            NodeHandler nodeHandler = this.ruleManager.getHandler(nodeInfo, mode, context2);
            if (nodeHandler == null) {
                this.defaultAction(nodeInfo, context2);
                continue;
            }
            if (nodeHandler.needsStackFrame()) {
                this.bindery.openStackFrame(parameterSet);
                if (this.isTracing()) {
                    this.traceListener.enterSource(nodeHandler, context2);
                    nodeHandler.start(nodeInfo, context2);
                    this.traceListener.leaveSource(nodeHandler, context2);
                } else {
                    nodeHandler.start(nodeInfo, context2);
                }
                this.bindery.closeStackFrame();
                continue;
            }
            if (this.isTracing()) {
                this.traceListener.enterSource(nodeHandler, context2);
                nodeHandler.start(nodeInfo, context2);
                this.traceListener.leaveSource(nodeHandler, context2);
                continue;
            }
            nodeHandler.start(nodeInfo, context2);
        }
    }

    private void defaultAction(NodeInfo nodeInfo, Context context) throws TransformerException {
        switch (nodeInfo.getNodeType()) {
            case 1: 
            case 9: {
                this.applyTemplates(context, null, context.getMode(), null);
                return;
            }
            case 2: 
            case 3: {
                nodeInfo.copyStringValue(this.getOutputter());
                return;
            }
            case 7: 
            case 8: 
            case 13: {
                return;
            }
        }
    }

    public void applyImports(Context context, Mode mode, int n, int n2, ParameterSet parameterSet) throws TransformerException {
        NodeInfo nodeInfo = context.getCurrentNodeInfo();
        NodeHandler nodeHandler = this.ruleManager.getHandler(nodeInfo, mode, n, n2, context);
        if (nodeHandler == null) {
            this.defaultAction(nodeInfo, context);
        } else {
            this.bindery.openStackFrame(parameterSet);
            nodeHandler.start(nodeInfo, context);
            this.bindery.closeStackFrame();
        }
    }

    @Override
    public int compare(NodeInfo nodeInfo, NodeInfo nodeInfo2) {
        int n;
        if (this.sourceDocumentPool.getNumberOfDocuments() == 1) {
            return nodeInfo.compareOrder(nodeInfo2);
        }
        int n2 = this.sourceDocumentPool.getDocumentNumber(nodeInfo.getDocumentRoot());
        if (n2 == (n = this.sourceDocumentPool.getDocumentNumber(nodeInfo2.getDocumentRoot()))) {
            return nodeInfo.compareOrder(nodeInfo2);
        }
        return n2 - n;
    }

    @Override
    public void setOutputProperties(Properties properties) {
        Enumeration<Object> enumeration = properties.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            this.setOutputProperty(string, (String)properties.get(string));
        }
    }

    @Override
    public Properties getOutputProperties() {
        if (this.outputProperties == null) {
            if (this.preparedStyleSheet == null) {
                return new Properties();
            }
            this.outputProperties = this.preparedStyleSheet.getOutputProperties();
        }
        Properties properties = new Properties();
        Enumeration<Object> enumeration = this.outputProperties.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            properties.put(string, (String)this.outputProperties.get(string));
        }
        return properties;
    }

    @Override
    public void setOutputProperty(String string, String string2) {
        if (this.outputProperties == null) {
            this.outputProperties = this.getOutputProperties();
        }
        if (!SaxonOutputKeys.isValidOutputKey(string)) {
            throw new IllegalArgumentException(string);
        }
        this.outputProperties.put(string, string2);
    }

    @Override
    public String getOutputProperty(String string) {
        if (this.outputProperties == null) {
            this.outputProperties = this.getOutputProperties();
        }
        return this.outputProperties.getProperty(string);
    }

    public void changeOutputDestination(Properties properties, Result result) throws TransformerException {
        GeneralOutputter generalOutputter = new GeneralOutputter(this.namePool);
        generalOutputter.setOutputDestination(properties, result);
        this.currentOutputter = generalOutputter;
    }

    public void changeToTextOutputDestination(StringBuffer stringBuffer) {
        StringOutputter stringOutputter = new StringOutputter(stringBuffer);
        stringOutputter.setErrorListener(this.errorListener);
        this.currentOutputter = stringOutputter;
    }

    public Outputter getOutputter() {
        return this.currentOutputter;
    }

    public void resetOutputDestination(Outputter outputter) throws TransformerException {
        if (this.currentOutputter == null) {
            throw new TransformerException("No outputter has been allocated");
        }
        this.currentOutputter.close();
        this.currentOutputter = outputter;
    }

    public Emitter makeMessageEmitter() throws TransformerException {
        String string = (String)this.factory.getAttribute("http://icl.com/saxon/feature/messageEmitterClass");
        Object object = Loader.getInstance(string);
        if (!(object instanceof Emitter)) {
            throw new TransformerException(string + " is not an Emitter");
        }
        this.messageEmitter = (Emitter)object;
        return this.messageEmitter;
    }

    public void setMessageEmitter(Emitter emitter) {
        this.messageEmitter = emitter;
    }

    public Emitter getMessageEmitter() {
        return this.messageEmitter;
    }

    public void setRecoveryPolicy(int n) {
        this.recoveryPolicy = n;
        if (this.errorListener instanceof StandardErrorListener) {
            ((StandardErrorListener)this.errorListener).setRecoveryPolicy(n);
        }
    }

    public int getRecoveryPolicy() {
        return this.recoveryPolicy;
    }

    @Override
    public void setErrorListener(ErrorListener errorListener) {
        this.errorListener = errorListener;
    }

    @Override
    public ErrorListener getErrorListener() {
        return this.errorListener;
    }

    public void reportRecoverableError(String string, SourceLocator sourceLocator) throws TransformerException {
        if (sourceLocator == null) {
            this.errorListener.warning(new TransformerException(string));
        } else {
            TransformerException transformerException = new TransformerException(string, sourceLocator);
            this.errorListener.warning(transformerException);
        }
    }

    public void reportRecoverableError(TransformerException transformerException) throws TransformerException {
        this.errorListener.warning(transformerException);
    }

    public DocumentPool getDocumentPool() {
        return this.sourceDocumentPool;
    }

    public void clearDocumentPool() {
        this.sourceDocumentPool = new DocumentPool();
    }

    public void setLineNumbering(boolean bl) {
        this.lineNumbering = bl;
    }

    public boolean isLineNumbering() {
        return this.lineNumbering;
    }

    public Context makeContext(NodeInfo nodeInfo) {
        Context context = new Context(this);
        context.setCurrentNode(nodeInfo);
        context.setContextNode(nodeInfo);
        context.setPosition(1);
        context.setLast(1);
        return context;
    }

    public Bindery getBindery() {
        return this.bindery;
    }

    @Override
    public URIResolver getURIResolver() {
        return this.userURIResolver == null ? this.standardURIResolver : this.userURIResolver;
    }

    public URIResolver getStandardURIResolver() {
        return this.standardURIResolver;
    }

    public KeyManager getKeyManager() {
        return this.styleSheetElement.getKeyManager();
    }

    public void setNamePool(NamePool namePool) {
        this.namePool = namePool;
    }

    public NamePool getNamePool() {
        return this.namePool;
    }

    public void setTreeModel(int n) {
        this.treeModel = n;
    }

    public int getTreeModel() {
        return this.treeModel;
    }

    public void disableWhitespaceStripping(boolean bl) {
        this.disableStripping = bl;
    }

    public boolean isWhitespaceStrippingDisabled() {
        return this.disableStripping;
    }

    public Builder makeBuilder() {
        Builder builder = this.treeModel == 1 ? new TinyBuilder() : new TreeBuilder();
        Boolean bl = (Boolean)this.factory.getAttribute("http://icl.com/saxon/feature/timing");
        builder.setTiming(bl == null ? false : bl);
        builder.setNamePool(this.namePool);
        builder.setLineNumbering(this.lineNumbering);
        builder.setErrorListener(this.errorListener);
        Stripper stripper = this.makeStripper(builder);
        return builder;
    }

    public Stripper makeStripper(Builder builder) {
        Stripper stripper = this.styleSheetElement == null ? new Stripper(new Mode()) : this.styleSheetElement.newStripper();
        stripper.setController(this);
        stripper.setUnderlyingEmitter(builder);
        builder.setStripper(stripper);
        return stripper;
    }

    public void setDecimalFormatManager(DecimalFormatManager decimalFormatManager) {
        this.decimalFormatManager = decimalFormatManager;
    }

    public DecimalFormatManager getDecimalFormatManager() {
        return this.decimalFormatManager;
    }

    public void setRuleManager(RuleManager ruleManager) {
        this.ruleManager = ruleManager;
    }

    public RuleManager getRuleManager() {
        return this.ruleManager;
    }

    public void setTraceListener(TraceListener traceListener) {
        this.traceListener = traceListener;
    }

    public TraceListener getTraceListener() {
        return this.traceListener;
    }

    public final boolean isTracing() {
        return this.traceListener != null && !this.tracingIsSuspended;
    }

    public void pauseTracing(boolean bl) {
        this.tracingIsSuspended = bl;
    }

    public void setPreparedStyleSheet(PreparedStyleSheet preparedStyleSheet) {
        this.preparedStyleSheet = preparedStyleSheet;
        this.styleSheetElement = (XSLStyleSheet)preparedStyleSheet.getStyleSheetDocument().getDocumentElement();
        this.preview = this.styleSheetElement.getPreviewManager() != null;
    }

    protected boolean usesPreviewMode() {
        return this.preview;
    }

    private void initializeController() {
        this.setRuleManager(this.styleSheetElement.getRuleManager());
        this.setDecimalFormatManager(this.styleSheetElement.getDecimalFormatManager());
        if (this.traceListener != null) {
            this.traceListener.open();
        }
        this.bindery = new Bindery();
        this.styleSheetElement.initialiseBindery(this.bindery);
        this.bindery.defineGlobalParameters(this.parameters);
    }

    public void addTraceListener(TraceListener traceListener) {
        this.traceListener = SaxonEventMulticaster.add(this.traceListener, traceListener);
    }

    public void removeTraceListener(TraceListener traceListener) {
        this.traceListener = SaxonEventMulticaster.remove(this.traceListener, traceListener);
    }

    public Object getUserData(NodeInfo nodeInfo, String string) {
        String string2 = string + ' ' + this.getDocumentPool().getDocumentNumber(nodeInfo.getDocumentRoot()) + nodeInfo.generateId();
        return this.userDataTable.get(string2);
    }

    public void setUserData(NodeInfo nodeInfo, String string, Object object) {
        String string2 = string + ' ' + this.getDocumentPool().getDocumentNumber(nodeInfo.getDocumentRoot()) + nodeInfo.generateId();
        if (object == null) {
            this.userDataTable.remove(string2);
        } else {
            this.userDataTable.put(string2, object);
        }
    }

    @Override
    public void transform(Source source, Result result) throws TransformerException {
        if (this.preparedStyleSheet == null) {
            throw new TransformerException("Stylesheet has not been prepared");
        }
        PreviewManager previewManager = this.styleSheetElement.getPreviewManager();
        this.preview = previewManager != null;
        String string = "/";
        try {
            Source source2;
            if (source instanceof NodeInfo) {
                if (this.preview) {
                    throw new TransformerException("Preview mode requires serial input");
                }
                this.transformDocument((NodeInfo)source, result);
                return;
            }
            if (source instanceof DOMSource) {
                source2 = (DOMSource)source;
                if (this.preview) {
                    throw new TransformerException("Preview mode requires serial input");
                }
                if ((this.disableStripping || !this.styleSheetElement.stripsWhitespace()) && ((DOMSource)source2).getNode() instanceof NodeInfo) {
                    this.transformDocument((NodeInfo)((Object)((DOMSource)source2).getNode()), result);
                    return;
                }
                string = this.getPathToNode(((DOMSource)source2).getNode());
            }
            source2 = this.factory.getSAXSource(source, false);
            if (this.preview) {
                this.initializeController();
                if (this.outputProperties == null) {
                    this.outputProperties = new Properties();
                }
                this.changeOutputDestination(this.outputProperties, result);
                Builder builder = this.makeBuilder();
                builder.setController(this);
                builder.setPreviewManager(previewManager);
                builder.setNamePool(this.namePool);
                DocumentInfo documentInfo = builder.build((SAXSource)source2);
                this.sourceDocumentPool.add(documentInfo, null);
                builder = null;
                this.transformDocument(documentInfo, result);
                this.resetOutputDestination(null);
            } else {
                Builder builder = this.makeBuilder();
                DocumentInfo documentInfo = builder.build((SAXSource)source2);
                this.sourceDocumentPool.add(documentInfo, null);
                builder = null;
                NodeInfo nodeInfo = documentInfo;
                if (!string.equals("/")) {
                    Context context;
                    Expression expression = Expression.make(string, new StandaloneContext(this.namePool));
                    NodeEnumeration nodeEnumeration = expression.enumerate(context = this.makeContext(documentInfo), false);
                    if (nodeEnumeration.hasMoreElements()) {
                        nodeInfo = nodeEnumeration.nextElement();
                    } else {
                        throw new TransformerException("Problem finding the start node after converting DOM to Saxon tree");
                    }
                }
                this.transformDocument(nodeInfo, result);
            }
        }
        catch (TerminationException terminationException) {
            throw terminationException;
        }
        catch (TransformerException transformerException) {
            Throwable throwable = transformerException.getException();
            if (throwable == null || !(throwable instanceof SAXParseException)) {
                this.errorListener.fatalError(transformerException);
            }
            throw transformerException;
        }
    }

    private String getPathToNode(Node node) throws TransformerException {
        String string;
        short s = node.getNodeType();
        if (s == 9) {
            string = "/";
        } else if (s == 1) {
            string = "";
            Node node2 = node;
            while (s == 1) {
                int n = 1;
                for (Node node3 = node2.getPreviousSibling(); node3 != null; node3 = node3.getPreviousSibling()) {
                    short s2 = node3.getNodeType();
                    if (s2 == 1) {
                        ++n;
                        continue;
                    }
                    if (s2 != 4 && s2 != 5) continue;
                    throw new TransformerException("Document contains CDATA or Entity nodes: can only transform starting at root");
                }
                if (!string.equals("")) {
                    string = '/' + string;
                }
                string = "*[" + n + ']' + string;
                if ((node2 = node2.getParentNode()) == null) {
                    throw new TransformerException("Supplied element is not within a Document");
                }
                s = node2.getNodeType();
                if (s == 9) {
                    string = '/' + string;
                    continue;
                }
                if (s != 4 && s != 5) continue;
                throw new TransformerException("Document contains CDATA or Entity nodes: can only transform starting at root");
            }
        } else {
            throw new TransformerException("Start node must be either the root or an element");
        }
        return string;
    }

    public void transformDocument(NodeInfo nodeInfo, Result result) throws TransformerException {
        DocumentInfo documentInfo = nodeInfo instanceof DocumentInfo ? (DocumentInfo)nodeInfo : nodeInfo.getDocumentRoot();
        if (this.styleSheetElement == null) {
            throw new TransformerException("Stylesheet has not been prepared");
        }
        if (documentInfo.getNamePool() == null) {
            documentInfo.setNamePool(this.preparedStyleSheet.getNamePool());
        }
        if (documentInfo.getNamePool() != this.preparedStyleSheet.getNamePool()) {
            throw new TransformerException("Source document and stylesheet must use the same name pool");
        }
        Context context = this.makeContext(documentInfo);
        if (!this.preview) {
            String string;
            Object object;
            this.initializeController();
            Properties properties = new Properties();
            this.styleSheetElement.updateOutputProperties(properties, context);
            if (this.outputProperties != null) {
                object = this.outputProperties.propertyNames();
                while (object.hasMoreElements()) {
                    string = (String)object.nextElement();
                    String string2 = this.outputProperties.getProperty(string);
                    properties.put(string, string2);
                }
            }
            if ((object = properties.getProperty("{http://icl.com/saxon}next-in-chain")) != null) {
                string = properties.getProperty("{http://icl.com/saxon}next-in-chain-base-uri");
                result = this.prepareNextStylesheet((String)object, string, result);
            }
            this.changeOutputDestination(properties, result);
        }
        this.styleSheetElement.process(context);
        this.run(nodeInfo);
        if (this.traceListener != null) {
            this.traceListener.close();
        }
        if (!this.preview) {
            this.resetOutputDestination(null);
        }
    }

    private Result prepareNextStylesheet(String string, String string2, Result result) throws TransformerException {
        Source source = this.getURIResolver().resolve(string, string2);
        SAXSource sAXSource = this.factory.getSAXSource(source, true);
        Templates templates = this.factory.newTemplates(source);
        TransformerHandler transformerHandler = this.factory.newTransformerHandler(templates);
        ContentHandlerProxy contentHandlerProxy = new ContentHandlerProxy();
        contentHandlerProxy.setUnderlyingContentHandler(transformerHandler);
        contentHandlerProxy.setSystemId(sAXSource.getSystemId());
        contentHandlerProxy.setRequireWellFormed(false);
        transformerHandler.setResult(result);
        return contentHandlerProxy;
    }

    @Override
    public void setParameter(String string, Object object) {
        Value value;
        if (this.parameters == null) {
            this.parameters = new ParameterSet();
        }
        try {
            value = FunctionProxy.convertJavaObjectToXPath(object, this);
        }
        catch (TransformerException transformerException) {
            value = new StringValue(object.toString());
        }
        int n = this.getFingerprintForExpandedName(string);
        this.parameters.put(n, value);
    }

    public void setParams(ParameterSet parameterSet) {
        this.parameters = parameterSet;
    }

    private int getFingerprintForExpandedName(String string) {
        String string2;
        String string3;
        if (string.charAt(0) == '{') {
            int n = string.indexOf(125);
            if (n < 0) {
                throw new IllegalArgumentException("No closing '}' in parameter name");
            }
            string3 = string.substring(1, n);
            if (n == string.length()) {
                throw new IllegalArgumentException("Missing local part in parameter name");
            }
            string2 = string.substring(n + 1);
        } else {
            string3 = "";
            string2 = string;
        }
        return this.namePool.allocate("", string3, string2);
    }

    @Override
    public void clearParameters() {
        this.parameters = null;
    }

    @Override
    public Object getParameter(String string) {
        if (this.parameters == null) {
            return null;
        }
        int n = this.getFingerprintForExpandedName(string);
        return this.parameters.get(n);
    }

    @Override
    public void setURIResolver(URIResolver uRIResolver) {
        this.userURIResolver = uRIResolver;
    }
}

