/*
 * Decompiled with CFR 0.152.
 */
package org.mockito.internal.util.collections;

import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.mockito.internal.util.Checks;
import org.mockito.internal.util.collections.HashCodeAndEqualsMockWrapper;

public class HashCodeAndEqualsSafeSet
implements Set<Object> {
    private final HashSet<HashCodeAndEqualsMockWrapper> backingHashSet = new HashSet();

    @Override
    public Iterator<Object> iterator() {
        return new Iterator<Object>(){
            private final Iterator<HashCodeAndEqualsMockWrapper> iterator;
            {
                this.iterator = HashCodeAndEqualsSafeSet.this.backingHashSet.iterator();
            }

            @Override
            public boolean hasNext() {
                return this.iterator.hasNext();
            }

            @Override
            public Object next() {
                return this.iterator.next().get();
            }

            @Override
            public void remove() {
                this.iterator.remove();
            }
        };
    }

    @Override
    public int size() {
        return this.backingHashSet.size();
    }

    @Override
    public boolean isEmpty() {
        return this.backingHashSet.isEmpty();
    }

    @Override
    public boolean contains(Object object) {
        return this.backingHashSet.contains(HashCodeAndEqualsMockWrapper.of(object));
    }

    @Override
    public boolean add(Object object) {
        return this.backingHashSet.add(HashCodeAndEqualsMockWrapper.of(object));
    }

    @Override
    public boolean remove(Object object) {
        return this.backingHashSet.remove(HashCodeAndEqualsMockWrapper.of(object));
    }

    @Override
    public void clear() {
        this.backingHashSet.clear();
    }

    public Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException();
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof HashCodeAndEqualsSafeSet)) {
            return false;
        }
        HashCodeAndEqualsSafeSet hashCodeAndEqualsSafeSet = (HashCodeAndEqualsSafeSet)object;
        return this.backingHashSet.equals(hashCodeAndEqualsSafeSet.backingHashSet);
    }

    @Override
    public int hashCode() {
        return this.backingHashSet.hashCode();
    }

    @Override
    public Object[] toArray() {
        return this.unwrapTo(new Object[this.size()]);
    }

    private <T> T[] unwrapTo(T[] TArray) {
        Iterator<Object> iterator = this.iterator();
        int n = TArray.length;
        for (int i = 0; i < n; ++i) {
            if (!iterator.hasNext()) continue;
            TArray[i] = iterator.next();
        }
        return TArray;
    }

    @Override
    public <T> T[] toArray(T[] TArray) {
        T[] TArray2 = TArray.length >= this.size() ? TArray : (Object[])Array.newInstance(TArray.getClass().getComponentType(), this.size());
        return this.unwrapTo(TArray2);
    }

    @Override
    public boolean removeAll(Collection<?> collection) {
        return this.backingHashSet.removeAll(this.asWrappedMocks(collection));
    }

    @Override
    public boolean containsAll(Collection<?> collection) {
        return this.backingHashSet.containsAll(this.asWrappedMocks(collection));
    }

    @Override
    public boolean addAll(Collection<?> collection) {
        return this.backingHashSet.addAll(this.asWrappedMocks(collection));
    }

    @Override
    public boolean retainAll(Collection<?> collection) {
        return this.backingHashSet.retainAll(this.asWrappedMocks(collection));
    }

    private HashSet<HashCodeAndEqualsMockWrapper> asWrappedMocks(Collection<?> collection) {
        Checks.checkNotNull(collection, "Passed collection should notify() be null");
        HashSet<HashCodeAndEqualsMockWrapper> hashSet = new HashSet<HashCodeAndEqualsMockWrapper>();
        for (Object obj : collection) {
            assert (!(obj instanceof HashCodeAndEqualsMockWrapper)) : "WRONG";
            hashSet.add(HashCodeAndEqualsMockWrapper.of(obj));
        }
        return hashSet;
    }

    public String toString() {
        return this.backingHashSet.toString();
    }

    public static HashCodeAndEqualsSafeSet of(Object ... objectArray) {
        return HashCodeAndEqualsSafeSet.of(Arrays.asList(objectArray));
    }

    public static HashCodeAndEqualsSafeSet of(Iterable<Object> iterable) {
        HashCodeAndEqualsSafeSet hashCodeAndEqualsSafeSet = new HashCodeAndEqualsSafeSet();
        if (iterable != null) {
            for (Object object : iterable) {
                hashCodeAndEqualsSafeSet.add(object);
            }
        }
        return hashCodeAndEqualsSafeSet;
    }
}

