/*
 * Decompiled with CFR 0.152.
 */
package org.mockito.internal.debugging;

import java.util.Arrays;
import java.util.List;
import org.mockito.MockitoDebugger;
import org.mockito.internal.invocation.UnusedStubsFinder;
import org.mockito.internal.invocation.finder.AllInvocationsFinder;
import org.mockito.invocation.Invocation;

public class MockitoDebuggerImpl
implements MockitoDebugger {
    private final AllInvocationsFinder allInvocationsFinder = new AllInvocationsFinder();
    private final UnusedStubsFinder unusedStubsFinder = new UnusedStubsFinder();

    @Override
    public String printInvocations(Object ... objectArray) {
        String string = "";
        List<Invocation> list = this.allInvocationsFinder.find(Arrays.asList(objectArray));
        string = string + this.line("********************************");
        string = string + this.line("*** Mockito interactions log ***");
        string = string + this.line("********************************");
        for (Invocation invocation : list) {
            string = string + this.line(invocation.toString());
            string = string + this.line(" invoked: " + invocation.getLocation());
            if (invocation.stubInfo() == null) continue;
            string = string + this.line(" stubbed: " + invocation.stubInfo().stubbedAt().toString());
        }
        list = this.unusedStubsFinder.find(Arrays.asList(objectArray));
        if (list.isEmpty()) {
            return this.print(string);
        }
        string = string + this.line("********************************");
        string = string + this.line("***       Unused stubs       ***");
        string = string + this.line("********************************");
        for (Invocation invocation : list) {
            string = string + this.line(invocation.toString());
            string = string + this.line(" stubbed: " + invocation.getLocation());
        }
        return this.print(string);
    }

    private String line(String string) {
        return string + "\n";
    }

    private String print(String string) {
        System.out.println(string);
        return string;
    }
}

