/*
 * Decompiled with CFR 0.152.
 */
package org.mockito.internal.configuration.plugins;

import java.io.InputStream;
import java.net.URL;
import org.mockito.exceptions.base.MockitoException;
import org.mockito.internal.configuration.plugins.PluginFileReader;
import org.mockito.internal.util.io.IOUtil;
import org.mockito.plugins.PluginSwitch;

class PluginFinder {
    private final PluginSwitch pluginSwitch;

    public PluginFinder(PluginSwitch pluginSwitch) {
        this.pluginSwitch = pluginSwitch;
    }

    String findPluginClass(Iterable<URL> iterable) {
        for (URL uRL : iterable) {
            InputStream inputStream = null;
            try {
                inputStream = uRL.openStream();
                String string = new PluginFileReader().readPluginClass(inputStream);
                if (string == null || !this.pluginSwitch.isEnabled(string)) continue;
                String string2 = string;
                return string2;
            }
            catch (Exception exception) {
                throw new MockitoException("Problems reading plugin implementation from: " + uRL, exception);
            }
            finally {
                IOUtil.closeQuietly(inputStream);
            }
        }
        return null;
    }
}

