/*
 * Decompiled with CFR 0.152.
 */
package org.mockito.internal.configuration.injection;

import java.lang.reflect.Field;
import java.util.Set;

public abstract class MockInjectionStrategy {
    private MockInjectionStrategy nextStrategy;

    public static final MockInjectionStrategy nop() {
        return new MockInjectionStrategy(){

            @Override
            protected boolean processInjection(Field field, Object object, Set<Object> set) {
                return false;
            }
        };
    }

    public MockInjectionStrategy thenTry(MockInjectionStrategy mockInjectionStrategy) {
        if (this.nextStrategy != null) {
            this.nextStrategy.thenTry(mockInjectionStrategy);
        } else {
            this.nextStrategy = mockInjectionStrategy;
        }
        return mockInjectionStrategy;
    }

    public boolean process(Field field, Object object, Set<Object> set) {
        if (this.processInjection(field, object, set)) {
            return true;
        }
        return this.relayProcessToNextStrategy(field, object, set);
    }

    protected abstract boolean processInjection(Field var1, Object var2, Set<Object> var3);

    private boolean relayProcessToNextStrategy(Field field, Object object, Set<Object> set) {
        return this.nextStrategy != null && this.nextStrategy.process(field, object, set);
    }
}

