/*
 * Decompiled with CFR 0.152.
 */
package org.mockito.internal.configuration;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import org.mockito.Captor;
import org.mockito.Mock;
import org.mockito.MockitoAnnotations;
import org.mockito.configuration.AnnotationEngine;
import org.mockito.exceptions.Reporter;
import org.mockito.exceptions.base.MockitoException;
import org.mockito.internal.configuration.CaptorAnnotationProcessor;
import org.mockito.internal.configuration.FieldAnnotationProcessor;
import org.mockito.internal.configuration.MockAnnotationProcessor;
import org.mockito.internal.configuration.MockitoAnnotationsMockAnnotationProcessor;
import org.mockito.internal.util.reflection.FieldSetter;

public class DefaultAnnotationEngine
implements AnnotationEngine {
    private final Map<Class<? extends Annotation>, FieldAnnotationProcessor<?>> annotationProcessorMap = new HashMap();

    public DefaultAnnotationEngine() {
        this.registerAnnotationProcessor(Mock.class, new MockAnnotationProcessor());
        this.registerAnnotationProcessor(MockitoAnnotations.Mock.class, new MockitoAnnotationsMockAnnotationProcessor());
        this.registerAnnotationProcessor(Captor.class, new CaptorAnnotationProcessor());
    }

    @Override
    public Object createMockFor(Annotation annotation, Field field) {
        return this.forAnnotation(annotation).process(annotation, field);
    }

    private <A extends Annotation> FieldAnnotationProcessor<A> forAnnotation(A a) {
        if (this.annotationProcessorMap.containsKey(a.annotationType())) {
            return this.annotationProcessorMap.get(a.annotationType());
        }
        return new FieldAnnotationProcessor<A>(){

            @Override
            public Object process(A a, Field field) {
                return null;
            }
        };
    }

    private <A extends Annotation> void registerAnnotationProcessor(Class<A> clazz, FieldAnnotationProcessor<A> fieldAnnotationProcessor) {
        this.annotationProcessorMap.put(clazz, fieldAnnotationProcessor);
    }

    @Override
    public void process(Class<?> clazz, Object object) {
        Field[] fieldArray;
        for (Field field : fieldArray = clazz.getDeclaredFields()) {
            boolean bl = false;
            for (Annotation annotation : field.getAnnotations()) {
                Object object2 = this.createMockFor(annotation, field);
                if (object2 == null) continue;
                this.throwIfAlreadyAssigned(field, bl);
                bl = true;
                try {
                    new FieldSetter(object, field).set(object2);
                }
                catch (Exception exception) {
                    throw new MockitoException("Problems setting field " + field.getName() + " annotated with " + annotation, exception);
                }
            }
        }
    }

    void throwIfAlreadyAssigned(Field field, boolean bl) {
        if (bl) {
            new Reporter().moreThanOneAnnotationNotAllowed(field.getName());
        }
    }
}

