/*
 * Decompiled with CFR 0.152.
 */
package rdr;

import java.io.InputStream;
import rdr.EndOfStream;
import rdr.Exception;
import rdr.IOException;
import rdr.InStream;

public class JavaInStream
extends InStream {
    static final int defaultBufSize = 8192;
    static final int minBulkSize = 1024;
    private InputStream jis;
    private int ptrOffset;
    private int bufSize;
    boolean timing;
    long timeWaitedIn100us;
    long timedKbits;

    public JavaInStream(InputStream jis_, int bufSize_) {
        this.jis = jis_;
        this.bufSize = bufSize_;
        this.b = new byte[this.bufSize];
        this.ptrOffset = 0;
        this.end = 0;
        this.ptr = 0;
        this.timeWaitedIn100us = 5L;
        this.timedKbits = 0L;
    }

    public JavaInStream(InputStream jis_) {
        this(jis_, 8192);
    }

    @Override
    public void readBytes(byte[] data, int offset, int length) {
        if (length < 1024) {
            super.readBytes(data, offset, length);
            return;
        }
        int n = this.end - this.ptr;
        if (n > length) {
            n = length;
        }
        System.arraycopy(this.b, this.ptr, data, offset, n);
        offset += n;
        length -= n;
        this.ptr += n;
        while (length > 0) {
            n = this.read(data, offset, length);
            offset += n;
            length -= n;
            this.ptrOffset += n;
        }
    }

    @Override
    public int pos() {
        return this.ptrOffset + this.ptr;
    }

    public void startTiming() {
        this.timing = true;
        if (this.timeWaitedIn100us > 10000L) {
            this.timedKbits = this.timedKbits * 10000L / this.timeWaitedIn100us;
            this.timeWaitedIn100us = 10000L;
        }
    }

    public void stopTiming() {
        this.timing = false;
        if (this.timeWaitedIn100us < this.timedKbits / 2L) {
            this.timeWaitedIn100us = this.timedKbits / 2L;
        }
    }

    public long kbitsPerSecond() {
        return this.timedKbits * 10000L / this.timeWaitedIn100us;
    }

    public long timeWaited() {
        return this.timeWaitedIn100us;
    }

    @Override
    protected int overrun(int itemSize, int nItems) {
        if (itemSize > this.bufSize) {
            throw new Exception("JavaInStream overrun: max itemSize exceeded");
        }
        if (this.end - this.ptr != 0) {
            System.arraycopy(this.b, this.ptr, this.b, 0, this.end - this.ptr);
        }
        this.ptrOffset += this.ptr;
        this.end -= this.ptr;
        this.ptr = 0;
        while (this.end < itemSize) {
            int n = this.read(this.b, this.end, this.bufSize - this.end);
            this.end += n;
        }
        if (itemSize * nItems > this.end) {
            nItems = this.end / itemSize;
        }
        return nItems;
    }

    private int read(byte[] buf, int offset, int len) {
        try {
            int n;
            long before = 0L;
            if (this.timing) {
                before = System.currentTimeMillis();
            }
            if ((n = this.jis.read(buf, offset, len)) < 0) {
                throw new EndOfStream();
            }
            if (this.timing) {
                int newKbits;
                long after = System.currentTimeMillis();
                long newTimeWaited = (after - before) * 10L;
                if (newTimeWaited > (long)((newKbits = n * 8 / 1000) * 1000)) {
                    newTimeWaited = newKbits * 1000;
                }
                if (newTimeWaited < (long)(newKbits / 4)) {
                    newTimeWaited = newKbits / 4;
                }
                this.timeWaitedIn100us += newTimeWaited;
                this.timedKbits += (long)newKbits;
            }
            return n;
        }
        catch (java.io.IOException e) {
            throw new IOException(e);
        }
    }
}

