/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections15.functors;

import java.io.Serializable;
import java.util.Collection;
import org.apache.commons.collections15.Predicate;
import org.apache.commons.collections15.functors.FunctorUtils;
import org.apache.commons.collections15.functors.PredicateDecorator;

public final class AllPredicate<T>
implements Predicate<T>,
PredicateDecorator<T>,
Serializable {
    static final long serialVersionUID = -3094696765038308799L;
    private final Predicate<? super T>[] iPredicates;

    public static <T> Predicate<T> getInstance(Predicate<? super T>[] predicates) {
        FunctorUtils.validateMin2(predicates);
        predicates = FunctorUtils.copy(predicates);
        return new AllPredicate<T>(predicates);
    }

    public static <T> Predicate<T> getInstance(Collection<Predicate<? super T>> predicates) {
        Predicate<? super T>[] preds = FunctorUtils.validate(predicates);
        return new AllPredicate<T>(preds);
    }

    public AllPredicate(Predicate<? super T>[] predicates) {
        this.iPredicates = predicates;
    }

    @Override
    public boolean evaluate(T object) {
        for (int i = 0; i < this.iPredicates.length; ++i) {
            if (this.iPredicates[i].evaluate(object)) continue;
            return false;
        }
        return true;
    }

    @Override
    public Predicate<? super T>[] getPredicates() {
        return this.iPredicates;
    }
}

