/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections15;

import org.apache.commons.collections15.Bag;
import org.apache.commons.collections15.Predicate;
import org.apache.commons.collections15.SortedBag;
import org.apache.commons.collections15.Transformer;
import org.apache.commons.collections15.bag.HashBag;
import org.apache.commons.collections15.bag.PredicatedBag;
import org.apache.commons.collections15.bag.PredicatedSortedBag;
import org.apache.commons.collections15.bag.SynchronizedBag;
import org.apache.commons.collections15.bag.SynchronizedSortedBag;
import org.apache.commons.collections15.bag.TransformedBag;
import org.apache.commons.collections15.bag.TransformedSortedBag;
import org.apache.commons.collections15.bag.TreeBag;
import org.apache.commons.collections15.bag.TypedBag;
import org.apache.commons.collections15.bag.TypedSortedBag;
import org.apache.commons.collections15.bag.UnmodifiableBag;
import org.apache.commons.collections15.bag.UnmodifiableSortedBag;

public class BagUtils {
    public static final Bag EMPTY_BAG = UnmodifiableBag.decorate(new HashBag());
    public static final Bag EMPTY_SORTED_BAG = UnmodifiableSortedBag.decorate(new TreeBag());

    public static <E> Bag<E> synchronizedBag(Bag<E> bag) {
        return SynchronizedBag.decorate(bag);
    }

    public static <E> Bag<E> unmodifiableBag(Bag<E> bag) {
        return UnmodifiableBag.decorate(bag);
    }

    public static <E> Bag<E> predicatedBag(Bag<E> bag, Predicate<? super E> predicate) {
        return PredicatedBag.decorate(bag, predicate);
    }

    public static <E> Bag<E> typedBag(Bag<E> bag, Class<E> type) {
        return TypedBag.decorate(bag, type);
    }

    public static <I, O> Bag<O> transformedBag(Bag<I> bag, Transformer<I, O> transformer) {
        return TransformedBag.decorate(bag, transformer);
    }

    public static <E> SortedBag<E> synchronizedSortedBag(SortedBag<E> bag) {
        return SynchronizedSortedBag.decorate(bag);
    }

    public static <E> SortedBag<E> unmodifiableSortedBag(SortedBag<E> bag) {
        return UnmodifiableSortedBag.decorate(bag);
    }

    public static <E> SortedBag<E> predicatedSortedBag(SortedBag<E> bag, Predicate<? super E> predicate) {
        return PredicatedSortedBag.decorate(bag, predicate);
    }

    public static <E> SortedBag<E> typedSortedBag(SortedBag<E> bag, Class<E> type) {
        return TypedSortedBag.decorate(bag, type);
    }

    public static <I, O> SortedBag<O> transformedSortedBag(SortedBag<I> bag, Transformer<I, O> transformer) {
        return TransformedSortedBag.decorate(bag, transformer);
    }
}

