/*
 * Decompiled with CFR 0.152.
 */
package lcmc.gui.resources;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Matcher;
import lcmc.data.CRMXML;
import lcmc.data.ClusterStatus;
import lcmc.data.ConfigData;
import lcmc.data.Host;
import lcmc.data.resources.Service;
import lcmc.gui.Browser;
import lcmc.gui.ClusterBrowser;
import lcmc.gui.resources.ConstraintPHInfo;
import lcmc.gui.resources.EditableInfo;
import lcmc.gui.resources.HbConnectionInfo;
import lcmc.gui.resources.HbConstraintInterface;
import lcmc.gui.resources.PcmkRscSetsInfo;
import lcmc.gui.resources.ServiceInfo;
import lcmc.gui.widget.Widget;
import lcmc.utilities.CRM;

final class HbColocationInfo
extends EditableInfo
implements HbConstraintInterface {
    private ServiceInfo serviceInfoRsc;
    private ServiceInfo serviceInfoWithRsc;
    private final HbConnectionInfo connectionInfo;

    HbColocationInfo(HbConnectionInfo connectionInfo, ServiceInfo serviceInfoRsc, ServiceInfo serviceInfoWithRsc, Browser browser) {
        super("Colocation", browser);
        this.setResource(new Service("Colocation"));
        this.connectionInfo = connectionInfo;
        this.serviceInfoRsc = serviceInfoRsc;
        this.serviceInfoWithRsc = serviceInfoWithRsc;
    }

    void setServiceInfoRsc(ServiceInfo serviceInfoRsc) {
        this.serviceInfoRsc = serviceInfoRsc;
    }

    void setServiceInfoWithRsc(ServiceInfo serviceInfoWithRsc) {
        this.serviceInfoWithRsc = serviceInfoWithRsc;
    }

    @Override
    protected ClusterBrowser getBrowser() {
        return (ClusterBrowser)super.getBrowser();
    }

    void setParameters() {
        CRMXML.ColocationData colocationData;
        ClusterStatus clStatus = this.getBrowser().getClusterStatus();
        String colId = this.getService().getHeartbeatId();
        HashMap<String, String> resourceNode = new HashMap<String, String>();
        if (this.serviceInfoRsc == null || this.serviceInfoWithRsc == null) {
            colocationData = clStatus.getColocationData(colId);
            String score = colocationData.getScore();
            resourceNode.put("score", score);
        } else if (this.serviceInfoRsc.isConstraintPH() || this.serviceInfoWithRsc.isConstraintPH()) {
            CRMXML.RscSet rscSet;
            ConstraintPHInfo cphi;
            if (this.serviceInfoRsc.isConstraintPH()) {
                cphi = (ConstraintPHInfo)this.serviceInfoRsc;
                rscSet = cphi.getRscSetConnectionDataCol().getRscSet1();
            } else {
                cphi = (ConstraintPHInfo)this.serviceInfoWithRsc;
                rscSet = cphi.getRscSetConnectionDataCol().getRscSet2();
            }
            resourceNode.put("sequential", rscSet.getSequential());
            resourceNode.put("role", rscSet.getColocationRole());
        } else {
            colocationData = clStatus.getColocationData(colId);
            if (colocationData != null) {
                String rsc = colocationData.getRsc();
                String withRsc = colocationData.getWithRsc();
                String score = colocationData.getScore();
                String rscRole = colocationData.getRscRole();
                String withRscRole = colocationData.getWithRscRole();
                resourceNode.put("score", score);
                resourceNode.put("rsc-role", rscRole);
                resourceNode.put("with-rsc-role", withRscRole);
            }
        }
        String[] params = this.getParametersFromXML();
        if (params != null) {
            for (String param : params) {
                String value = (String)resourceNode.get(param);
                if (value == null) {
                    value = this.getParamDefault(param);
                }
                if ("".equals(value)) {
                    value = null;
                }
                String oldValue = this.getParamSaved(param);
                if ((value != null || value == oldValue) && (value == null || value.equals(oldValue))) continue;
                this.getResource().setValue(param, value);
                Widget wi = this.getWidget(param, null);
                if (wi == null) continue;
                wi.setValue(value);
            }
        }
    }

    @Override
    public boolean isOrder() {
        return false;
    }

    @Override
    protected String getParamLongDesc(String param) {
        String text = this.getBrowser().getCRMXML().getColocationParamLongDesc(param);
        if (this.serviceInfoRsc != null && this.serviceInfoWithRsc != null) {
            return text.replaceAll("@RSC@", Matcher.quoteReplacement(this.serviceInfoRsc.toString())).replaceAll("@WITH-RSC@", Matcher.quoteReplacement(this.serviceInfoWithRsc.toString()));
        }
        return text;
    }

    @Override
    protected String getParamShortDesc(String param) {
        return this.getBrowser().getCRMXML().getColocationParamShortDesc(param);
    }

    @Override
    protected boolean checkParam(String param, String newValue) {
        return this.getBrowser().getCRMXML().checkColocationParam(param, newValue);
    }

    @Override
    protected String getParamDefault(String param) {
        return this.getBrowser().getCRMXML().getColocationParamDefault(param);
    }

    @Override
    protected String getParamPreferred(String param) {
        return this.getBrowser().getCRMXML().getColocationParamPreferred(param);
    }

    @Override
    public String[] getParametersFromXML() {
        if (this.serviceInfoRsc == null || this.serviceInfoWithRsc == null) {
            return this.getBrowser().getCRMXML().getRscSetColocationParameters();
        }
        if (this.serviceInfoRsc.isConstraintPH() || this.serviceInfoWithRsc.isConstraintPH()) {
            return this.getBrowser().getCRMXML().getRscSetColConnectionParameters();
        }
        return this.getBrowser().getCRMXML().getColocationParameters();
    }

    private boolean isRscSetMaster() {
        CRMXML.RscSet rscSet;
        if (this.serviceInfoRsc.isConstraintPH()) {
            ConstraintPHInfo cphi = (ConstraintPHInfo)this.serviceInfoRsc;
            rscSet = cphi.getRscSetConnectionDataCol().getRscSet1();
        } else {
            ConstraintPHInfo cphi = (ConstraintPHInfo)this.serviceInfoWithRsc;
            rscSet = cphi.getRscSetConnectionDataCol().getRscSet2();
        }
        if (rscSet == null) {
            return false;
        }
        return this.getBrowser().isOneMaster(rscSet.getRscIds());
    }

    @Override
    protected Object[] getParamPossibleChoices(String param) {
        if ("role".equals(param)) {
            return this.getBrowser().getCRMXML().getColocationParamPossibleChoices(param, this.isRscSetMaster());
        }
        if ("with-rsc-role".equals(param)) {
            return this.getBrowser().getCRMXML().getColocationParamPossibleChoices(param, this.serviceInfoWithRsc.getService().isMaster());
        }
        if ("rsc-role".equals(param)) {
            return this.getBrowser().getCRMXML().getColocationParamPossibleChoices(param, this.serviceInfoRsc.getService().isMaster());
        }
        return this.getBrowser().getCRMXML().getColocationParamPossibleChoices(param, false);
    }

    @Override
    protected String getParamType(String param) {
        return this.getBrowser().getCRMXML().getColocationParamType(param);
    }

    @Override
    protected String getSection(String param) {
        return this.getBrowser().getCRMXML().getColocationSection(param);
    }

    @Override
    protected boolean isCheckBox(String param) {
        return this.getBrowser().getCRMXML().isColocationBoolean(param);
    }

    @Override
    protected boolean isTimeType(String param) {
        return this.getBrowser().getCRMXML().isColocationTimeType(param);
    }

    @Override
    protected boolean isInteger(String param) {
        return this.getBrowser().getCRMXML().isColocationInteger(param);
    }

    @Override
    protected boolean isLabel(String param) {
        return this.getBrowser().getCRMXML().isColocationLabel(param);
    }

    @Override
    protected boolean isRequired(String param) {
        return this.getBrowser().getCRMXML().isColocationRequired(param);
    }

    protected Map<String, String> getAttributes() {
        String[] params = this.getParametersFromXML();
        LinkedHashMap<String, String> attrs = new LinkedHashMap<String, String>();
        boolean changed = true;
        for (String param : params) {
            String value = this.getComboBoxValue(param);
            if (!value.equals(this.getParamSaved(param))) {
                changed = true;
            }
            attrs.put(param, value);
        }
        return attrs;
    }

    @Override
    public void apply(Host dcHost, boolean testOnly) {
        String[] params = this.getParametersFromXML();
        LinkedHashMap<String, String> attrs = new LinkedHashMap<String, String>();
        boolean changed = true;
        for (String param : params) {
            String value = this.getComboBoxValue(param);
            if (!value.equals(this.getParamSaved(param))) {
                changed = true;
            }
            attrs.put(param, value);
        }
        if (changed) {
            String colId = this.getService().getHeartbeatId();
            if (this.serviceInfoRsc == null || this.serviceInfoWithRsc == null) {
                PcmkRscSetsInfo prsi = (PcmkRscSetsInfo)this.connectionInfo;
                CRM.setRscSet(dcHost, colId, false, null, false, prsi.getAllAttributes(dcHost, null, null, true, testOnly), null, attrs, testOnly);
            } else if (this.serviceInfoRsc.isConstraintPH() || this.serviceInfoWithRsc.isConstraintPH()) {
                CRMXML.RscSet rscSet;
                ConstraintPHInfo cphi;
                if (this.serviceInfoRsc.isConstraintPH()) {
                    cphi = (ConstraintPHInfo)this.serviceInfoRsc;
                    rscSet = cphi.getRscSetConnectionDataCol().getRscSet1();
                } else {
                    cphi = (ConstraintPHInfo)this.serviceInfoWithRsc;
                    rscSet = cphi.getRscSetConnectionDataCol().getRscSet2();
                }
                PcmkRscSetsInfo prsi = cphi.getPcmkRscSetsInfo();
                CRM.setRscSet(dcHost, colId, false, null, false, prsi.getAllAttributes(dcHost, rscSet, attrs, true, testOnly), null, prsi.getColocationAttributes(colId), testOnly);
            } else {
                CRM.addColocation(dcHost, colId, this.serviceInfoRsc.getHeartbeatId(testOnly), this.serviceInfoWithRsc.getHeartbeatId(testOnly), attrs, testOnly);
            }
        }
        if (!testOnly) {
            this.storeComboBoxValues(params);
        }
    }

    @Override
    public Service getService() {
        return (Service)this.getResource();
    }

    @Override
    public String getRsc1Name() {
        return "rsc";
    }

    @Override
    public String getRsc2Name() {
        return "with-rsc";
    }

    @Override
    public String getRsc1() {
        return this.serviceInfoRsc.toString();
    }

    @Override
    public String getRsc2() {
        return this.serviceInfoWithRsc.toString();
    }

    @Override
    public ServiceInfo getRscInfo1() {
        return this.serviceInfoRsc;
    }

    @Override
    public ServiceInfo getRscInfo2() {
        return this.serviceInfoWithRsc;
    }

    int getScore() {
        String colId;
        ClusterStatus clStatus = this.getBrowser().getClusterStatus();
        CRMXML.ColocationData data = clStatus.getColocationData(colId = this.getService().getHeartbeatId());
        if (data == null) {
            return 0;
        }
        String score = data.getScore();
        if (score == null) {
            return 0;
        }
        if ("INFINITY".equals(score) || "+INFINITY".equals(score)) {
            return 1000000;
        }
        if ("-INFINITY".equals(score)) {
            return -1000000;
        }
        return Integer.parseInt(score);
    }

    @Override
    protected boolean isAdvanced(String param) {
        return true;
    }

    @Override
    protected String isEnabled(String param) {
        return null;
    }

    @Override
    protected ConfigData.AccessType getAccessType(String param) {
        return ConfigData.AccessType.ADMIN;
    }

    @Override
    protected boolean isEnabledOnlyInAdvancedMode(String param) {
        return false;
    }

    @Override
    boolean checkResourceFieldsCorrect(String param, String[] params) {
        return this.checkResourceFieldsCorrect(param, params, false);
    }

    @Override
    public boolean checkResourceFieldsCorrect(String param, String[] params, boolean fromUp) {
        if (fromUp) {
            return super.checkResourceFieldsCorrect(param, params);
        }
        return this.connectionInfo.checkResourceFieldsCorrect(param, null);
    }

    @Override
    boolean checkResourceFieldsChanged(String param, String[] params) {
        return this.checkResourceFieldsChanged(param, params, false);
    }

    @Override
    public boolean checkResourceFieldsChanged(String param, String[] params, boolean fromUp) {
        if (fromUp) {
            return super.checkResourceFieldsChanged(param, params);
        }
        return this.connectionInfo.checkResourceFieldsChanged(param, null);
    }
}

