/*
 * Decompiled with CFR 0.152.
 */
package lcmc.gui.dialog.vm;

import java.awt.Dimension;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import lcmc.gui.dialog.WizardDialog;
import lcmc.gui.dialog.vm.Storage;
import lcmc.gui.dialog.vm.VMConfig;
import lcmc.gui.resources.VMSDiskInfo;
import lcmc.gui.resources.VMSVirtualDomainInfo;
import lcmc.utilities.Tools;

final class InstallationDisk
extends VMConfig {
    private static final long serialVersionUID = 1L;
    private JComponent inputPane = null;
    private static final String[] PARAMS = new String[]{"type", "target_bus_type", "source_file", "source_dev", "driver_name", "driver_type", "driver_cache", "readonly"};
    private VMSDiskInfo vmsdi = null;
    private WizardDialog nextDialogObject = null;

    InstallationDisk(WizardDialog previousDialog, VMSVirtualDomainInfo vmsVirtualDomainInfo) {
        super(previousDialog, vmsVirtualDomainInfo);
    }

    @Override
    public WizardDialog nextDialog() {
        if (this.skipButtonIsSelected()) {
            this.vmsdi.removeMyself(true);
        }
        if (this.nextDialogObject == null) {
            this.nextDialogObject = new Storage(this, this.getVMSVirtualDomainInfo());
        }
        return this.nextDialogObject;
    }

    @Override
    protected String getDialogTitle() {
        return Tools.getString("Dialog.vm.InstallationDisk.Title");
    }

    @Override
    protected String getDescription() {
        return Tools.getString("Dialog.vm.InstallationDisk.Description");
    }

    @Override
    protected void initDialog() {
        super.initDialog();
        this.enableComponentsLater(new JComponent[]{this.buttonClass(this.nextButton())});
    }

    @Override
    protected void initDialogAfterVisible() {
        this.enableComponents();
        final boolean enable = this.vmsdi.checkResourceFieldsCorrect(null, PARAMS);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                InstallationDisk.this.buttonClass(InstallationDisk.this.nextButton()).setEnabled(enable);
            }
        });
    }

    @Override
    protected JComponent getInputPane() {
        if (this.vmsdi != null) {
            this.vmsdi.selectMyself();
        }
        if (this.inputPane != null) {
            return this.inputPane;
        }
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 0));
        JPanel optionsPanel = new JPanel();
        optionsPanel.setLayout(new BoxLayout(optionsPanel, 1));
        optionsPanel.setAlignmentY(0.0f);
        if (this.vmsdi == null) {
            this.vmsdi = this.getVMSVirtualDomainInfo().addDiskPanel();
            this.vmsdi.waitForInfoPanel();
        }
        this.vmsdi.savePreferredValues();
        this.vmsdi.getResource().setValue("type", "file");
        this.vmsdi.getResource().setValue("target_bus_type", "IDE CDROM");
        this.vmsdi.getResource().setValue("target_device", "hdc");
        this.vmsdi.getResource().setValue("driver_type", "raw");
        this.vmsdi.getResource().setValue("driver_cache", "default");
        this.vmsdi.getResource().setValue("readonly", "True");
        this.vmsdi.getResource().setValue("source_file", "/var/lib/libvirt/images/");
        this.vmsdi.addWizardParams(optionsPanel, PARAMS, this.buttonClass(this.nextButton()), Tools.getDefaultSize("Dialog.vm.Resource.LabelWidth"), Tools.getDefaultSize("Dialog.vm.Resource.FieldWidth"), null);
        this.vmsdi.setApplyButtons(null, this.vmsdi.getParametersFromXML());
        panel.add(optionsPanel);
        JScrollPane sp = new JScrollPane(panel);
        sp.setMaximumSize(new Dimension(Short.MAX_VALUE, 200));
        sp.setPreferredSize(new Dimension(Short.MAX_VALUE, 200));
        this.inputPane = sp;
        return sp;
    }

    @Override
    protected boolean skipButtonEnabled() {
        return true;
    }
}

