/*
 * Decompiled with CFR 0.152.
 */
package lcmc.gui.dialog.lvm;

import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Map;
import java.util.Set;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SpringLayout;
import javax.swing.SwingUtilities;
import lcmc.data.AccessMode;
import lcmc.data.Cluster;
import lcmc.data.ConfigData;
import lcmc.data.Host;
import lcmc.data.resources.BlockDevice;
import lcmc.gui.Browser;
import lcmc.gui.SpringUtilities;
import lcmc.gui.dialog.lvm.LV;
import lcmc.gui.resources.BlockDevInfo;
import lcmc.gui.resources.DrbdVolumeInfo;
import lcmc.gui.widget.TextfieldWithUnit;
import lcmc.gui.widget.Widget;
import lcmc.utilities.LVM;
import lcmc.utilities.MyButton;
import lcmc.utilities.Tools;
import lcmc.utilities.WidgetListener;

public final class LVResize
extends LV {
    private static final long serialVersionUID = 1L;
    private static final String DESCRIPTION = "Resize the LVM volume. You can make it bigger, but not smaller for now. If this volume is replicated by DRBD, volumes on both nodes will be resized and drbdadm resize will be called. If you have something like filesystem on the DRBD, you have to resize the filesystem yourself.";
    private static final int RESIZE_TIMEOUT = 5000;
    private final BlockDevInfo blockDevInfo;
    private final MyButton resizeButton = new MyButton("Resize");
    private Widget sizeWi;
    private Widget oldSizeWi;
    private Widget maxSizeWi;
    private Map<Host, JCheckBox> hostCheckBoxes = null;

    public LVResize(BlockDevInfo blockDevInfo) {
        super(null);
        this.blockDevInfo = blockDevInfo;
    }

    @Override
    protected void finishDialog() {
    }

    @Override
    protected String getDialogTitle() {
        return "LVM Resize";
    }

    @Override
    protected String getDescription() {
        return DESCRIPTION;
    }

    @Override
    public String cancelButton() {
        return "Close";
    }

    @Override
    protected void initDialog() {
        super.initDialog();
        this.enableComponentsLater(new JComponent[0]);
    }

    @Override
    protected void initDialogAfterVisible() {
        this.enableComponents();
        if (this.checkDRBD()) {
            this.makeDefaultAndRequestFocusLater(this.sizeWi);
        }
    }

    private boolean checkDRBD() {
        if (this.blockDevInfo.getBlockDevice().isDrbd()) {
            DrbdVolumeInfo dvi = this.blockDevInfo.getDrbdVolumeInfo();
            BlockDevInfo oBDI = this.blockDevInfo.getOtherBlockDevInfo();
            if (!dvi.isConnected(false)) {
                this.printErrorAndRetry("Not resizing. DRBD resource is not connected.");
                this.sizeWi.setEnabled(false);
                this.resizeButton.setEnabled(false);
                return false;
            }
            if (dvi.isSyncing()) {
                this.printErrorAndRetry("Not resizing. DRBD resource is syncing.");
                this.sizeWi.setEnabled(false);
                this.resizeButton.setEnabled(false);
                return false;
            }
            if (!oBDI.getBlockDevice().isAttached()) {
                this.printErrorAndRetry("Not resizing. DRBD resource is not attached on " + oBDI.getHost() + ".");
                this.sizeWi.setEnabled(false);
                this.resizeButton.setEnabled(false);
                return false;
            }
            if (!this.blockDevInfo.getBlockDevice().isAttached()) {
                this.printErrorAndRetry("Not resizing. DRBD resource is not attached on " + this.blockDevInfo.getHost() + ".");
                this.sizeWi.setEnabled(false);
                this.resizeButton.setEnabled(false);
                return false;
            }
            if (!oBDI.getBlockDevice().isPrimary() && !this.blockDevInfo.getBlockDevice().isPrimary()) {
                this.printErrorAndRetry("Not resizing. Must be primary at least on one node.");
                this.sizeWi.setEnabled(false);
                this.resizeButton.setEnabled(false);
                return false;
            }
        }
        return true;
    }

    protected void checkButtons() {
        SwingUtilities.invokeLater(new EnableResizeRunnable(true));
    }

    private void setComboBoxes() {
        String oldBlockSize = this.blockDevInfo.getBlockDevice().getBlockSize();
        String maxBlockSize = this.getMaxBlockSize();
        this.oldSizeWi.setValue(Tools.convertKilobytes(oldBlockSize));
        this.sizeWi.setValue(Tools.convertKilobytes(Long.toString((Long.parseLong(oldBlockSize) + Long.parseLong(maxBlockSize)) / 2L)));
        this.maxSizeWi.setValue(Tools.convertKilobytes(maxBlockSize));
    }

    @Override
    protected JComponent getInputPane() {
        this.resizeButton.setEnabled(false);
        JPanel pane = new JPanel(new SpringLayout());
        JPanel inputPane = new JPanel(new SpringLayout());
        inputPane.setBackground(Browser.BUTTON_PANEL_BACKGROUND);
        JLabel oldSizeLabel = new JLabel("Current Size");
        oldSizeLabel.setEnabled(false);
        String oldBlockSize = this.blockDevInfo.getBlockDevice().getBlockSize();
        this.oldSizeWi = new TextfieldWithUnit(Tools.convertKilobytes(oldBlockSize), LVResize.getUnits(), Widget.NO_REGEXP, 250, Widget.NO_ABBRV, new AccessMode(ConfigData.AccessType.OP, false), Widget.NO_BUTTON);
        this.oldSizeWi.setEnabled(false);
        inputPane.add(oldSizeLabel);
        inputPane.add(this.oldSizeWi);
        inputPane.add(new JLabel());
        String maxBlockSize = this.getMaxBlockSize();
        String newBlockSize = Long.toString((Long.parseLong(oldBlockSize) + Long.parseLong(maxBlockSize)) / 2L);
        JLabel sizeLabel = new JLabel("New Size");
        this.sizeWi = new TextfieldWithUnit(Tools.convertKilobytes(newBlockSize), LVResize.getUnits(), Widget.NO_REGEXP, 250, Widget.NO_ABBRV, new AccessMode(ConfigData.AccessType.OP, false), Widget.NO_BUTTON);
        inputPane.add(sizeLabel);
        inputPane.add(this.sizeWi);
        this.resizeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Thread thread = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        if (LVResize.this.checkDRBD()) {
                            Tools.invokeAndWait(new EnableResizeRunnable(false));
                            LVResize.this.disableComponents();
                            LVResize.this.getProgressBar().start(5000 * LVResize.this.hostCheckBoxes.size());
                            boolean ret = LVResize.this.resize(LVResize.this.sizeWi.getStringValue());
                            Host host = LVResize.this.blockDevInfo.getHost();
                            host.getBrowser().getClusterBrowser().updateHWInfo(host);
                            LVResize.this.setComboBoxes();
                            if (ret) {
                                LVResize.this.progressBarDone();
                            } else {
                                LVResize.this.progressBarDoneError();
                            }
                            LVResize.this.enableComponents();
                        }
                    }
                });
                thread.start();
            }
        });
        inputPane.add(this.resizeButton);
        JLabel maxSizeLabel = new JLabel("Max Size");
        maxSizeLabel.setEnabled(false);
        this.maxSizeWi = new TextfieldWithUnit(Tools.convertKilobytes(maxBlockSize), LVResize.getUnits(), Widget.NO_REGEXP, 250, Widget.NO_ABBRV, new AccessMode(ConfigData.AccessType.OP, false), Widget.NO_BUTTON);
        this.maxSizeWi.setEnabled(false);
        inputPane.add(maxSizeLabel);
        inputPane.add(this.maxSizeWi);
        inputPane.add(new JLabel());
        this.sizeWi.addListeners(new WidgetListener(){

            @Override
            public void check(Object value) {
                LVResize.this.checkButtons();
            }
        });
        SpringUtilities.makeCompactGrid(inputPane, 3, 3, 1, 1, 1, 1);
        pane.add(inputPane);
        JPanel hostsPane = new JPanel(new FlowLayout(0));
        Cluster cluster = this.blockDevInfo.getHost().getCluster();
        this.hostCheckBoxes = Tools.getHostCheckBoxes(cluster);
        hostsPane.add(new JLabel("Select Hosts: "));
        Host host = this.blockDevInfo.getHost();
        String lv = this.blockDevInfo.getBlockDevice().getLogicalVolume();
        for (Host h : this.hostCheckBoxes.keySet()) {
            Set<String> allLVS = h.getAllLogicalVolumes();
            this.hostCheckBoxes.get(h).addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    LVResize.this.checkButtons();
                }
            });
            if (host == h) {
                this.hostCheckBoxes.get(h).setEnabled(false);
                this.hostCheckBoxes.get(h).setSelected(true);
            } else if (this.blockDevInfo.getBlockDevice().isDrbd() && this.blockDevInfo.getOtherBlockDevInfo().getHost() == h) {
                this.hostCheckBoxes.get(h).setEnabled(false);
                this.hostCheckBoxes.get(h).setSelected(true);
            } else if (!this.blockDevInfo.getBlockDevice().isDrbd() && !allLVS.contains(lv)) {
                this.hostCheckBoxes.get(h).setEnabled(false);
                this.hostCheckBoxes.get(h).setSelected(false);
            } else {
                this.hostCheckBoxes.get(h).setEnabled(true);
                this.hostCheckBoxes.get(h).setSelected(false);
            }
            hostsPane.add(this.hostCheckBoxes.get(h));
        }
        JScrollPane sp = new JScrollPane(hostsPane);
        sp.setPreferredSize(new Dimension(0, 45));
        pane.add(sp);
        pane.add(this.getProgressBarPane(null));
        pane.add(this.getAnswerPane(""));
        SpringUtilities.makeCompactGrid(pane, 4, 1, 0, 0, 0, 0);
        this.checkButtons();
        return pane;
    }

    private boolean resize(String size) {
        boolean ret = LVM.resize(this.blockDevInfo.getHost(), this.blockDevInfo.getBlockDevice().getName(), size, false);
        if (ret) {
            this.answerPaneSetText("Logical volume was successfully resized on " + this.blockDevInfo.getHost() + ".");
            String lvm = this.blockDevInfo.getBlockDevice().getName();
            BlockDevInfo oBDI = this.blockDevInfo.getOtherBlockDevInfo();
            boolean resizingFailed = false;
            block0: for (Host h : this.hostCheckBoxes.keySet()) {
                if (h == this.blockDevInfo.getHost() || !this.hostCheckBoxes.get(h).isSelected()) continue;
                for (BlockDevice b : h.getBlockDevices()) {
                    if (lvm.equals(b.getName()) || oBDI != null && oBDI.getBlockDevice() == b) {
                        boolean oRet = LVM.resize(h, b.getName(), size, false);
                        if (oRet) {
                            this.answerPaneAddText("Logical volume was successfully resized on " + h.getName() + ".");
                            continue block0;
                        }
                        this.answerPaneAddTextError("Resizing of " + b.getName() + " on host " + h.getName() + " failed.");
                        resizingFailed = true;
                        continue block0;
                    }
                    if (resizingFailed) continue block0;
                }
            }
            if (oBDI != null && !resizingFailed) {
                boolean dRet = this.blockDevInfo.resizeDrbd(false);
                if (dRet) {
                    this.answerPaneAddText("DRBD resource " + this.blockDevInfo.getDrbdVolumeInfo().getName() + " was successfully resized.");
                } else {
                    this.answerPaneAddTextError("DRBD resource " + this.blockDevInfo.getDrbdVolumeInfo().getName() + " resizing failed.");
                }
            }
        } else {
            this.answerPaneAddTextError("Resizing of " + this.blockDevInfo.getName() + " on host " + this.blockDevInfo.getHost() + " failed.");
        }
        return ret;
    }

    private String getMaxBlockSize() {
        long free = this.blockDevInfo.getFreeInVolumeGroup() / 1024L;
        String maxBlockSize = "0";
        try {
            long taken = Long.parseLong(this.blockDevInfo.getBlockDevice().getBlockSize());
            BlockDevInfo oBDI = this.blockDevInfo.getOtherBlockDevInfo();
            long max = free + taken;
            String lvm = this.blockDevInfo.getBlockDevice().getName();
            if (this.hostCheckBoxes != null) {
                for (Host h : this.hostCheckBoxes.keySet()) {
                    if (this.blockDevInfo.getHost() == h || !this.hostCheckBoxes.get(h).isSelected()) continue;
                    for (BlockDevice b : h.getBlockDevices()) {
                        long oTaken;
                        long oFree;
                        if (!lvm.equals(b.getName()) && (oBDI == null || oBDI.getBlockDevice() != b) || (oFree = h.getFreeInVolumeGroup(b.getVolumeGroup()) / 1024L) + (oTaken = Long.parseLong(b.getBlockSize())) >= max) continue;
                        max = oFree + oTaken;
                    }
                }
            }
            maxBlockSize = Long.toString(max);
        }
        catch (Exception e) {
            Tools.appWarning("could not get max size");
        }
        return maxBlockSize;
    }

    private class EnableResizeRunnable
    implements Runnable {
        private final boolean enable;

        public EnableResizeRunnable(boolean enable) {
            this.enable = enable;
        }

        @Override
        public void run() {
            boolean e = this.enable;
            if (this.enable) {
                long oldSize = Tools.convertToKilobytes(LVResize.this.oldSizeWi.getStringValue());
                long size = Tools.convertToKilobytes(LVResize.this.sizeWi.getStringValue());
                String maxBlockSize = LVResize.this.getMaxBlockSize();
                long maxSize = Long.parseLong(maxBlockSize);
                LVResize.this.maxSizeWi.setValue(Tools.convertKilobytes(maxBlockSize));
                if (oldSize >= size || size > maxSize) {
                    e = false;
                    LVResize.this.sizeWi.wrongValue();
                } else {
                    LVResize.this.sizeWi.setBackground("", "", true);
                }
            }
            LVResize.this.resizeButton.setEnabled(e);
        }
    }
}

