/*
 * Decompiled with CFR 0.152.
 */
package lcmc.gui.dialog.host;

import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SpringLayout;
import lcmc.data.Host;
import lcmc.gui.SpringUtilities;
import lcmc.gui.dialog.WizardDialog;
import lcmc.gui.dialog.host.CheckInstallation;
import lcmc.gui.dialog.host.DialogHost;
import lcmc.utilities.ConvertCmdCallback;
import lcmc.utilities.ExecCallback;
import lcmc.utilities.SSH;
import lcmc.utilities.Tools;

final class HeartbeatInst
extends DialogHost {
    private static final long serialVersionUID = 1L;
    private WizardDialog nextDialogObject = null;

    HeartbeatInst(WizardDialog previousDialog, Host host) {
        super(previousDialog, host);
    }

    void checkAnswer(String ans, String installMethod) {
        this.nextDialogObject = new CheckInstallation(this.getPreviousDialog().getPreviousDialog(), this.getHost());
        this.progressBarDone();
        this.answerPaneSetText(Tools.getString("Dialog.Host.HeartbeatInst.InstOk"));
        this.enableComponents(new JComponent[]{this.buttonClass(this.backButton())});
        this.buttonClass(this.nextButton()).requestFocus();
        if (Tools.getConfigData().getAutoOptionHost("hbinst") != null) {
            Tools.sleep(1000);
            this.pressNextButton();
        }
    }

    @Override
    protected void initDialog() {
        super.initDialog();
        this.enableComponentsLater(new JComponent[]{this.buttonClass(this.nextButton())});
    }

    @Override
    protected void initDialogAfterVisible() {
        this.installHeartbeat();
    }

    private void installHeartbeat() {
        String arch = this.getHost().getDistString("HbPmInst.install." + this.getHost().getArch());
        if (arch == null) {
            arch = this.getHost().getArch();
        }
        final String archString = arch.replaceAll("i686", "i386");
        String installCommand = "HbPmInst.install";
        final String installMethod = this.getHost().getHbPmInstallMethod();
        if (installMethod != null) {
            installCommand = "HbPmInst.install." + installMethod;
        }
        Tools.getConfigData().setLastHbPmInstalledMethod(this.getHost().getDistString("HbPmInst.install.text." + installMethod));
        Tools.getConfigData().setLastInstalledClusterStack("Heartbeat");
        this.getHost().execCommandInBash(installCommand, this.getProgressBar(), new ExecCallback(){

            @Override
            public void done(String ans) {
                HeartbeatInst.this.checkAnswer(ans, installMethod);
            }

            @Override
            public void doneError(String ans, int exitCode) {
                HeartbeatInst.this.printErrorAndRetry(Tools.getString("Dialog.Host.HeartbeatInst.InstError"), ans, exitCode);
            }
        }, new ConvertCmdCallback(){

            @Override
            public String convert(String command) {
                return command.replaceAll("@ARCH@", archString);
            }
        }, true, SSH.DEFAULT_COMMAND_TIMEOUT_LONG);
    }

    @Override
    public WizardDialog nextDialog() {
        return this.nextDialogObject;
    }

    @Override
    protected String getHostDialogTitle() {
        return Tools.getString("Dialog.Host.HeartbeatInst.Title");
    }

    @Override
    protected String getDescription() {
        return Tools.getString("Dialog.Host.HeartbeatInst.Description");
    }

    @Override
    protected JComponent getInputPane() {
        JPanel pane = new JPanel(new SpringLayout());
        pane.add(this.getProgressBarPane());
        pane.add(this.getAnswerPane(Tools.getString("Dialog.Host.HeartbeatInst.Executing")));
        SpringUtilities.makeCompactGrid(pane, 2, 1, 0, 0, 0, 0);
        return pane;
    }
}

