/*
 * Decompiled with CFR 0.152.
 */
package lcmc.gui.dialog.host;

import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SpringLayout;
import lcmc.data.Host;
import lcmc.gui.SpringUtilities;
import lcmc.gui.dialog.WizardDialog;
import lcmc.gui.dialog.host.DialogHost;
import lcmc.gui.dialog.host.DistDetection;
import lcmc.utilities.ExecCallback;
import lcmc.utilities.SSH;
import lcmc.utilities.Tools;

public class Devices
extends DialogHost {
    private static final long serialVersionUID = 1L;

    public Devices(WizardDialog previousDialog, Host host) {
        super(previousDialog, host);
    }

    final void checkAnswer(String ans) {
        if ("".equals(ans) || "\n".equals(ans)) {
            this.progressBarDoneError();
            this.answerPaneSetTextError(Tools.getString("Dialog.Host.Devices.CheckError"));
            this.enableComponents();
            this.buttonClass(this.nextButton()).requestFocus();
        } else {
            this.getHost().parseHostInfo(ans);
            this.progressBarDone();
            this.answerPaneSetText(ans);
            this.enableComponents();
            this.buttonClass(this.nextButton()).requestFocus();
        }
        if (!Tools.getConfigData().getAutoHosts().isEmpty()) {
            Tools.sleep(1000);
            this.pressNextButton();
        }
    }

    @Override
    protected final void initDialog() {
        super.initDialog();
        this.enableComponentsLater(this.nextButtons());
    }

    @Override
    protected final void initDialogAfterVisible() {
        Thread t = new Thread(new Runnable(){

            @Override
            public void run() {
                Devices.this.getHost().getSSH().installGuiHelper();
                Devices.this.getAllInfo();
            }
        });
        t.start();
    }

    protected final void getAllInfo() {
        this.enableComponentsLater(this.nextButtons());
        SSH.ExecCommandThread t = this.getHost().execCommand("GetHostAllInfo", this.getProgressBar(), new ExecCallback(){

            @Override
            public void done(String ans) {
                Devices.this.checkAnswer(ans);
            }

            @Override
            public void doneError(String ans, int exitCode) {
                Devices.this.printErrorAndRetry(Tools.getString("Dialog.Host.Devices.CheckError"), ans, exitCode);
            }
        }, null, true, SSH.DEFAULT_COMMAND_TIMEOUT);
        this.setCommandThread(t);
    }

    @Override
    public WizardDialog nextDialog() {
        return new DistDetection(this, this.getHost());
    }

    @Override
    protected String getHostDialogTitle() {
        return Tools.getString("Dialog.Host.Devices.Title");
    }

    @Override
    protected String getDescription() {
        return Tools.getString("Dialog.Host.Devices.Description");
    }

    @Override
    protected final JComponent getInputPane() {
        JPanel pane = new JPanel(new SpringLayout());
        pane.add(this.getProgressBarPane());
        pane.add(this.getAnswerPane(Tools.getString("Dialog.Host.Devices.Executing")));
        SpringUtilities.makeCompactGrid(pane, 2, 1, 0, 0, 0, 0);
        return pane;
    }

    protected JComponent[] nextButtons() {
        return new JComponent[]{this.buttonClass(this.nextButton())};
    }
}

